/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BinaryRelation<T, U> {
    private final Map<T, Set<U>> mBacking = new HashMap<T, Set<U>>();

    public BinaryRelation() {
    }

    public BinaryRelation(Map<T, U> map) {
        for (Map.Entry<T, U> entry : map.entrySet()) {
            this.mBacking.put(entry.getKey(), Collections.singleton(entry.getValue()));
        }
    }

    public void addPair(T t, U u) {
        Set<U> set = this.mBacking.get(t);
        if (set == null) {
            set = new HashSet<U>();
            this.mBacking.put(t, set);
        }
        set.add(u);
    }

    public Set<T> getDomain() {
        return this.mBacking.keySet();
    }

    public Set<U> getImage(T t) {
        return this.mBacking.get(t);
    }

    public boolean isFunction() {
        for (Map.Entry<T, Set<U>> entry : this.mBacking.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            return false;
        }
        return true;
    }

    public Map<T, U> getFunction() {
        assert (this.isFunction());
        HashMap<T, U> hashMap = new HashMap<T, U>();
        for (Map.Entry<T, Set<U>> entry : this.mBacking.entrySet()) {
            assert (entry.getValue().size() == 1) : "no function";
            hashMap.put(entry.getKey(), entry.getValue().iterator().next());
        }
        return hashMap;
    }

    public Set<T> getPreImage(U u) {
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : this.getDomain()) {
            if (!this.getImage(t).contains(u)) continue;
            hashSet.add(t);
        }
        return hashSet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<T, Set<U>> entry : this.mBacking.entrySet()) {
            for (U u : entry.getValue()) {
                stringBuilder.append("(" + String.valueOf(entry.getKey()) + ", " + String.valueOf(u) + ")\n");
            }
        }
        return stringBuilder.toString();
    }

    public void removePair(T t, U u) {
        Set<U> set = this.mBacking.get(t);
        if (set != null) {
            set.remove(u);
        }
    }

    public boolean isInjective() {
        for (Map.Entry<T, Set<U>> entry : this.mBacking.entrySet()) {
            for (Map.Entry<T, Set<U>> entry2 : this.mBacking.entrySet()) {
                if (entry.equals(entry2)) continue;
                HashSet hashSet = new HashSet(entry.getValue());
                hashSet.retainAll((Collection)entry2.getValue());
                if (hashSet.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

