/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClauseEprQuantifiedLiteral
extends ClauseEprLiteral {
    private final EprQuantifiedPredicateAtom mAtom;
    Map<Integer, Map<ClauseEprQuantifiedLiteral, Set<Integer>>> identicalVariablePositionsInOtherClauseLiterals = new HashMap<Integer, Map<ClauseEprQuantifiedLiteral, Set<Integer>>>();
    private final SortedSet<TermVariable> mDawgSignature;
    private final ApplicationTerm[] mGroundArguments;
    private final int[] mVariableArguments;
    final int[] mClauseToPredPosition;

    public ClauseEprQuantifiedLiteral(boolean bl, EprQuantifiedPredicateAtom eprQuantifiedPredicateAtom, EprClause eprClause, EprTheory eprTheory) {
        super(bl, eprQuantifiedPredicateAtom, eprClause, eprTheory);
        this.mAtom = eprQuantifiedPredicateAtom;
        TreeSet treeSet = new TreeSet(EprHelpers.getColumnNamesComparator());
        Term[] termArray = eprQuantifiedPredicateAtom.getArguments();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (term instanceof TermVariable) {
                treeSet.add((TermVariable)term);
            }
            ++n2;
        }
        this.mDawgSignature = treeSet;
        this.mGroundArguments = new ApplicationTerm[this.mArgumentTerms.size()];
        this.mVariableArguments = new int[this.mArgumentTerms.size()];
        this.mClauseToPredPosition = new int[this.mEprClause.getVariables().size()];
        int n3 = 0;
        while (n3 < this.mClauseToPredPosition.length) {
            this.mClauseToPredPosition[n3] = -1;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.mArgumentTerms.size()) {
            Term term = (Term)this.mArgumentTerms.get(n3);
            if (term instanceof ApplicationTerm) {
                this.mGroundArguments[n3] = (ApplicationTerm)term;
                this.mVariableArguments[n3] = -1;
            } else {
                n = this.mEprClause.getVariablePos((TermVariable)term);
                this.mGroundArguments[n3] = null;
                this.mVariableArguments[n3] = n;
                this.mClauseToPredPosition[n] = n3;
            }
            ++n3;
        }
    }

    @Override
    public DawgState<ApplicationTerm, EprTheory.TriBool> computeDawg() {
        DawgState<ApplicationTerm, EprTheory.TriBool> dawgState = this.mEprPredicateAtom.mEprPredicate.getDawg();
        if (!this.mPolarity) {
            dawgState = this.mDawgFactory.createMapped(dawgState, triBool -> triBool.negate());
        }
        return this.litDawg2clauseDawg(dawgState);
    }

    @Override
    public boolean isDisjointFrom(DawgState<ApplicationTerm, Boolean> dawgState) {
        return DawgFactory.isEmpty(this.mDawgFactory.projectWithMap(dawgState, this.mGroundArguments));
    }

    @Override
    public ApplicationTerm[] getInstantiatedArguments(ApplicationTerm[] applicationTermArray) {
        ApplicationTerm[] applicationTermArray2 = new ApplicationTerm[this.getArguments().size()];
        int n = 0;
        while (n < applicationTermArray2.length) {
            applicationTermArray2[n] = this.mGroundArguments[n] != null ? this.mGroundArguments[n] : applicationTermArray[this.mVariableArguments[n]];
            ++n;
        }
        return applicationTermArray2;
    }

    @Override
    public Clause getGroundingForGroundLiteral(DawgState<ApplicationTerm, Boolean> dawgState, Literal literal) {
        ApplicationTerm applicationTerm = (ApplicationTerm)literal.getAtom().getSMTFormula(this.mEprTheory.getTheory());
        List<ApplicationTerm> list = EprHelpers.convertTermArrayToConstantList(applicationTerm.getParameters());
        HashMap<TermVariable, ApplicationTerm> hashMap = new HashMap<TermVariable, ApplicationTerm>();
        int n = 0;
        while (n < this.getArguments().size()) {
            if (this.getArguments().get(n) instanceof TermVariable) {
                hashMap.put((TermVariable)this.getArguments().get(n), list.get(n));
            } else assert (this.getArguments().get(n) == list.get(n));
            ++n;
        }
        DawgState<ApplicationTerm, Boolean> dawgState2 = this.mDawgFactory.createIntersection(dawgState, this.mDawgFactory.createFromSelectMap(this.mEprClause.getVariables(), hashMap));
        Set<Clause> set = this.getClause().getGroundings(dawgState2);
        return set.iterator().next();
    }

    public EprQuantifiedPredicateAtom getAtom() {
        return this.mAtom;
    }

    public boolean isEqualityLiteral() {
        return this.mAtom instanceof EprQuantifiedEqualityAtom;
    }

    @Override
    public <V> DawgState<ApplicationTerm, V> litDawg2clauseDawg(DawgState<ApplicationTerm, V> dawgState) {
        DawgState<ApplicationTerm, V> dawgState2 = this.mDawgFactory.projectWithMap(dawgState, this.mGroundArguments);
        dawgState2 = this.mDawgFactory.remap(dawgState2, this.mVariableArguments, this.mEprClause.getVariables());
        return dawgState2;
    }

    @Override
    public DawgState<ApplicationTerm, Boolean> clauseDawg2litDawg(DawgState<ApplicationTerm, Boolean> dawgState) {
        return this.mDawgFactory.translateClauseSigToPredSig(dawgState, this.mClauseToPredPosition, this.mGroundArguments, this.getEprPredicate().getTermVariablesForArguments());
    }
}

