/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.yaml;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.UltimateCore;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopEntryAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.WitnessInvariant;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.WitnessProcedureContract;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.FormatVersion;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.FunctionContract;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Location;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.LocationInvariant;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.LoopInvariant;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WitnessEntry;
import de.uni_freiburg.informatik.ultimate.witnessprinter.preferences.PreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.MetadataProvider;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.YamlWitnessWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class YamlCorrectnessWitnessGenerator {
    private static final String[] ACSL_SUBSTRING = new String[]{"\\old", "\\result", "exists", "forall", "\\at"};
    private final ILogger mLogger;
    private final IIcfg<? extends IcfgLocation> mIcfg;
    private final FormatVersion mFormatVersion;
    private final boolean mIsAcslAllowed;
    private final YamlWitnessWriter mWriter;

    public YamlCorrectnessWitnessGenerator(IIcfg<? extends IcfgLocation> iIcfg, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mIcfg = iIcfg;
        IPreferenceProvider iPreferenceProvider = PreferenceInitializer.getPreferences(iUltimateServiceProvider);
        this.mFormatVersion = FormatVersion.fromString((String)iPreferenceProvider.getString("YAML Format version"));
        this.mIsAcslAllowed = this.mFormatVersion.compareTo(new FormatVersion(2, 1)) >= 0;
        String string = iPreferenceProvider.getString("Graph data producer");
        String string2 = iPreferenceProvider.getString("Graph data programhash");
        String string3 = iPreferenceProvider.getString("Graph data specification");
        String string4 = iPreferenceProvider.getString("Graph data architecture");
        String string5 = new UltimateCore().getUltimateVersionString();
        String string6 = ILocation.getAnnotation(this.mIcfg).getFileName();
        Map<String, String> map = Map.of(string6, string2);
        this.mWriter = YamlWitnessWriter.construct(this.mFormatVersion, new MetadataProvider(this.mFormatVersion, string, string5, map, string3, string4, "C"));
    }

    private Witness getWitness() {
        List<IcfgLocation> list = this.mIcfg.getProgramPoints().values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
        List<WitnessEntry> list2 = this.extractInvariants(list);
        List<WitnessEntry> list3 = this.extractFunctionContracts(list);
        return new Witness(DataStructureUtils.concat(list2, list3));
    }

    private List<WitnessEntry> extractInvariants(List<IcfgLocation> list) {
        ArrayList<WitnessEntry> arrayList = new ArrayList<WitnessEntry>();
        for (IcfgLocation icfgLocation : list) {
            String string;
            ILocation iLocation = ILocation.getAnnotation((IElement)icfgLocation);
            if (iLocation == null || (string = this.filterInvariant(WitnessInvariant.getAnnotation((IElement)icfgLocation))) == null) continue;
            LoopEntryAnnotation loopEntryAnnotation = LoopEntryAnnotation.getAnnotation((IElement)icfgLocation);
            if (loopEntryAnnotation != null && loopEntryAnnotation.getLoopEntryType() == LoopEntryAnnotation.LoopEntryType.WHILE) {
                arrayList.add((WitnessEntry)new LoopInvariant(this.getWitnessLocation(iLocation), string, this.getExpressionFormat(string)));
                continue;
            }
            arrayList.add((WitnessEntry)new LocationInvariant(this.getWitnessLocation(iLocation), string, this.getExpressionFormat(string)));
        }
        return arrayList;
    }

    private List<WitnessEntry> extractFunctionContracts(List<IcfgLocation> list) {
        ArrayList<WitnessEntry> arrayList = new ArrayList<WitnessEntry>();
        for (IcfgLocation icfgLocation : list) {
            WitnessProcedureContract witnessProcedureContract;
            ILocation iLocation = ILocation.getAnnotation((IElement)icfgLocation);
            if (iLocation == null || (witnessProcedureContract = WitnessProcedureContract.getAnnotation((IElement)icfgLocation)) == null) continue;
            String string = witnessProcedureContract.getRequires();
            String string2 = witnessProcedureContract.getEnsures();
            arrayList.add((WitnessEntry)new FunctionContract(this.getWitnessLocation(iLocation), string, string2, this.getExpressionFormat(string, string2)));
        }
        return arrayList;
    }

    private Location getWitnessLocation(ILocation iLocation) {
        return new Location(iLocation.getFileName(), Integer.valueOf(iLocation.getStartLine()), iLocation.getStartColumn() < 0 ? null : Integer.valueOf(iLocation.getStartColumn()), iLocation.getFunction());
    }

    public String makeYamlString() {
        return this.mWriter.toString(this.getWitness());
    }

    private String getExpressionFormat(String ... stringArray) {
        if (this.mFormatVersion.getMajor() == 0) {
            return "C";
        }
        if (!this.mIsAcslAllowed || Arrays.stream(stringArray).filter(Objects::nonNull).noneMatch(YamlCorrectnessWitnessGenerator::containsACSL)) {
            return "c_expression";
        }
        return "acsl_expression";
    }

    private static boolean containsACSL(String string) {
        return Arrays.stream(ACSL_SUBSTRING).anyMatch(string::contains);
    }

    private String filterInvariant(WitnessInvariant<?> witnessInvariant) {
        if (witnessInvariant == null) {
            return null;
        }
        String string = witnessInvariant.getInvariant().toString();
        if (!this.mIsAcslAllowed && YamlCorrectnessWitnessGenerator.containsACSL(string)) {
            this.mLogger.warn((Object)("Not writing invariant because ACSL is forbidden: " + string));
            return null;
        }
        return string;
    }
}

