/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class TransFormula
implements ITransitionRelation {
    protected final Map<IProgramVar, TermVariable> mInVars;
    protected final Map<IProgramVar, TermVariable> mOutVars;
    protected final Set<TermVariable> mAuxVars;
    protected final Set<IProgramConst> mNonTheoryConsts;

    public TransFormula(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, Set<TermVariable> set, Set<IProgramConst> set2) {
        this.mInVars = map;
        this.mOutVars = map2;
        this.mAuxVars = set;
        this.mNonTheoryConsts = set2;
    }

    public abstract Term getFormula();

    @Override
    public Map<IProgramVar, TermVariable> getInVars() {
        return Collections.unmodifiableMap(this.mInVars);
    }

    @Override
    public Map<IProgramVar, TermVariable> getOutVars() {
        return Collections.unmodifiableMap(this.mOutVars);
    }

    @Override
    public Set<IProgramConst> getNonTheoryConsts() {
        return Collections.unmodifiableSet(this.mNonTheoryConsts);
    }

    @Override
    public Set<TermVariable> getAuxVars() {
        return Collections.unmodifiableSet(this.mAuxVars);
    }

    @Override
    public boolean isHavocedOut(IProgramVar iProgramVar) {
        TermVariable termVariable;
        TermVariable termVariable2 = this.mInVars.get(iProgramVar);
        if (termVariable2 == (termVariable = this.mOutVars.get(iProgramVar))) {
            return false;
        }
        return !Arrays.asList(this.getFormula().getFreeVars()).contains(termVariable);
    }

    @Override
    public boolean isHavocedIn(IProgramVar iProgramVar) {
        TermVariable termVariable;
        TermVariable termVariable2 = this.mInVars.get(iProgramVar);
        if (termVariable2 == (termVariable = this.mOutVars.get(iProgramVar))) {
            return false;
        }
        return !Arrays.asList(this.getFormula().getFreeVars()).contains(termVariable2);
    }

    public static Set<IProgramVar> collectAllProgramVars(TransFormula transFormula) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>(transFormula.getInVars().keySet());
        hashSet.addAll(transFormula.getOutVars().keySet());
        return hashSet;
    }
}

