/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.ExplicitLhsPolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolutionBuilder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermOperations;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.INonSolverScript;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SolveForSubjectUtils {
    static MultiCaseSolvedBinaryRelation solveForSubject(ManagedScript managedScript, Term term, MultiCaseSolvedBinaryRelation.Xnf xnf, PolynomialRelation polynomialRelation, Set<TermVariable> set, boolean bl) {
        MultiCaseSolvedBinaryRelation multiCaseSolvedBinaryRelation = bl && SmtSortUtils.isNumericSort(term.getSort()) ? SolveForSubjectUtils.findTreatableDivModSubterm(managedScript, term, polynomialRelation.getPolynomialTerm(), null, xnf, polynomialRelation.toTerm(managedScript.getScript()), set) : null;
        if (multiCaseSolvedBinaryRelation == null) {
            multiCaseSolvedBinaryRelation = SolveForSubjectUtils.solveForSubjectWithoutTreatableDivMod(managedScript.getScript(), term, polynomialRelation, xnf, set);
        }
        if (multiCaseSolvedBinaryRelation == null) {
            return null;
        }
        assert (multiCaseSolvedBinaryRelation.isSubjectOnlyOnRhs()) : "subject not only LHS";
        assert (managedScript instanceof INonSolverScript || SmtUtils.checkEquivalence(polynomialRelation.toTerm(managedScript.getScript()), multiCaseSolvedBinaryRelation.toTerm(managedScript.getScript()), managedScript.getScript()) != Script.LBool.SAT) : "solveForSubject unsound";
        return multiCaseSolvedBinaryRelation;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static MultiCaseSolvedBinaryRelation solveForSubjectWithoutTreatableDivMod(Script script, Term term, PolynomialRelation polynomialRelation, MultiCaseSolvedBinaryRelation.Xnf xnf, Set<TermVariable> set) throws AssertionError {
        Term term2;
        MultiCaseSolvedBinaryRelation.IntricateOperation intricateOperation;
        Object object;
        ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation;
        ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation2;
        block13: {
            explicitLhsPolynomialRelation2 = ExplicitLhsPolynomialRelation.moveMonomialToLhs(script, term, polynomialRelation);
            if (explicitLhsPolynomialRelation2 == null) {
                return null;
            }
            explicitLhsPolynomialRelation = explicitLhsPolynomialRelation2.divInvertible(explicitLhsPolynomialRelation2.getLhsCoefficient());
            if (explicitLhsPolynomialRelation == null) {
                if (SmtSortUtils.isRealSort(explicitLhsPolynomialRelation2.getLhsMonomial().getSort())) {
                    throw new AssertionError();
                }
                if (SmtSortUtils.isIntSort(explicitLhsPolynomialRelation2.getLhsMonomial().getSort())) {
                    object = explicitLhsPolynomialRelation2.divideByIntegerCoefficient(script, set);
                    if (object == null) {
                        return null;
                    }
                    explicitLhsPolynomialRelation = (ExplicitLhsPolynomialRelation)object.getFirst();
                    intricateOperation = MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT;
                    term2 = (Term)object.getSecond();
                    break block13;
                } else {
                    if (SmtSortUtils.isBitvecSort(explicitLhsPolynomialRelation2.getLhsMonomial().getSort())) {
                        return null;
                    }
                    throw new AssertionError((Object)"unsupported sort");
                }
            }
            intricateOperation = null;
            term2 = null;
        }
        if (explicitLhsPolynomialRelation.getLhsMonomial().isLinear()) {
            void var12_15;
            Object object2;
            assert (explicitLhsPolynomialRelation.getLhsMonomial().getSingleVariable().equals(term));
            object = new MultiCaseSolutionBuilder(term, xnf);
            ArrayList<Case> arrayList = new ArrayList<Case>();
            SolvedBinaryRelation solvedBinaryRelation = intricateOperation == null ? new SolvedBinaryRelation(explicitLhsPolynomialRelation.getLhsMonomial().getSingleVariable(), explicitLhsPolynomialRelation.getRhs().toTerm(script), explicitLhsPolynomialRelation.getRelationSymbol(), new MultiCaseSolvedBinaryRelation.IntricateOperation[0]) : new SolvedBinaryRelation(explicitLhsPolynomialRelation.getLhsMonomial().getSingleVariable(), explicitLhsPolynomialRelation.getRhs().toTerm(script), explicitLhsPolynomialRelation.getRelationSymbol(), intricateOperation);
            if (SolveForSubjectUtils.isDerIntegerDivisionSupportingTermRequired(xnf, term.getSort(), explicitLhsPolynomialRelation.getRelationSymbol()) && term2 != null) {
                object2 = SolveForSubjectUtils.constructDerIntegerDivisionSupportingTerm(script, term2);
                Set<SupportingTerm> set2 = Collections.singleton(object2);
            } else {
                Set set3 = Collections.emptySet();
            }
            arrayList.add(new Case(solvedBinaryRelation, (Set<SupportingTerm>)var12_15, xnf));
            if (SolveForSubjectUtils.isAntiDerIntegerDivisionCaseRequired(xnf, term.getSort(), explicitLhsPolynomialRelation.getRelationSymbol()) && term2 != null) {
                object2 = new HashSet();
                explicitLhsPolynomialRelation.getRelationSymbol().equals((Object)RelationSymbol.DISTINCT);
                Term term3 = term2;
                SupportingTerm supportingTerm = new SupportingTerm(term3, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT, Collections.emptySet());
                object2.add(supportingTerm);
                Case case_ = new Case(null, (Set<SupportingTerm>)object2, xnf);
                arrayList.add(case_);
            }
            ((MultiCaseSolutionBuilder)object).splitCases(arrayList);
            return ((MultiCaseSolutionBuilder)object).buildResult();
        }
        if (SmtSortUtils.isBitvecSort(explicitLhsPolynomialRelation2.getLhsMonomial().getSort()) && !explicitLhsPolynomialRelation.getLhsMonomial().isLinear()) {
            return null;
        }
        return explicitLhsPolynomialRelation.divByMonomial(script, term, xnf, set, term2, intricateOperation);
    }

    private static MultiCaseSolvedBinaryRelation tryToHandleDivModSubterm(ManagedScript managedScript, Term term, MultiCaseSolvedBinaryRelation.Xnf xnf, ApplicationTerm applicationTerm, Term term2, Set<TermVariable> set) {
        Object object;
        SupportingTerm supportingTerm;
        Term term3;
        Term term4 = SmtUtils.mul(managedScript.getScript(), "*", Arrays.copyOfRange(applicationTerm.getParameters(), 1, applicationTerm.getParameters().length));
        assert (term4 instanceof ConstantTerm) : "not constant";
        Sort sort = term.getSort();
        int n = applicationTerm.toString().length();
        TermVariable termVariable = managedScript.variable(SmtUtils.removeSmtQuoteCharacters("aux_div_" + String.valueOf(term) + "_" + n), sort);
        TermVariable termVariable3 = managedScript.variable(SmtUtils.removeSmtQuoteCharacters("aux_mod_" + String.valueOf(term) + "_" + n), sort);
        if (Arrays.stream(term2.getFreeVars()).anyMatch(termVariable2 -> termVariable2.getName().equals(termVariable.getName()))) {
            throw new AssertionError((Object)("Possible infinite loop detected " + String.valueOf(termVariable) + " already exists"));
        }
        if (Arrays.stream(term2.getFreeVars()).anyMatch(termVariable2 -> termVariable2.getName().equals(termVariable3.getName()))) {
            throw new AssertionError((Object)("Possible infinite loop detected " + String.valueOf(termVariable3) + " already exists"));
        }
        Object object3 = SmtUtils.mul(managedScript.getScript(), sort, new Term[]{term4, termVariable});
        Object object4 = SmtUtils.sum(managedScript.getScript(), sort, new Term[]{termVariable3, object3});
        Object object5 = BinaryRelation.toTerm(managedScript.getScript(), SolveForSubjectUtils.negateForCnf(RelationSymbol.EQ, xnf), applicationTerm.getParameters()[0], (Term)object4);
        AbstractCollection abstractCollection = new HashSet<TermVariable>(set);
        ((HashSet)abstractCollection).add((TermVariable)termVariable);
        ((HashSet)abstractCollection).add((TermVariable)termVariable3);
        MultiCaseSolvedBinaryRelation multiCaseSolvedBinaryRelation = PolynomialRelation.of(managedScript.getScript(), (Term)object5).solveForSubject(managedScript, term, xnf, (Set<TermVariable>)((Object)abstractCollection), true);
        if (multiCaseSolvedBinaryRelation == null) {
            return null;
        }
        object3 = new MultiCaseSolutionBuilder(term, xnf);
        object4 = new LinkedHashSet();
        object4.add(termVariable3);
        object5 = new HashMap();
        if (SmtUtils.isIntMod((Term)applicationTerm)) {
            object5.put(applicationTerm, termVariable3);
            ((MultiCaseSolutionBuilder)object3).reportAdditionalAuxiliaryVariable(termVariable);
        } else if (SmtUtils.isIntDiv((Term)applicationTerm)) {
            object4.add(termVariable);
            object5.put(applicationTerm, termVariable);
        } else {
            throw new AssertionError((Object)"input must be div or mod");
        }
        abstractCollection = new ArrayList();
        for (Case object22 : multiCaseSolvedBinaryRelation.getCases()) {
            boolean bl;
            if (object22.getSolvedBinaryRelation() != null) {
                object5.put(term, object22.getSolvedBinaryRelation().getRightHandSide());
            }
            term3 = Substitution.apply(managedScript, (Map<? extends Term, ? extends Term>)object5, term2);
            if (object22.getSolvedBinaryRelation() == null && (bl = SmtUtils.isSubterm(term3, term))) {
                return null;
            }
            supportingTerm = new SupportingTerm(term3, MultiCaseSolvedBinaryRelation.IntricateOperation.MUL_BY_INTEGER_CONSTANT, new HashSet<TermVariable>((Collection<TermVariable>)object4));
            object = new HashSet<SupportingTerm>(object22.getSupportingTerms());
            object.add((SupportingTerm)supportingTerm);
            Case case_ = new Case(object22.getSolvedBinaryRelation(), (Set<SupportingTerm>)object, xnf);
            abstractCollection.add((Case)case_);
        }
        ((MultiCaseSolutionBuilder)object3).splitCases(abstractCollection);
        for (TermVariable termVariable4 : multiCaseSolvedBinaryRelation.getAuxiliaryVariables()) {
            ((MultiCaseSolutionBuilder)object3).reportAdditionalAuxiliaryVariable(termVariable4);
        }
        for (MultiCaseSolvedBinaryRelation.IntricateOperation intricateOperation : multiCaseSolvedBinaryRelation.getIntricateOperations()) {
            ((MultiCaseSolutionBuilder)object3).reportAdditionalIntricateOperation(intricateOperation);
        }
        Term term5 = BinaryRelation.toTerm(managedScript.getScript(), SolveForSubjectUtils.negateForCnf(RelationSymbol.LEQ, xnf), Rational.ZERO.toTerm(sort), (Term)termVariable3);
        SupportingTerm supportingTerm2 = new SupportingTerm(term5, MultiCaseSolvedBinaryRelation.IntricateOperation.MUL_BY_INTEGER_CONSTANT, (Set<TermVariable>)object4);
        term3 = BinaryRelation.toTerm(managedScript.getScript(), SolveForSubjectUtils.negateForCnf(RelationSymbol.LESS, xnf), (Term)termVariable3, SmtUtils.abs(managedScript.getScript(), term4));
        supportingTerm = new SupportingTerm(term3, MultiCaseSolvedBinaryRelation.IntricateOperation.MUL_BY_INTEGER_CONSTANT, (Set<TermVariable>)object4);
        ((MultiCaseSolutionBuilder)object3).addAtoms(supportingTerm, supportingTerm2);
        object = ((MultiCaseSolutionBuilder)object3).buildResult();
        assert (((MultiCaseSolvedBinaryRelation)object).isSubjectOnlyOnRhs()) : "subject not only LHS";
        assert (managedScript instanceof INonSolverScript || SmtUtils.checkEquivalence(term2, ((MultiCaseSolvedBinaryRelation)object).toTerm(managedScript.getScript()), managedScript.getScript()) != Script.LBool.SAT) : "solveForSubject unsound";
        return object;
    }

    @Deprecated
    private static Term constructRhsIntegerQuotient(Script script, RelationSymbol relationSymbol, Term term, boolean bl, Term term2) {
        return switch (relationSymbol) {
            case RelationSymbol.LESS -> {
                if (bl) {
                    yield SolveForSubjectUtils.constructRhsIntegerQuotientHelper(script, term, Rational.ONE, term2);
                }
                yield SolveForSubjectUtils.constructRhsIntegerQuotientHelper(script, term, Rational.MONE, term2);
            }
            case RelationSymbol.GREATER -> SmtUtils.division(script, term.getSort(), SolveForSubjectUtils.prepend(term, term2));
            case RelationSymbol.LEQ -> SmtUtils.division(script, term.getSort(), SolveForSubjectUtils.prepend(term, term2));
            case RelationSymbol.GEQ -> {
                if (bl) {
                    yield SolveForSubjectUtils.constructRhsIntegerQuotientHelper(script, term, Rational.ONE, term2);
                }
                yield SolveForSubjectUtils.constructRhsIntegerQuotientHelper(script, term, Rational.MONE, term2);
            }
            case RelationSymbol.EQ -> SmtUtils.division(script, term.getSort(), SolveForSubjectUtils.prepend(term, term2));
            case RelationSymbol.DISTINCT -> SmtUtils.division(script, term.getSort(), SolveForSubjectUtils.prepend(term, term2));
            case RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> throw new AssertionError((Object)("bitvector relation with integer not possible: " + String.valueOf((Object)relationSymbol)));
            default -> throw new AssertionError((Object)("unknown relation symbol: " + String.valueOf((Object)relationSymbol)));
        };
    }

    public static IPolynomialTerm constructRhsIntegerQuotient(Script script, RelationSymbol relationSymbol, IPolynomialTerm iPolynomialTerm, boolean bl, Term term, Set<TermVariable> set) {
        Object object;
        IPolynomialTerm iPolynomialTerm2;
        Rational rational;
        Rational rational2 = switch (relationSymbol) {
            case RelationSymbol.LESS -> {
                if (bl) {
                    rational = Rational.MONE;
                    yield Rational.ONE;
                }
                rational = Rational.MONE;
                yield Rational.MONE;
            }
            case RelationSymbol.GREATER -> {
                rational = Rational.ZERO;
                yield Rational.ZERO;
            }
            case RelationSymbol.LEQ -> {
                rational = Rational.ZERO;
                yield Rational.ZERO;
            }
            case RelationSymbol.GEQ -> {
                if (bl) {
                    rational = Rational.MONE;
                    yield Rational.ONE;
                }
                rational = Rational.MONE;
                yield Rational.MONE;
            }
            case RelationSymbol.EQ -> {
                rational = Rational.ZERO;
                yield Rational.ZERO;
            }
            case RelationSymbol.DISTINCT -> {
                rational = Rational.ZERO;
                yield Rational.ZERO;
            }
            case RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> throw new AssertionError((Object)("bitvector relation with integer not possible: " + String.valueOf((Object)relationSymbol)));
            default -> throw new AssertionError((Object)("unknown relation symbol: " + String.valueOf((Object)relationSymbol)));
        };
        IPolynomialTerm iPolynomialTerm3 = rational.equals((Object)Rational.ZERO) ? iPolynomialTerm : ((AbstractGeneralizedAffineTerm)iPolynomialTerm).add(rational);
        Rational rational3 = SmtUtils.tryToConvertToLiteral(term);
        if (rational3 == null) {
            iPolynomialTerm2 = Arrays.stream(iPolynomialTerm3.toTerm(script).getFreeVars()).anyMatch(set::contains) ? null : PolynomialTermOperations.convert(script, SmtUtils.divIntFlatten(script, iPolynomialTerm3.toTerm(script), term));
        } else {
            if (!rational3.isIntegral()) {
                throw new AssertionError((Object)"expected int");
            }
            if (rational3.isNegative() == bl) {
                throw new AssertionError((Object)"inconsistent information on sign");
            }
            object = rational3.numerator();
            iPolynomialTerm2 = ((AbstractGeneralizedAffineTerm)iPolynomialTerm3).divInt(script, (BigInteger)object, set);
        }
        if (iPolynomialTerm2 == null) {
            return null;
        }
        object = rational2.equals((Object)Rational.ZERO) ? iPolynomialTerm2 : ((AbstractGeneralizedAffineTerm)iPolynomialTerm2).add(rational2);
        return object;
    }

    @Deprecated
    private static Term constructRhsIntegerQuotientHelper(Script script, Term term, Rational rational, Term term2) {
        Term term3 = SmtUtils.rational2Term(script, Rational.MONE, term.getSort());
        Term term4 = SmtUtils.sum(script, term.getSort(), term, term3);
        Term term5 = ((IPolynomialTerm)new PolynomialTermTransformer(script).transform(term4)).toTerm(script);
        Term[] termArray = SolveForSubjectUtils.prepend(term5, term2);
        Term term6 = SmtUtils.division(script, term.getSort(), termArray);
        return SmtUtils.sum(script, term.getSort(), term6, SmtUtils.rational2Term(script, rational, term.getSort()));
    }

    static Term[] prepend(Term term, Term ... termArray) {
        ArrayList<Term> arrayList = new ArrayList<Term>(termArray.length + 1);
        arrayList.add(term);
        arrayList.addAll(Arrays.asList(termArray));
        Term[] termArray2 = arrayList.toArray(new Term[arrayList.size()]);
        return termArray2;
    }

    public static boolean tailIsConstant(List<Term> list) {
        assert (list.size() > 1);
        Iterator<Term> iterator = list.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof ConstantTerm) continue;
            return false;
        }
        return true;
    }

    static RelationSymbol negateForCnf(RelationSymbol relationSymbol, MultiCaseSolvedBinaryRelation.Xnf xnf) {
        if (xnf == MultiCaseSolvedBinaryRelation.Xnf.CNF) {
            return relationSymbol.negate();
        }
        return relationSymbol;
    }

    static boolean isDerIntegerDivisionSupportingTermRequired(MultiCaseSolvedBinaryRelation.Xnf xnf, Sort sort, RelationSymbol relationSymbol) {
        return SmtSortUtils.isIntSort(sort) && (relationSymbol == RelationSymbol.EQ && xnf == MultiCaseSolvedBinaryRelation.Xnf.DNF || relationSymbol == RelationSymbol.DISTINCT && xnf == MultiCaseSolvedBinaryRelation.Xnf.CNF);
    }

    static boolean isAntiDerIntegerDivisionCaseRequired(MultiCaseSolvedBinaryRelation.Xnf xnf, Sort sort, RelationSymbol relationSymbol) {
        return SmtSortUtils.isIntSort(sort) && (relationSymbol == RelationSymbol.DISTINCT && xnf == MultiCaseSolvedBinaryRelation.Xnf.DNF || relationSymbol == RelationSymbol.EQ && xnf == MultiCaseSolvedBinaryRelation.Xnf.CNF);
    }

    static SupportingTerm constructDerIntegerDivisionSupportingTerm(Script script, Term term) {
        SupportingTerm supportingTerm = new SupportingTerm(term, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT, Collections.emptySet());
        return supportingTerm;
    }

    private static MultiCaseSolvedBinaryRelation findTreatableDivModSubterm(ManagedScript managedScript, Term term, IPolynomialTerm iPolynomialTerm, ApplicationTerm applicationTerm, MultiCaseSolvedBinaryRelation.Xnf xnf, Term term2, Set<TermVariable> set) {
        for (Monomial monomial : iPolynomialTerm.getMonomial2Coefficient().keySet()) {
            for (Term term3 : monomial.getVariable2Exponent().keySet()) {
                Object object;
                IPolynomialTerm iPolynomialTerm2;
                MultiCaseSolvedBinaryRelation multiCaseSolvedBinaryRelation;
                if (!SmtUtils.isIntDiv(term3) && !SmtUtils.isIntMod(term3)) continue;
                ApplicationTerm applicationTerm2 = (ApplicationTerm)term3;
                if (applicationTerm2.getParameters().length > 2) {
                    throw new UnsupportedOperationException("Div with more than two parameters");
                }
                boolean bl = SmtUtils.isSubterm(applicationTerm2.getParameters()[0], term);
                boolean bl2 = SolveForSubjectUtils.tailIsConstant(Arrays.asList(applicationTerm2.getParameters()));
                if (!bl || (multiCaseSolvedBinaryRelation = SolveForSubjectUtils.findTreatableDivModSubterm(managedScript, term, iPolynomialTerm2 = (IPolynomialTerm)new PolynomialTermTransformer(managedScript.getScript()).transform(applicationTerm2.getParameters()[0]), object = bl2 ? applicationTerm2 : null, xnf, term2, set)) == null) continue;
                return multiCaseSolvedBinaryRelation;
            }
        }
        if (applicationTerm == null) {
            return null;
        }
        return SolveForSubjectUtils.tryToHandleDivModSubterm(managedScript, term, xnf, applicationTerm, term2, set);
    }

    public static boolean isVariableDivCaptured(SolvedBinaryRelation solvedBinaryRelation, Set<TermVariable> set) {
        if (solvedBinaryRelation.getIntricateOperation().contains((Object)MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT)) {
            Term term = solvedBinaryRelation.getRightHandSide();
            return SolveForSubjectUtils.someGivenTermVariableOccursInTerm(term, set);
        }
        return false;
    }

    @Deprecated
    private static boolean someGivenTermVariableOccursInTerm(Term term, Set<TermVariable> set) {
        Set<ApplicationTerm> set2 = SmtUtils.extractApplicationTerms("div", term, false);
        return set2.stream().anyMatch(applicationTerm -> Arrays.stream(applicationTerm.getFreeVars()).anyMatch(set::contains));
    }

    public static boolean isVariableDivCaptured(MultiCaseSolvedBinaryRelation multiCaseSolvedBinaryRelation, Set<TermVariable> set) {
        if (multiCaseSolvedBinaryRelation.getIntricateOperations().contains((Object)MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT)) {
            for (Case case_ : multiCaseSolvedBinaryRelation.getCases()) {
                if (case_.getSolvedBinaryRelation() != null && SolveForSubjectUtils.someGivenTermVariableOccursInTerm(case_.getSolvedBinaryRelation().getRightHandSide(), set)) {
                    return true;
                }
                for (SupportingTerm supportingTerm : case_.getSupportingTerms()) {
                    if (supportingTerm.getIntricateOperation() != MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT) continue;
                    if (!Arrays.stream(supportingTerm.getTerm().getFreeVars()).anyMatch(set::contains)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

