/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.AffineExpression;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.BoolValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.IfExpressionTree;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.IntervalProjection;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OctAssumeProcessor {
    private final OctPostOperator mPostOp;
    private final ILogger mLogger;
    private final IAbstractPostOperator<IntervalDomainState, IcfgEdge> mIntervalPostOperator;
    private final CodeBlockFactory mCodeBlockFactory;
    private final IBoogieSymbolTableVariableProvider mVariableProvider;

    public OctAssumeProcessor(ILogger iLogger, OctPostOperator octPostOperator, IAbstractPostOperator<IntervalDomainState, IcfgEdge> iAbstractPostOperator, CodeBlockFactory codeBlockFactory, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider) {
        this.mPostOp = octPostOperator;
        this.mLogger = iLogger;
        this.mIntervalPostOperator = iAbstractPostOperator;
        this.mCodeBlockFactory = codeBlockFactory;
        this.mVariableProvider = iBoogieSymbolTableVariableProvider;
    }

    public List<OctDomainState> assume(Expression expression, List<OctDomainState> list) {
        return this.processBooleanOperations(expression, false, list);
    }

    private List<OctDomainState> processBooleanOperations(Expression expression, boolean bl, List<OctDomainState> list2) {
        assert (TypeUtils.isBoolean(expression.getType())) : "Expression " + BoogiePrettyPrinter.print((Expression)expression) + " is not boolean";
        if (expression instanceof BooleanLiteral) {
            if (((BooleanLiteral)expression).getValue() ^ bl) {
                return list2;
            }
            return new ArrayList<OctDomainState>();
        }
        if (expression instanceof IdentifierExpression) {
            IProgramVarOrConst iProgramVarOrConst = this.mPostOp.getBoogieVar((IdentifierExpression)expression);
            BoolValue boolValue = BoolValue.get(!bl);
            list2.forEach(octDomainState -> octDomainState.assumeBooleanVar(iProgramVarOrConst, boolValue));
            return list2;
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            switch (unaryExpression.getOperator()) {
                case LOGICNEG: {
                    return this.processBooleanOperations(unaryExpression.getExpr(), !bl, list2);
                }
                case OLD: {
                    return list2;
                }
            }
            throw new UnsupportedOperationException("Unknown, unsupported or mistyped expression: " + String.valueOf(expression));
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            Expression expression2 = binaryExpression.getLeft();
            Expression expression3 = binaryExpression.getRight();
            switch (binaryExpression.getOperator()) {
                case LOGICAND: {
                    return bl ? this.assumeOr(expression2, true, expression3, true, list2) : this.assumeAnd(expression2, false, expression3, false, list2);
                }
                case LOGICOR: {
                    return bl ? this.assumeAnd(expression2, true, expression3, true, list2) : this.assumeOr(expression2, false, expression3, false, list2);
                }
                case LOGICIMPLIES: {
                    return bl ? this.assumeAnd(expression2, false, expression3, true, list2) : this.assumeOr(expression2, true, expression3, false, list2);
                }
                case LOGICIFF: {
                    return this.assumeIff(expression2, expression3, bl, list2);
                }
                case COMPLT: 
                case COMPGT: 
                case COMPLEQ: 
                case COMPGEQ: 
                case COMPEQ: 
                case COMPNEQ: 
                case COMPPO: {
                    if (TypeUtils.isNumeric(expression2.getType())) {
                        return this.processNumericRelation(binaryExpression, bl, list2);
                    }
                    if (TypeUtils.isBoolean(expression2.getType())) {
                        return this.processBooleanRelation(binaryExpression, bl, list2);
                    }
                    return list2;
                }
            }
            throw new UnsupportedOperationException("Unknown, unsupported or mistyped expression: " + String.valueOf(expression));
        }
        if (expression instanceof IfThenElseExpression) {
            IfThenElseExpression ifThenElseExpression = (IfThenElseExpression)expression;
            Expression expression4 = ifThenElseExpression.getCondition();
            Expression expression5 = this.mPostOp.getExprTransformer().logicNegCached(expression4);
            Expression expression6 = ifThenElseExpression.getThenPart();
            Expression expression7 = ifThenElseExpression.getElsePart();
            return this.mPostOp.splitF(list2, list -> this.processBooleanOperations(expression6, bl, this.assume(expression4, (List<OctDomainState>)list)), list -> this.processBooleanOperations(expression7, bl, this.assume(expression5, (List<OctDomainState>)list)));
        }
        return list2;
    }

    private List<OctDomainState> assumeAnd(Expression expression, boolean bl, Expression expression2, boolean bl2, List<OctDomainState> list) {
        list = this.processBooleanOperations(expression, bl, list);
        list = this.processBooleanOperations(expression2, bl2, list);
        return list;
    }

    private List<OctDomainState> assumeOr(Expression expression, boolean bl, Expression expression2, boolean bl2, List<OctDomainState> list2) {
        return this.mPostOp.splitF(list2, list -> this.processBooleanOperations(expression, bl, (List<OctDomainState>)list), list -> this.processBooleanOperations(expression2, bl2, (List<OctDomainState>)list));
    }

    private List<OctDomainState> assumeIff(Expression expression, Expression expression2, boolean bl, List<OctDomainState> list2) {
        return this.mPostOp.splitF(list2, list -> this.assumeAnd(expression, bl, expression2, false, (List<OctDomainState>)list), list -> this.assumeAnd(expression, !bl, expression2, true, (List<OctDomainState>)list));
    }

    private List<OctDomainState> processBooleanRelation(BinaryExpression binaryExpression, boolean bl, List<OctDomainState> list) {
        boolean bl2 = false;
        switch (binaryExpression.getOperator()) {
            case COMPNEQ: {
                bl2 = true;
            }
            case COMPEQ: {
                return this.assumeIff(binaryExpression.getLeft(), binaryExpression.getRight(), bl2 ^ bl, list);
            }
            case COMPPO: {
                return list;
            }
        }
        throw new IllegalArgumentException("Not a relation on bools: " + String.valueOf(binaryExpression));
    }

    private List<OctDomainState> processNumericRelation(BinaryExpression binaryExpression, boolean bl, List<OctDomainState> list) {
        ArrayList<OctDomainState> arrayList = new ArrayList<OctDomainState>();
        IfExpressionTree ifExpressionTree = this.mPostOp.getExprTransformer().removeIfExprsCached((Expression)binaryExpression);
        for (Pair<Expression, List<OctDomainState>> pair : ifExpressionTree.assumeLeafs(this.mPostOp, list)) {
            arrayList.addAll(this.processNumericRelationWithoutIfs(this.mLogger, (BinaryExpression)pair.getFirst(), bl, (List)pair.getSecond(), this.mVariableProvider, this.mIntervalPostOperator, this.mCodeBlockFactory));
        }
        return this.mPostOp.joinDownToMax(arrayList);
    }

    private List<OctDomainState> processNumericRelationWithoutIfs(ILogger iLogger, BinaryExpression binaryExpression, boolean bl, List<OctDomainState> list, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider, IAbstractPostOperator<IntervalDomainState, IcfgEdge> iAbstractPostOperator, CodeBlockFactory codeBlockFactory) {
        BinaryExpression.Operator operator = binaryExpression.getOperator();
        if (operator == BinaryExpression.Operator.COMPPO) {
            return list;
        }
        if (bl) {
            operator = AbsIntUtil.negateRelOp(operator);
        }
        Expression expression = binaryExpression.getLeft();
        Expression expression2 = binaryExpression.getRight();
        AffineExpression affineExpression = this.mPostOp.getExprTransformer().affineExprCached(expression);
        AffineExpression affineExpression2 = this.mPostOp.getExprTransformer().affineExprCached(expression2);
        if (affineExpression == null || affineExpression2 == null) {
            BinaryExpression binaryExpression2 = new BinaryExpression(binaryExpression.getLoc(), binaryExpression.getType(), operator, binaryExpression.getLeft(), binaryExpression.getRight());
            if (iLogger.isDebugEnabled()) {
                iLogger.debug((Object)("Unable to handle expression " + BoogiePrettyPrinter.print((Expression)binaryExpression2) + " with Octagons (not affine). Projecting to intervals."));
            }
            Set<IProgramVarOrConst> set = new VariableCollector((Expression)binaryExpression, iBoogieSymbolTableVariableProvider).getVariables();
            return OctAssumeProcessor.projectAssumeOnIntervals(iLogger, list, (Expression)binaryExpression2, iAbstractPostOperator, codeBlockFactory, set);
        }
        assert (expression.getType().equals(expression2.getType()));
        boolean bl2 = TypeUtils.isNumericInt(expression.getType());
        boolean bl3 = false;
        switch (operator) {
            case COMPEQ: {
                return OctAssumeProcessor.processAffineEqZero(this.mLogger, affineExpression.subtract(affineExpression2), bl2, list, (Expression)binaryExpression, this.mIntervalPostOperator, this.mCodeBlockFactory);
            }
            case COMPNEQ: {
                return this.processAffineNeZero(affineExpression.subtract(affineExpression2), bl2, list);
            }
            case COMPLT: {
                bl3 = true;
            }
            case COMPLEQ: {
                return OctAssumeProcessor.processAffineLtZero(affineExpression.subtract(affineExpression2), bl2, bl3, list);
            }
            case COMPGT: {
                bl3 = true;
            }
            case COMPGEQ: {
                return OctAssumeProcessor.processAffineLtZero(affineExpression2.subtract(affineExpression), bl2, bl3, list);
            }
        }
        throw new IllegalArgumentException("Not a relation on numbers: " + String.valueOf(operator));
    }

    private List<OctDomainState> processAffineNeZero(AffineExpression affineExpression, boolean bl, List<OctDomainState> list) {
        AffineExpression.OneVarForm oneVarForm;
        BigDecimal bigDecimal;
        if (affineExpression.isConstant()) {
            if (affineExpression.getConstant().signum() == 0) {
                return new ArrayList<OctDomainState>();
            }
            return list;
        }
        if (affineExpression.getCoefficients().size() > 2 || (affineExpression = affineExpression.unitCoefficientForm()) == null) {
            return list;
        }
        BigDecimal bigDecimal2 = bigDecimal = affineExpression.getConstant().negate();
        if (bl) {
            if (AbsIntUtil.isIntegral(bigDecimal2)) {
                bigDecimal2 = bigDecimal2.subtract(BigDecimal.ONE);
                bigDecimal = bigDecimal.add(BigDecimal.ONE);
            } else {
                return list;
            }
        }
        if ((oneVarForm = (affineExpression = affineExpression.withoutConstant()).getOneVarForm()) != null) {
            OctValue octValue;
            OctValue octValue2;
            if (oneVarForm.negVar) {
                octValue2 = new OctValue(bigDecimal2.negate());
                octValue = new OctValue(bigDecimal.negate());
            } else {
                octValue2 = new OctValue(bigDecimal);
                octValue = new OctValue(bigDecimal2);
            }
            return this.mPostOp.splitC(list, octDomainState -> octDomainState.assumeNumericVarInterval(oneVarForm.var, octValue2, OctValue.INFINITY), octDomainState -> octDomainState.assumeNumericVarInterval(oneVarForm.var, OctValue.INFINITY, octValue));
        }
        AffineExpression.TwoVarForm twoVarForm = affineExpression.getTwoVarForm();
        if (twoVarForm != null) {
            OctValue octValue = new OctValue(bigDecimal2);
            OctValue octValue3 = new OctValue(bigDecimal.negate());
            return this.mPostOp.splitC(list, octDomainState -> octDomainState.assumeNumericVarRelationLeConstant(twoVarForm.var1, twoVarForm.negVar1, twoVarForm.var2, twoVarForm.negVar2, octValue), octDomainState -> octDomainState.assumeNumericVarRelationLeConstant(twoVarForm.var1, !twoVarForm.negVar1, twoVarForm.var2, !twoVarForm.negVar2, octValue3));
        }
        return list;
    }

    private static List<OctDomainState> processAffineEqZero(ILogger iLogger, AffineExpression affineExpression, boolean bl, List<OctDomainState> list, Expression expression, IAbstractPostOperator<IntervalDomainState, IcfgEdge> iAbstractPostOperator, CodeBlockFactory codeBlockFactory) {
        if (affineExpression.isConstant()) {
            if (affineExpression.getConstant().signum() != 0) {
                return new ArrayList<OctDomainState>();
            }
            return list;
        }
        List<OctDomainState> list2 = list.stream().filter(octDomainState -> !octDomainState.isBottom()).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return new ArrayList<OctDomainState>();
        }
        AffineExpression affineExpression2 = affineExpression;
        if (affineExpression.getCoefficients().size() > 2 || (affineExpression = affineExpression.unitCoefficientForm()) == null) {
            iLogger.debug((Object)("Unable to handle affine expression " + String.valueOf(affineExpression2) + " == 0 with Octagons. Projecting to intervals."));
            return OctAssumeProcessor.projectAssumeOnIntervals(iLogger, list2, expression, iAbstractPostOperator, codeBlockFactory, affineExpression2.getCoefficients().keySet());
        }
        BigDecimal bigDecimal = affineExpression.getConstant().negate();
        if (bl && !AbsIntUtil.isIntegral(bigDecimal)) {
            return new ArrayList<OctDomainState>();
        }
        AffineExpression.OneVarForm oneVarForm = (affineExpression = affineExpression.withoutConstant()).getOneVarForm();
        if (oneVarForm != null) {
            OctValue octValue = new OctValue(oneVarForm.negVar ? bigDecimal.negate() : bigDecimal);
            list2.forEach(octDomainState -> octDomainState.assumeNumericVarInterval(oneVarForm.var, octValue, octValue));
            return list2;
        }
        AffineExpression.TwoVarForm twoVarForm = affineExpression.getTwoVarForm();
        if (twoVarForm != null) {
            OctValue octValue = new OctValue(bigDecimal);
            OctValue octValue2 = new OctValue(bigDecimal.negate());
            list2.forEach(octDomainState -> octDomainState.assumeNumericVarRelationLeConstant(twoVarForm.var1, twoVarForm.negVar1, twoVarForm.var2, twoVarForm.negVar2, octValue));
            list2.forEach(octDomainState -> octDomainState.assumeNumericVarRelationLeConstant(twoVarForm.var1, !twoVarForm.negVar1, twoVarForm.var2, !twoVarForm.negVar2, octValue2));
            return list2;
        }
        return list;
    }

    private static List<OctDomainState> projectAssumeOnIntervals(ILogger iLogger, List<OctDomainState> list, Expression expression, IAbstractPostOperator<IntervalDomainState, IcfgEdge> iAbstractPostOperator, CodeBlockFactory codeBlockFactory, Set<IProgramVarOrConst> set) {
        Object object2;
        List list2 = list.stream().filter(octDomainState -> !octDomainState.isBottom()).map(octDomainState -> IntervalProjection.projectOctagonStateToIntervalDomainState(iLogger, octDomainState)).collect(Collectors.toList());
        assert (list2.stream().noneMatch(intervalDomainState -> intervalDomainState.isBottom())) : "At least one interval state became bottom during conversion. This should not happen";
        if (list2.isEmpty()) {
            return list;
        }
        AssumeStatement assumeStatement = new AssumeStatement(expression.getLoc(), expression);
        StatementSequence statementSequence = codeBlockFactory.constructStatementSequence(null, null, Collections.singletonList(assumeStatement));
        if (iLogger.isDebugEnabled()) {
            iLogger.debug((Object)("Projection of current OctDomainState to Intervals: " + String.valueOf(list2)));
            iLogger.debug((Object)("Applying the following statement to each state: " + BoogiePrettyPrinter.print((Statement)assumeStatement)));
        }
        ArrayList arrayList = new ArrayList();
        for (Object object2 : list2) {
            arrayList.addAll(iAbstractPostOperator.apply((IAbstractState)object2, (Object)statementSequence));
        }
        if (iLogger.isDebugEnabled()) {
            iLogger.debug((Object)("Resulting interval states: " + String.valueOf(arrayList)));
            iLogger.debug((Object)"Projecting back to octagons.");
        }
        object2 = new ArrayList();
        for (OctDomainState octDomainState2 : list) {
            for (IntervalDomainState intervalDomainState2 : arrayList) {
                OctDomainState octDomainState3 = IntervalProjection.projectIntervalStateToOctagon(iLogger, intervalDomainState2, octDomainState2, set);
                if (octDomainState3.isBottom()) {
                    object2.add(octDomainState3);
                    continue;
                }
                object2.add(octDomainState2.intersect(octDomainState3));
            }
        }
        iLogger.debug((Object)("Resulting octagon states: " + String.valueOf(object2)));
        return object2;
    }

    private static List<OctDomainState> processAffineLtZero(AffineExpression affineExpression, boolean bl, boolean bl2, List<OctDomainState> list) {
        if (affineExpression.getCoefficients().size() > 2 || (affineExpression = affineExpression.unitCoefficientForm()) == null) {
            return list;
        }
        BigDecimal bigDecimal = affineExpression.getConstant().negate();
        if (bl) {
            if (!AbsIntUtil.isIntegral(bigDecimal)) {
                bigDecimal = bigDecimal.setScale(0, RoundingMode.FLOOR);
            } else if (bl2) {
                bigDecimal = bigDecimal.subtract(BigDecimal.ONE);
            }
        }
        if ((affineExpression = affineExpression.withoutConstant()).isConstant()) {
            if (bigDecimal.signum() < 0) {
                return new ArrayList<OctDomainState>();
            }
            return list;
        }
        AffineExpression.OneVarForm oneVarForm = affineExpression.getOneVarForm();
        if (oneVarForm != null) {
            OctValue octValue;
            OctValue octValue2;
            if (oneVarForm.negVar) {
                octValue2 = new OctValue(bigDecimal.negate());
                octValue = OctValue.INFINITY;
            } else {
                octValue2 = OctValue.INFINITY;
                octValue = new OctValue(bigDecimal);
            }
            list.forEach(octDomainState -> octDomainState.assumeNumericVarInterval(oneVarForm.var, octValue2, octValue));
            return list;
        }
        AffineExpression.TwoVarForm twoVarForm = affineExpression.getTwoVarForm();
        if (twoVarForm != null) {
            OctValue octValue = new OctValue(bigDecimal);
            list.forEach(octDomainState -> octDomainState.assumeNumericVarRelationLeConstant(twoVarForm.var1, twoVarForm.negVar1, twoVarForm.var2, twoVarForm.negVar2, octValue));
            return list;
        }
        return list;
    }

    private static class VariableCollector
    extends BoogieVisitor {
        private final Set<IProgramVarOrConst> mVariables = new HashSet<IProgramVarOrConst>();
        private final IBoogieSymbolTableVariableProvider mVariableProvider;

        private VariableCollector(Expression expression, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider) {
            this.mVariableProvider = iBoogieSymbolTableVariableProvider;
            this.processExpression(expression);
        }

        private Set<IProgramVarOrConst> getVariables() {
            return this.mVariables;
        }

        protected void visit(VariableLHS variableLHS) {
            this.mVariables.add((IProgramVarOrConst)this.mVariableProvider.getBoogieVar(variableLHS.getIdentifier(), variableLHS.getDeclarationInformation(), false));
        }

        protected void visit(IdentifierExpression identifierExpression) {
            this.mVariables.add((IProgramVarOrConst)this.mVariableProvider.getBoogieVar(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation(), false));
        }
    }
}

