/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.Evaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorLogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;

public class SingletonVariableExpressionEvaluator<VALUE extends INonrelationalValue<VALUE>, STATE extends NonrelationalState<STATE, VALUE>>
extends Evaluator<VALUE, STATE> {
    private final IProgramVarOrConst mVar;
    private final INonrelationalValueFactory<VALUE> mNonrelationalValueFactory;
    private boolean mContainsBoolean = false;
    private final EvaluatorUtils.EvaluatorType mType;

    public SingletonVariableExpressionEvaluator(IProgramVarOrConst iProgramVarOrConst, int n, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory, EvaluatorLogger evaluatorLogger) {
        super(n, iNonrelationalValueFactory, evaluatorLogger);
        this.mVar = iProgramVarOrConst;
        this.mNonrelationalValueFactory = iNonrelationalValueFactory;
        this.mType = EvaluatorUtils.getEvaluatorType(this.mVar);
    }

    @Override
    public Collection<IEvaluationResult<VALUE>> evaluate(STATE STATE) {
        assert (STATE != null);
        ArrayList<IEvaluationResult<VALUE>> arrayList = new ArrayList<IEvaluationResult<VALUE>>();
        BooleanValue booleanValue = BooleanValue.TOP;
        Function<IProgramVarOrConst, Triple> function = iProgramVarOrConst -> new Triple(STATE.getValue((IProgramVarOrConst)iProgramVarOrConst), (Object)BooleanValue.TOP, (Object)false);
        Function<IProgramVarOrConst, Triple> function2 = iProgramVarOrConst -> new Triple(this.mNonrelationalValueFactory.createTopValue(), (Object)STATE.getBooleanValue((IProgramVarOrConst)iProgramVarOrConst), (Object)true);
        Triple triple = TypeUtils.applyVariableFunction(function, function2, null, this.mVar);
        INonrelationalValue iNonrelationalValue = (INonrelationalValue)triple.getFirst();
        if (((Boolean)triple.getThird()).booleanValue()) {
            booleanValue = (BooleanValue)triple.getSecond();
            this.mContainsBoolean = true;
        }
        if (iNonrelationalValue.isBottom() || booleanValue.isBottom()) {
            arrayList.add(new NonrelationalEvaluationResult<VALUE>(this.mNonrelationalValueFactory.createBottomValue(), BooleanValue.BOTTOM));
        } else {
            arrayList.add(new NonrelationalEvaluationResult<INonrelationalValue>(iNonrelationalValue, booleanValue));
        }
        return arrayList;
    }

    @Override
    public Collection<STATE> inverseEvaluate(IEvaluationResult<VALUE> iEvaluationResult, STATE STATE) {
        assert (iEvaluationResult != null);
        assert (STATE != null);
        ArrayList arrayList = new ArrayList();
        if (this.mContainsBoolean) {
            arrayList.add(((NonrelationalState)STATE).setBooleanValue(this.mVar, iEvaluationResult.getBooleanValue()));
        } else {
            arrayList.add(((NonrelationalState)STATE).setValue(this.mVar, (INonrelationalValue)((INonrelationalValue)iEvaluationResult.getValue())));
        }
        return arrayList;
    }

    @Override
    public boolean hasFreeOperands() {
        return false;
    }

    @Override
    public boolean containsBool() {
        return this.mContainsBoolean;
    }

    public String toString() {
        return this.mVar.getGloballyUniqueId();
    }

    @Override
    public EvaluatorUtils.EvaluatorType getType() {
        return this.mType;
    }
}

