/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ConcurrencyInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ProcedureMultiplier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstanceAdder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IcfgDuplicator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class IcfgPetrifier {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final BasicIcfg<IcfgLocation> mPetrifiedIcfg;
    private final BlockEncodingBacktranslator mBacktranslator;

    public IcfgPetrifier(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<?> iIcfg, int n, boolean bl) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mBacktranslator = new BlockEncodingBacktranslator(IcfgEdge.class, Term.class, this.mLogger);
        IcfgDuplicator icfgDuplicator = new IcfgDuplicator(this.mLogger, this.mServices, iIcfg.getCfgSmtToolkit().getManagedScript(), this.mBacktranslator);
        this.mPetrifiedIcfg = icfgDuplicator.copy(iIcfg, "_petrified" + n, true);
        Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> map = icfgDuplicator.getOld2NewEdgeMapping();
        ConcurrencyInformation concurrencyInformation = iIcfg.getCfgSmtToolkit().getConcurrencyInformation();
        List<IIcfgForkTransitionThreadCurrent<IcfgLocation>> list = concurrencyInformation.getThreadInstanceMap().keySet().stream().map(iIcfgForkTransitionThreadCurrent -> (IIcfgForkTransitionThreadCurrent)map.get(iIcfgForkTransitionThreadCurrent)).collect(Collectors.toList());
        List<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> list2 = concurrencyInformation.getJoinTransitions().stream().map(iIcfgJoinTransitionThreadCurrent -> (IIcfgJoinTransitionThreadCurrent)map.get(iIcfgJoinTransitionThreadCurrent)).collect(Collectors.toList());
        ThreadInstanceAdder threadInstanceAdder = new ThreadInstanceAdder(this.mServices, bl);
        Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> map2 = ThreadInstanceAdder.constructThreadInstances(this.mPetrifiedIcfg, list, n);
        HashMap<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation> hashMap = new HashMap<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation>();
        CfgSmtToolkit cfgSmtToolkit = threadInstanceAdder.constructNewToolkit(this.mPetrifiedIcfg.getCfgSmtToolkit(), map2, hashMap, list2);
        this.mPetrifiedIcfg.setCfgSmtToolkit(cfgSmtToolkit);
        List<ThreadInstance> list3 = IcfgPetrifier.getAllInstances(map2);
        ProcedureMultiplier.duplicateProcedures(this.mServices, this.mPetrifiedIcfg, list3, this.mBacktranslator, map2, list, list2);
        IcfgPetrifier.fillErrorNodeMap(map2.keySet(), hashMap);
        hashMap.values().forEach(icfgLocation -> this.mPetrifiedIcfg.addLocation((IcfgLocation)icfgLocation, false, true, false, false, false, false));
        threadInstanceAdder.connectThreadInstances(this.mPetrifiedIcfg, list, list2, map2, hashMap, this.mBacktranslator);
        Set<Term> set = list3.stream().flatMap(threadInstance -> Arrays.stream(threadInstance.getIdVars())).map(IProgramVarOrConst::getTerm).collect(Collectors.toSet());
        this.mBacktranslator.setVariableBlacklist(set);
    }

    private static void fillErrorNodeMap(Set<IIcfgForkTransitionThreadCurrent<IcfgLocation>> set, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation> map) {
        int n = 0;
        for (IIcfgForkTransitionThreadCurrent<IcfgLocation> iIcfgForkTransitionThreadCurrent : set) {
            IcfgLocation icfgLocation = ThreadInstanceAdder.constructErrorLocation(n, iIcfgForkTransitionThreadCurrent);
            map.put(iIcfgForkTransitionThreadCurrent, icfgLocation);
            ++n;
        }
    }

    public IIcfg<IcfgLocation> getPetrifiedIcfg() {
        return this.mPetrifiedIcfg;
    }

    public ITranslator<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>, Term, Term, IcfgLocation, IcfgLocation, ILocation> getBacktranslator() {
        return this.mBacktranslator;
    }

    public static List<ThreadInstance> getAllInstances(Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> map) {
        return map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

