/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Intersect<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final ITreeAutomatonBU<LETTER, STATE> mTreeA;
    private final ITreeAutomatonBU<LETTER, STATE> mTreeB;
    protected final ITreeAutomatonBU<LETTER, STATE> mResult;
    private final IIntersectionStateFactory<STATE> mStateFactory;
    private final Map<STATE, Map<STATE, Pair<STATE, STATE>>> mPairsMap;
    private final Map<Pair<STATE, STATE>, STATE> mReducedStates = new HashMap<Pair<STATE, STATE>, STATE>();

    public Intersect(AutomataLibraryServices automataLibraryServices, IIntersectionStateFactory<STATE> iIntersectionStateFactory, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU2) {
        super(automataLibraryServices);
        this.mPairsMap = new HashMap<STATE, Map<STATE, Pair<STATE, STATE>>>();
        this.mStateFactory = iIntersectionStateFactory;
        this.mTreeA = iTreeAutomatonBU;
        this.mTreeB = iTreeAutomatonBU2;
        this.mResult = this.computeResult();
    }

    private STATE reduceState(Pair<STATE, STATE> pair) {
        if (!this.mReducedStates.containsKey(pair)) {
            this.mReducedStates.put(pair, this.mStateFactory.intersection(pair.getFirst(), pair.getSecond()));
        }
        return this.mReducedStates.get(pair);
    }

    private Pair<STATE, STATE> getPair(STATE STATE, STATE STATE2) {
        if (!this.mPairsMap.containsKey(STATE)) {
            this.mPairsMap.put(STATE, new HashMap());
        }
        if (!this.mPairsMap.get(STATE).containsKey(STATE2)) {
            this.mPairsMap.get(STATE).put(STATE2, new Pair(STATE, STATE2));
        }
        return this.mPairsMap.get(STATE).get(STATE2);
    }

    @Override
    public String startMessage() {
        return "Start intersection tree automatons";
    }

    @Override
    public String exitMessage() {
        return "Exit intersection tree automatons";
    }

    private TreeAutomatonBU<LETTER, STATE> computeResult() {
        Object object2;
        HashSet hashSet = new HashSet();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet hashSet3 = new HashSet();
        hashSet.addAll(this.mTreeA.getAlphabet());
        hashSet.addAll(this.mTreeB.getAlphabet());
        HashMap<List<STATE>, Collection<Object>> hashMap = new HashMap<List<STATE>, Collection<Object>>();
        HashMap<List<Object>, Collection<Object>> hashMap2 = new HashMap<List<Object>, Collection<Object>>();
        for (List<STATE> list : this.mTreeA.getSourceCombinations()) {
            for (TreeAutomatonRule<List<STATE>, STATE> treeAutomatonRule : this.mTreeA.getSuccessors(list)) {
                if (hashMap.containsKey(treeAutomatonRule.getLetter())) {
                    object2 = (Collection)hashMap.get(treeAutomatonRule.getLetter());
                } else {
                    object2 = new LinkedList();
                    hashMap.put(treeAutomatonRule.getLetter(), (Collection<Object>)object2);
                }
                object2.add(treeAutomatonRule);
            }
        }
        for (List<STATE> list : this.mTreeB.getSourceCombinations()) {
            for (TreeAutomatonRule<List<STATE>, STATE> treeAutomatonRule : this.mTreeB.getSuccessors(list)) {
                if (hashMap2.containsKey(treeAutomatonRule.getLetter())) {
                    object2 = (Collection)hashMap2.get(treeAutomatonRule.getLetter());
                } else {
                    object2 = new LinkedList();
                    hashMap2.put(treeAutomatonRule.getLetter(), (Collection<Object>)object2);
                }
                object2.add(treeAutomatonRule);
            }
        }
        for (IRankedLetter iRankedLetter : hashMap.keySet()) {
            if (!hashMap2.containsKey(iRankedLetter)) continue;
            for (TreeAutomatonRule<List<STATE>, STATE> treeAutomatonRule : (Collection)hashMap.get(iRankedLetter)) {
                for (Object object2 : (Collection)hashMap2.get(iRankedLetter)) {
                    if (treeAutomatonRule.getArity() != ((TreeAutomatonRule)object2).getArity()) continue;
                    ArrayList arrayList = new ArrayList();
                    int n = treeAutomatonRule.getArity();
                    int n2 = 0;
                    while (n2 < n) {
                        arrayList.add(this.getPair(treeAutomatonRule.getSource().get(n2), ((TreeAutomatonRule)object2).getSource().get(n2)));
                        ++n2;
                    }
                    Pair pair = this.getPair(treeAutomatonRule.getDest(), ((TreeAutomatonRule)object2).getDest());
                    hashSet3.add(new TreeAutomatonRule(iRankedLetter, arrayList, pair));
                }
            }
        }
        for (STATE STATE : this.mPairsMap.keySet()) {
            for (TreeAutomatonRule<List<STATE>, STATE> treeAutomatonRule : this.mPairsMap.get(STATE).keySet()) {
                object2 = this.getPair(STATE, treeAutomatonRule);
                if (!this.mTreeA.isFinalState(STATE) || !this.mTreeB.isFinalState(treeAutomatonRule)) continue;
                hashSet2.add(object2);
            }
        }
        TreeAutomatonBU treeAutomatonBU = new TreeAutomatonBU();
        for (TreeAutomatonRule treeAutomatonRule : hashSet3) {
            ArrayList arrayList = new ArrayList();
            for (Object object2 : treeAutomatonRule.getSource()) {
                arrayList.add(this.reduceState((Pair<STATE, STATE>)object2));
            }
            treeAutomatonBU.addRule(new TreeAutomatonRule(treeAutomatonRule.getLetter(), arrayList, this.reduceState((Pair)treeAutomatonRule.getDest())));
        }
        for (Pair pair : hashSet2) {
            treeAutomatonBU.addFinalState(this.reduceState(pair));
        }
        return treeAutomatonBU;
    }

    @Override
    public ITreeAutomatonBU<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

