/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DatatypeCycleInterpolator {
    private final Interpolator mInterpolator;
    private final Theory mTheory;
    private final int mNumInterpolants;
    private final Set<Term>[] mInterpolants;
    private final HashMap<SymmetricPair<Term>, Interpolator.LitInfo> mEqualityInfos;
    private final HashMap<Term, Interpolator.LitInfo> mTestersOccurrence;
    private final HashMap<Term, FunctionSymbol> mTestersFunctions;
    private Term[] mPath;
    BitSet mAllInA;
    private int mLastColor;
    private final Term[] mStart;
    private final Term[] mHead;
    private final int[] mStartIndices;
    private final int[] mHeadIndices;
    private FunctionSymbol[] mSelectorOnPath;
    private FunctionSymbol[] mTesterOnPath;

    public DatatypeCycleInterpolator(Interpolator interpolator, HashMap<SymmetricPair<Term>, Interpolator.LitInfo> hashMap) {
        this.mInterpolator = interpolator;
        this.mTheory = interpolator.mTheory;
        this.mNumInterpolants = interpolator.mNumInterpolants;
        this.mInterpolants = new Set[this.mNumInterpolants];
        int n = 0;
        while (n < this.mNumInterpolants) {
            this.mInterpolants[n] = new HashSet<Term>();
            ++n;
        }
        this.mStart = new Term[this.mNumInterpolants];
        this.mHead = new Term[this.mNumInterpolants];
        this.mStartIndices = new int[this.mNumInterpolants];
        this.mHeadIndices = new int[this.mNumInterpolants];
        this.mAllInA = new BitSet(this.mNumInterpolants);
        this.mEqualityInfos = hashMap;
        this.mTestersOccurrence = new HashMap();
        this.mTestersFunctions = new HashMap();
        this.collectTesterInfo(hashMap);
    }

    private void collectTesterInfo(Map<SymmetricPair<Term>, Interpolator.LitInfo> map) {
        for (Map.Entry<SymmetricPair<Term>, Interpolator.LitInfo> entry : map.entrySet()) {
            SymmetricPair<Term> symmetricPair = entry.getKey();
            Interpolator.LitInfo litInfo = entry.getValue();
            Term term = symmetricPair.getFirst();
            Term term2 = symmetricPair.getSecond();
            this.collectSingleTesterInfo(term, litInfo);
            this.collectSingleTesterInfo(term2, litInfo);
        }
    }

    private void collectSingleTesterInfo(Term term, Interpolator.LitInfo litInfo) {
        ApplicationTerm applicationTerm;
        if (term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getFunction().getName().equals("is")) {
            Term term2 = applicationTerm.getParameters()[0];
            this.mTestersFunctions.put(term2, applicationTerm.getFunction());
            this.mTestersOccurrence.put(term2, litInfo);
        }
    }

    public Term[] interpolateCycle(Term[] termArray) {
        this.mPath = termArray;
        this.mLastColor = this.mNumInterpolants;
        this.mAllInA.set(0, this.mNumInterpolants);
        this.mSelectorOnPath = new FunctionSymbol[this.mPath.length];
        this.mTesterOnPath = new FunctionSymbol[this.mPath.length];
        this.traverseCycleLemma();
        this.collectCycleInterpolants();
        Term[] termArray2 = new Term[this.mNumInterpolants];
        int n = 0;
        while (n < this.mNumInterpolants) {
            termArray2[n] = this.mTheory.and(this.mInterpolants[n].toArray(new Term[this.mInterpolants[n].size()]));
            ++n;
        }
        return termArray2;
    }

    private void traverseCycleLemma() {
        Interpolator.Occurrence occurrence = this.mInterpolator.getOccurrence(this.mPath[0]);
        this.closeAPaths(occurrence, this.mPath[0], 0);
        this.openAPaths(occurrence, this.mPath[0], 0);
        int n = 0;
        while (n < this.mPath.length - 2) {
            Interpolator.Occurrence occurrence2;
            Object object;
            Term term = this.mPath[n];
            Term term2 = this.mPath[n + 1];
            if (!term.equals(term2)) {
                object = this.mEqualityInfos.get(new SymmetricPair<Term>(term, term2));
                this.closeAPaths((Interpolator.Occurrence)object, this.mPath[n], n);
                this.openAPaths((Interpolator.Occurrence)object, this.mPath[n], n);
                if (((Interpolator.LitInfo)object).getMixedVar() != null) {
                    occurrence2 = this.mInterpolator.getOccurrence(term2);
                    this.closeAPaths(occurrence2, (Term)((Interpolator.LitInfo)object).getMixedVar(), n);
                    this.openAPaths(occurrence2, (Term)((Interpolator.LitInfo)object).getMixedVar(), n);
                }
            }
            if (this.isConsParentOf(term2, (Term)(object = this.mPath[n + 2]))) {
                this.addConsToAPath((ApplicationTerm)term2, (Term)object, n + 1);
            } else {
                assert (this.isSelParentOf(term2, (Term)object));
                occurrence2 = this.mTestersOccurrence.get(term2);
                this.closeAPaths(occurrence2, term2, n + 1);
                this.openAPaths(occurrence2, term2, n + 1);
                this.addSelToAPath(term2, (ApplicationTerm)object, n + 1);
            }
            n += 2;
        }
    }

    private void collectCycleInterpolants() {
        int n = 0;
        while (n < this.mNumInterpolants) {
            if (this.mAllInA.get(n)) {
                assert (this.mInterpolants[n].isEmpty());
                this.mInterpolants[n].add((Term)this.mTheory.mFalse);
            } else if (this.mHead[n] != null) {
                if (this.mStart[n] == null) {
                    this.mStart[n] = this.mPath[0];
                    this.mStartIndices[n] = 0;
                }
                this.addCompletedAPath(n, this.mHead[n], this.mHeadIndices[n]);
            } else if (this.mStart[n] != null) {
                this.addCompletedAPath(n, this.mPath[0], 0);
            }
            ++n;
        }
    }

    private void addConsToAPath(ApplicationTerm applicationTerm, Term term, int n) {
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        assert (functionSymbol.isConstructor());
        String string = this.getSelector(applicationTerm, term);
        this.mSelectorOnPath[n] = this.mTheory.getFunction(string, new Sort[]{applicationTerm.getSort()});
        this.mTesterOnPath[n] = this.mTheory.getFunctionWithResult("is", new String[]{functionSymbol.getName()}, null, new Sort[]{applicationTerm.getSort()});
    }

    private void addSelToAPath(Term term, ApplicationTerm applicationTerm, int n) {
        FunctionSymbol functionSymbol;
        FunctionSymbol functionSymbol2 = applicationTerm.getFunction();
        assert (functionSymbol2.isSelector());
        this.mSelectorOnPath[n] = functionSymbol2;
        this.mTesterOnPath[n] = functionSymbol = this.mTestersFunctions.get(term);
    }

    private void closeAPaths(Interpolator.Occurrence occurrence, Term term, int n) {
        this.mAllInA.and(occurrence.mInA);
        int n2 = this.mLastColor;
        int n3 = this.mNumInterpolants;
        while (n2 < n3 && occurrence.isBLocal(n2)) {
            if (this.mStart[n2] != null) {
                this.addCompletedAPath(n2, term, n);
            } else {
                this.mHead[n2] = term;
                this.mHeadIndices[n2] = n;
            }
            this.mLastColor = n2 = this.getParent(n2);
        }
    }

    private void openAPaths(Interpolator.Occurrence occurrence, Term term, int n) {
        int n2 = this.mLastColor;
        n2 = this.getALocalChild(n2, occurrence);
        while (n2 >= 0) {
            assert (occurrence.isALocal(n2));
            if (!this.mAllInA.get(n2)) {
                this.mStart[n2] = term;
                this.mStartIndices[n2] = n;
            }
            this.mLastColor = n2;
            n2 = this.getALocalChild(n2, occurrence);
        }
    }

    private void addCompletedAPath(int n, Term term, int n2) {
        Term term2 = this.mStart[n];
        int n3 = this.mStartIndices[n];
        while (n3 != n2) {
            if (this.mTesterOnPath[n3] != null) {
                this.mInterpolants[n].add(this.mTheory.term(this.mTesterOnPath[n3], new Term[]{term2}));
            }
            if (this.mSelectorOnPath[n3] != null) {
                term2 = this.mTheory.term(this.mSelectorOnPath[n3], new Term[]{term2});
            }
            n3 = (n3 + 1) % this.mTesterOnPath.length;
        }
        if (term2 != term) {
            this.mInterpolants[n].add(this.mTheory.term("=", new Term[]{term2, term}));
        }
        this.mStartIndices[n] = -1;
        this.mStart[n] = null;
    }

    private boolean isSelParentOf(Term term, Term term2) {
        if (!(term2 instanceof ApplicationTerm)) {
            return false;
        }
        return ((ApplicationTerm)term2).getFunction().isSelector() && ((ApplicationTerm)term2).getParameters()[0] == term;
    }

    private boolean isConsParentOf(Term term, Term term2) {
        if (!(term instanceof ApplicationTerm)) {
            return false;
        }
        if (((ApplicationTerm)term).getFunction().isConstructor()) {
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term3 = termArray[n2];
                if (term2 == term3) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private String getSelector(ApplicationTerm applicationTerm, Term term) {
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        assert (functionSymbol.getReturnSort().getSortSymbol().isDatatype());
        DataType dataType = (DataType)applicationTerm.getSort().getSortSymbol();
        DataType.Constructor constructor = dataType.findConstructor(functionSymbol.getName());
        String[] stringArray = constructor.getSelectors();
        Term[] termArray = applicationTerm.getParameters();
        int n = 0;
        while (n < termArray.length) {
            if (term.equals(termArray[n])) {
                return stringArray[n];
            }
            ++n;
        }
        throw new AssertionError((Object)"child term not found in constructors");
    }

    private int getParent(int n) {
        int n2 = n + 1;
        while (this.mInterpolator.mStartOfSubtrees[n2] > n) {
            ++n2;
        }
        return n2;
    }

    private int getALocalChild(int n, Interpolator.Occurrence occurrence) {
        int n2 = n - 1;
        while (n2 >= this.mInterpolator.mStartOfSubtrees[n]) {
            if (occurrence.isALocal(n2)) {
                return n2;
            }
            n2 = this.mInterpolator.mStartOfSubtrees[n2] - 1;
        }
        return -1;
    }
}

