/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.mso;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.mso.MSODSolver;
import java.util.HashMap;
import java.util.Map;

public class MSODScript
extends NoopScript {
    private final AutomataLibraryServices mAutomataLibrarayServices;
    private final MSODSolver mMSODSolver;
    private final ILogger mLogger;
    private Term mAssertionTerm;
    private Map<Term, Term> mModel;

    public MSODScript(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, MSODSolver.MSODLogic mSODLogic) {
        this.mAutomataLibrarayServices = new AutomataLibraryServices(iUltimateServiceProvider);
        this.mLogger = iLogger;
        this.mMSODSolver = new MSODSolver(iUltimateServiceProvider, (Script)this, iLogger, mSODLogic);
    }

    public void setLogic(String string) throws UnsupportedOperationException, SMTLIBException {
        super.setLogic(string);
    }

    public void setLogic(Logics logics) throws UnsupportedOperationException, SMTLIBException {
        super.setLogic(logics);
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mAssertionTerm = this.mAssertionTerm == null ? term : this.term("and", new Term[]{this.mAssertionTerm, term});
        return null;
    }

    public Script.LBool checkSat() throws SMTLIBException {
        this.mLogger.info((Object)("Input term: " + String.valueOf(this.mAssertionTerm)));
        try {
            this.mModel = this.mMSODSolver.getResult((Script)this, this.mLogger, this.mAutomataLibrarayServices, this.mAssertionTerm);
            if (this.mModel != null) {
                this.mLogger.info((Object)"SAT");
                this.mModel.entrySet().forEach(entry -> this.mLogger.info((Object)(String.valueOf(entry.getKey()) + ": " + String.valueOf(entry.getValue()))));
                return Script.LBool.SAT;
            }
        }
        catch (Exception exception) {
            this.mLogger.error((Object)exception);
            return Script.LBool.UNKNOWN;
        }
        this.mLogger.info((Object)"UNSAT");
        return Script.LBool.UNSAT;
    }

    public Map<Term, Term> getValue(Term[] termArray) throws SMTLIBException {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        if (this.mModel == null) {
            return hashMap;
        }
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            Term term2 = this.mModel.get(term);
            if (term2 != null) {
                hashMap.put(term, term2);
            }
            ++n2;
        }
        return hashMap;
    }

    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

