/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.sifa.CallGraph;
import de.uni_freiburg.informatik.ultimate.lib.sifa.DagInterpreter;
import de.uni_freiburg.informatik.ultimate.lib.sifa.IEnterCallRegistrar;
import de.uni_freiburg.informatik.ultimate.lib.sifa.IWorklistWithInputs;
import de.uni_freiburg.informatik.ultimate.lib.sifa.MapBasedStorage;
import de.uni_freiburg.informatik.ultimate.lib.sifa.PriorityWorklist;
import de.uni_freiburg.informatik.ultimate.lib.sifa.ProcedureResourceCache;
import de.uni_freiburg.informatik.ultimate.lib.sifa.ProcedureResources;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.IFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ICallSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ILoopSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class IcfgInterpreter
implements IEnterCallRegistrar {
    private final SifaStats mStats;
    private final ILogger mLogger;
    private final CallGraph mCallGraph;
    private final IWorklistWithInputs<String, IPredicate> mEnterCallWorklist;
    private final Collection<IcfgLocation> mLocsOfInterest;
    private final MapBasedStorage mLoiPredStorage;
    private final SymbolicTools mTools;
    private final ProcedureResourceCache mProcResCache;
    private final DagInterpreter mDagInterpreter;

    public IcfgInterpreter(ILogger iLogger, IProgressAwareTimer iProgressAwareTimer, SifaStats sifaStats, SymbolicTools symbolicTools, IIcfg<IcfgLocation> iIcfg, Collection<IcfgLocation> collection, IDomain iDomain, IFluid iFluid, Function<IcfgInterpreter, Function<DagInterpreter, ILoopSummarizer>> function, Function<IcfgInterpreter, Function<DagInterpreter, ICallSummarizer>> function2) {
        this.mStats = sifaStats;
        this.mStats.start(SifaStats.Key.OVERALL_TIME);
        this.mLogger = iLogger;
        this.mTools = symbolicTools;
        this.mLocsOfInterest = collection;
        this.logStartingSifa(collection);
        this.logBuildingCallGraph();
        this.mCallGraph = new CallGraph(iIcfg, collection);
        this.logCallGraphComputed();
        this.mLoiPredStorage = new MapBasedStorage(iLogger);
        this.mEnterCallWorklist = new PriorityWorklist<String, IPredicate>(this.mCallGraph.relevantProceduresTopsorted(), iDomain::join);
        this.mProcResCache = new ProcedureResourceCache(sifaStats, this.mCallGraph, iIcfg);
        this.enqueInitial();
        this.mDagInterpreter = new DagInterpreter(iLogger, sifaStats, iProgressAwareTimer, symbolicTools, iDomain, iFluid, function.apply(this), function2.apply(this));
        this.mStats.stop(SifaStats.Key.OVERALL_TIME);
    }

    public static Collection<IcfgLocation> allErrorLocations(IIcfg<IcfgLocation> iIcfg) {
        return iIcfg.getProcedureErrorNodes().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void enqueInitial() {
        IPredicate iPredicate = this.mTools.top();
        this.mCallGraph.initialProceduresOfInterest().stream().forEach(string -> this.mEnterCallWorklist.add((String)string, iPredicate));
    }

    public Map<IcfgLocation, IPredicate> interpret() {
        this.mStats.start(SifaStats.Key.OVERALL_TIME);
        this.logStartingInterpretation();
        while (this.mEnterCallWorklist.advance()) {
            String string = this.mEnterCallWorklist.getWork();
            IPredicate iPredicate = this.mEnterCallWorklist.getInput();
            this.logEnterProcedure(string, iPredicate);
            this.mStats.increment(SifaStats.Key.ICFG_INTERPRETER_ENTERED_PROCEDURES);
            this.interpretLoisInProcedure(string, iPredicate);
        }
        this.logFinalResults();
        this.mStats.stop(SifaStats.Key.OVERALL_TIME);
        return this.mLoiPredStorage.addDefaultsAndGetMap(this.mLocsOfInterest, this.mTools.bottom());
    }

    private void interpretLoisInProcedure(String string, IPredicate iPredicate) {
        ProcedureResources procedureResources = this.mProcResCache.resourcesOf(string);
        this.mDagInterpreter.interpret(procedureResources.getRegexDag(), procedureResources.getDagOverlayPathToLoisAndEnterCalls(), iPredicate, this.mLoiPredStorage, this);
    }

    @Override
    public void registerEnterCall(String string, IPredicate iPredicate) {
        this.logRegisterEnterCall(string, iPredicate);
        this.mEnterCallWorklist.add(string, iPredicate);
    }

    public CallGraph callGraph() {
        return this.mCallGraph;
    }

    public ProcedureResourceCache procedureResourceCache() {
        return this.mProcResCache;
    }

    private void logStartingSifa(Collection<IcfgLocation> collection) {
        this.mLogger.info("Started Sifa with %d locations of interest", new Object[]{collection.size()});
        if (collection.isEmpty()) {
            this.mLogger.warn((Object)"No location of interest given. Interpreter runs nevertheless. You may want to cancel.");
        }
    }

    private void logBuildingCallGraph() {
        this.mLogger.info((Object)"Building call graph");
    }

    private void logCallGraphComputed() {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info("Initial procedures are %s", new Object[]{this.mCallGraph.initialProceduresOfInterest()});
        }
    }

    private void logStartingInterpretation() {
        this.mLogger.info((Object)"Starting interpretation");
    }

    private void logFinalResults() {
        this.mLogger.info((Object)"Interpretation finished");
        Map<IcfgLocation, IPredicate> map = this.mLoiPredStorage.addDefaultsAndGetMap(this.mLocsOfInterest, this.mTools.bottom());
        if (map.isEmpty()) {
            this.mLogger.warn((Object)"No locations of interest were given");
            return;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Final predicates for locations of interest are:");
            for (Map.Entry<IcfgLocation, IPredicate> entry : map.entrySet()) {
                this.mLogger.debug("Reachable states at location %s satisfy %s", new Object[]{entry.getKey(), entry.getValue()});
            }
        }
    }

    private void logEnterProcedure(String string, IPredicate iPredicate) {
        this.mLogger.info("Interpreting procedure %s with input of size %s for LOIs", new Object[]{string, new DagSizePrinter(iPredicate.getFormula())});
        this.mLogger.debug("Procedure's input is %s", new Object[]{iPredicate});
    }

    private void logRegisterEnterCall(String string, IPredicate iPredicate) {
        this.mLogger.debug("Call to procedure %s received the input %s", new Object[]{string, iPredicate});
    }
}

