/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.cdt.core.dom.ast.ASTGenericVisitor;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;

public final class CdtASTUtils {
    private CdtASTUtils() {
    }

    public static IASTStatement findSuccessorStatement(IASTStatement iASTStatement) {
        if (iASTStatement == null || iASTStatement.getParent() == null) {
            return null;
        }
        IASTNode iASTNode = iASTStatement.getParent();
        if (!(iASTNode instanceof IASTStatement)) {
            return null;
        }
        IASTNode[] iASTNodeArray = iASTNode.getChildren();
        int n = 0;
        while (n < iASTNodeArray.length - 1) {
            if (iASTNodeArray[n].equals(iASTStatement)) {
                return CdtASTUtils.getFirstOrSuccessorStatement((IASTStatement)iASTNodeArray[n + 1]);
            }
            ++n;
        }
        assert (iASTNodeArray[iASTNodeArray.length - 1].equals(iASTStatement));
        return CdtASTUtils.findSuccessorStatement((IASTStatement)iASTNode);
    }

    public static IASTStatement findBranchingSuccessorStatement(boolean bl, IASTStatement iASTStatement) {
        if (iASTStatement instanceof IASTForStatement) {
            IASTForStatement iASTForStatement = (IASTForStatement)iASTStatement;
            return bl ? CdtASTUtils.getFirstOrSuccessorStatement(iASTForStatement.getBody()) : CdtASTUtils.findSuccessorStatement(iASTStatement);
        }
        if (iASTStatement instanceof IASTIfStatement) {
            IASTIfStatement iASTIfStatement = (IASTIfStatement)iASTStatement;
            return bl ? CdtASTUtils.getFirstOrSuccessorStatement(iASTIfStatement.getThenClause()) : CdtASTUtils.getFirstOrSuccessorStatement(iASTIfStatement.getElseClause());
        }
        if (iASTStatement instanceof IASTDoStatement) {
            IASTDoStatement iASTDoStatement = (IASTDoStatement)iASTStatement;
            return bl ? CdtASTUtils.getFirstOrSuccessorStatement(iASTDoStatement.getBody()) : CdtASTUtils.findSuccessorStatement(iASTStatement);
        }
        if (iASTStatement instanceof IASTWhileStatement) {
            IASTWhileStatement iASTWhileStatement = (IASTWhileStatement)iASTStatement;
            return bl ? CdtASTUtils.getFirstOrSuccessorStatement(iASTWhileStatement.getBody()) : CdtASTUtils.findSuccessorStatement(iASTStatement);
        }
        throw new IllegalArgumentException("statement " + String.valueOf(iASTStatement) + " is not a branching statement");
    }

    public static boolean isBranchingStatement(IASTStatement iASTStatement) {
        return iASTStatement instanceof IASTForStatement || iASTStatement instanceof IASTIfStatement || iASTStatement instanceof IASTDoStatement || iASTStatement instanceof IASTWhileStatement;
    }

    public static IASTStatement getFirstOrSuccessorStatement(IASTStatement iASTStatement) {
        if (iASTStatement instanceof IASTCompoundStatement) {
            return CdtASTUtils.getFirstOrSuccessorStatement((IASTCompoundStatement)iASTStatement);
        }
        return iASTStatement;
    }

    public static IASTStatement getEnclosingStatement(IASTNode iASTNode) {
        if (iASTNode == null || iASTNode.getParent() == null) {
            return null;
        }
        IASTNode iASTNode2 = iASTNode.getParent();
        while (iASTNode2 != null) {
            if (iASTNode2 instanceof IASTStatement) {
                return (IASTStatement)iASTNode2;
            }
            iASTNode2 = iASTNode2.getParent();
        }
        return null;
    }

    private static IASTStatement getFirstOrSuccessorStatement(IASTCompoundStatement iASTCompoundStatement) {
        IASTStatement[] iASTStatementArray = iASTCompoundStatement.getStatements();
        return iASTStatementArray.length == 0 ? CdtASTUtils.findSuccessorStatement((IASTStatement)iASTCompoundStatement) : CdtASTUtils.getFirstOrSuccessorStatement(iASTStatementArray[0]);
    }

    public static IASTFunctionDefinition findScope(IASTNode iASTNode) {
        IASTNode iASTNode2 = iASTNode;
        while (iASTNode2 != null) {
            if (iASTNode2 instanceof IASTFunctionDefinition) {
                return (IASTFunctionDefinition)iASTNode2;
            }
            if (iASTNode2 instanceof IASTTranslationUnit) {
                return null;
            }
            iASTNode2 = iASTNode2.getParent();
        }
        return null;
    }

    public static boolean isContainedInSubtree(IASTNode iASTNode, IASTNode iASTNode2) {
        return new SubtreeChecker(iASTNode::equals).check(iASTNode2);
    }

    public static IASTNode findCommonParent(Collection<IASTNode> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        assert (collection.stream().noneMatch(Objects::isNull));
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        ArrayList arrayList = new ArrayList();
        collection.stream().forEach(iASTNode -> {
            boolean bl = arrayList.add(CdtASTUtils.getParentNodes(iASTNode));
        });
        IASTNode iASTNode2 = collection.iterator().next();
        while (iASTNode2 != null) {
            IASTNode iASTNode3 = iASTNode2;
            if (arrayList.stream().allMatch(set -> set.contains(iASTNode3))) {
                return iASTNode3;
            }
            iASTNode2 = iASTNode2.getParent();
        }
        return null;
    }

    private static Set<IASTNode> getParentNodes(IASTNode iASTNode) {
        LinkedHashSet<IASTNode> linkedHashSet = new LinkedHashSet<IASTNode>();
        linkedHashSet.add(iASTNode);
        IASTNode iASTNode2 = iASTNode.getParent();
        while (iASTNode2 != null) {
            linkedHashSet.add(iASTNode2);
            iASTNode2 = iASTNode2.getParent();
        }
        return linkedHashSet;
    }

    public static Set<IASTStatement> findDesiredType(IASTNode iASTNode, Collection<Class<?>> collection) {
        if (iASTNode == null) {
            return Collections.emptySet();
        }
        return new DesiredTypeExtractor(collection).run(iASTNode);
    }

    public static boolean containsContinue(IASTStatement iASTStatement) {
        return new SubtreeChecker(IASTContinueStatement.class::isInstance).check((IASTNode)iASTStatement);
    }

    private static final class DesiredTypeExtractor
    extends ASTGenericVisitor {
        private Set<IASTStatement> mStatements;
        private final Collection<Class<?>> mDesiredClasses;

        public DesiredTypeExtractor(Collection<Class<?>> collection) {
            super(true);
            this.mDesiredClasses = collection;
        }

        public Set<IASTStatement> run(IASTNode iASTNode) {
            this.mStatements = new HashSet<IASTStatement>();
            iASTNode.accept((ASTVisitor)this);
            return this.mStatements;
        }

        public int visit(IASTStatement iASTStatement) {
            if (this.mDesiredClasses.stream().anyMatch(clazz -> clazz.isAssignableFrom(iASTStatement.getClass()))) {
                this.mStatements.add(iASTStatement);
                return 1;
            }
            return 3;
        }
    }

    private static final class SubtreeChecker
    extends ASTGenericVisitor {
        private final Predicate<IASTNode> mPredicate;
        private boolean mIsContainedInSubtree;

        public SubtreeChecker(Predicate<IASTNode> predicate) {
            super(true);
            this.mPredicate = predicate;
            this.mIsContainedInSubtree = false;
        }

        public boolean check(IASTNode iASTNode) {
            iASTNode.accept((ASTVisitor)this);
            return this.mIsContainedInSubtree;
        }

        protected int genericVisit(IASTNode iASTNode) {
            if (this.mIsContainedInSubtree) {
                return 2;
            }
            if (this.mPredicate.test(iASTNode)) {
                this.mIsContainedInSubtree = true;
                return 2;
            }
            return 3;
        }
    }
}

