/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.typechecker;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.ITypeErrorReporter;
import java.util.List;
import java.util.Objects;

public class TypeCheckHelper {
    private TypeCheckHelper() {
    }

    public static <T> BoogieType typeCheckArrayAccessExpressionOrLhs(BoogieType boogieType, List<BoogieType> list, ITypeErrorReporter<T> iTypeErrorReporter) {
        BoogieType boogieType2;
        if (!(boogieType instanceof BoogieArrayType)) {
            if (!BoogieType.TYPE_ERROR.equals(boogieType)) {
                iTypeErrorReporter.report(object -> "Type check failed (not an array): " + String.valueOf(object));
            }
            boogieType2 = BoogieType.TYPE_ERROR;
        } else {
            BoogieArrayType boogieArrayType = (BoogieArrayType)boogieType;
            BoogieType[] boogieTypeArray = new BoogieType[boogieArrayType.getNumPlaceholders()];
            if (list.size() != boogieArrayType.getIndexCount()) {
                iTypeErrorReporter.report(object -> "Type check failed (wrong number of indices): " + String.valueOf(object));
            } else {
                int n = 0;
                while (n < list.size()) {
                    BoogieType boogieType3 = list.get(n);
                    if (!BoogieType.TYPE_ERROR.equals(boogieType3) && !boogieArrayType.getIndexType(n).unify(boogieType3, boogieTypeArray)) {
                        int n2 = n;
                        iTypeErrorReporter.report(object -> "Type check failed (index " + n2 + "): " + String.valueOf(object));
                    }
                    ++n;
                }
            }
            boogieType2 = boogieArrayType.getValueType().substitutePlaceholders(boogieTypeArray);
        }
        return boogieType2;
    }

    public static <T> BoogieType typeCheckStructAccessExpressionOrLhs(BoogieType boogieType, String string, ITypeErrorReporter<T> iTypeErrorReporter) {
        BoogieType boogieType2;
        if (!(boogieType instanceof BoogieStructType)) {
            if (!BoogieType.TYPE_ERROR.equals(boogieType)) {
                iTypeErrorReporter.report(object -> "Type check failed (not a struct): " + String.valueOf(object));
            }
            boogieType2 = BoogieType.TYPE_ERROR;
        } else {
            BoogieStructType boogieStructType = (BoogieStructType)boogieType;
            boogieType2 = null;
            int n = 0;
            while (n < boogieStructType.getFieldCount()) {
                String string2 = boogieStructType.getFieldIds()[n];
                if (string2.equals(string) && (boogieType2 = boogieStructType.getFieldType(n)) == null) {
                    iTypeErrorReporter.report(object -> "Type check failed (field " + string2 + " not in struct): " + String.valueOf(object));
                    boogieType2 = BoogieType.TYPE_ERROR;
                    break;
                }
                ++n;
            }
        }
        return boogieType2;
    }

    public static <T> BoogieType typeCheckBitVectorAccessExpression(int n, int n2, int n3, BoogieType boogieType, ITypeErrorReporter<T> iTypeErrorReporter) {
        if (n3 < 0 || n2 < n3 || n < n2) {
            if (!BoogieType.TYPE_ERROR.equals(boogieType)) {
                iTypeErrorReporter.report(object -> "Type check failed for " + String.valueOf(object));
            }
            n2 = 0;
            n3 = 0;
        }
        BoogieType boogieType2 = BoogieType.createBitvectorType(n2 - n3);
        return boogieType2;
    }

    public static <T> BoogieType typeCheckUnaryExpression(UnaryExpression.Operator operator, BoogieType boogieType, ITypeErrorReporter<T> iTypeErrorReporter) {
        return switch (operator) {
            case UnaryExpression.Operator.LOGICNEG -> {
                if (!BoogieType.TYPE_ERROR.equals(boogieType) && !BoogieType.TYPE_BOOL.equals(boogieType)) {
                    iTypeErrorReporter.report(object -> "Type check failed for " + String.valueOf(object));
                }
                yield BoogieType.TYPE_BOOL;
            }
            case UnaryExpression.Operator.ARITHNEGATIVE -> {
                if (!(BoogieType.TYPE_ERROR.equals(boogieType) || BoogieType.TYPE_INT.equals(boogieType) || BoogieType.TYPE_REAL.equals(boogieType))) {
                    iTypeErrorReporter.report(object -> "Type check failed for " + String.valueOf(object));
                }
                yield boogieType;
            }
            case UnaryExpression.Operator.OLD -> boogieType;
            default -> throw new MatchException(null, null);
        };
    }

    public static <T> BoogieType typeCheckBinaryExpression(BinaryExpression.Operator operator, BoogieType boogieType, BoogieType boogieType2, ITypeErrorReporter<T> iTypeErrorReporter) {
        BoogieType boogieType3 = boogieType;
        BoogieType boogieType4 = boogieType2;
        return switch (operator) {
            case BinaryExpression.Operator.LOGICIFF, BinaryExpression.Operator.LOGICIMPLIES, BinaryExpression.Operator.LOGICAND, BinaryExpression.Operator.LOGICOR -> {
                if (!BoogieType.TYPE_ERROR.equals(boogieType3) && !BoogieType.TYPE_BOOL.equals(boogieType3) || !BoogieType.TYPE_ERROR.equals(boogieType4) && !BoogieType.TYPE_BOOL.equals(boogieType4)) {
                    iTypeErrorReporter.report(object -> "Type check failed for " + String.valueOf(object));
                }
                yield BoogieType.TYPE_BOOL;
            }
            case BinaryExpression.Operator.ARITHPLUS, BinaryExpression.Operator.ARITHMINUS, BinaryExpression.Operator.ARITHMUL, BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.ARITHMOD -> {
                if (BoogieType.TYPE_ERROR.equals(boogieType3)) {
                    boogieType3 = boogieType4;
                } else if (BoogieType.TYPE_ERROR.equals(boogieType4)) {
                    boogieType4 = boogieType3;
                }
                if (!boogieType4.equals(boogieType3) || !BoogieType.TYPE_INT.equals(boogieType3) && !BoogieType.TYPE_REAL.equals(boogieType3) || BoogieType.TYPE_REAL.equals(boogieType3) && operator == BinaryExpression.Operator.ARITHMOD) {
                    iTypeErrorReporter.report(object -> "Type check failed for " + String.valueOf(object));
                    yield BoogieType.TYPE_ERROR;
                }
                yield boogieType3;
            }
            case BinaryExpression.Operator.COMPLT, BinaryExpression.Operator.COMPGT, BinaryExpression.Operator.COMPLEQ, BinaryExpression.Operator.COMPGEQ -> {
                if (BoogieType.TYPE_ERROR.equals(boogieType3)) {
                    boogieType3 = boogieType4;
                } else if (BoogieType.TYPE_ERROR.equals(boogieType4)) {
                    boogieType4 = boogieType3;
                }
                if (!Objects.equals(boogieType3, boogieType4) || !BoogieType.TYPE_INT.equals(boogieType3) && !BoogieType.TYPE_REAL.equals(boogieType3)) {
                    iTypeErrorReporter.report(object -> "Type check failed for " + String.valueOf(object));
                }
                yield BoogieType.TYPE_BOOL;
            }
            case BinaryExpression.Operator.COMPEQ, BinaryExpression.Operator.COMPNEQ -> {
                if (!boogieType3.isUnifiableTo(boogieType4)) {
                    String var6_6 = String.valueOf(boogieType3) + " is not unifiable to " + String.valueOf(boogieType4) + ". ";
                    iTypeErrorReporter.report(object -> var6_6 + String.valueOf(object));
                }
                yield BoogieType.TYPE_BOOL;
            }
            case BinaryExpression.Operator.COMPPO -> {
                if (!(Objects.equals(boogieType3, boogieType4) || BoogieType.TYPE_ERROR.equals(boogieType3) || BoogieType.TYPE_ERROR.equals(boogieType4))) {
                    iTypeErrorReporter.report(object -> "Type check failed for " + String.valueOf(object) + ": " + String.valueOf(boogieType.getUnderlyingType()) + " != " + String.valueOf(boogieType2.getUnderlyingType()));
                }
                yield BoogieType.TYPE_BOOL;
            }
            case BinaryExpression.Operator.BITVECCONCAT -> {
                int var6_7 = TypeCheckHelper.getBitVecLength(boogieType3);
                int var7_8 = TypeCheckHelper.getBitVecLength(boogieType4);
                if (var6_7 < 0 || var7_8 < 0 || var6_7 + var7_8 < 0) {
                    if (!BoogieType.TYPE_ERROR.equals(boogieType3) && !BoogieType.TYPE_ERROR.equals(boogieType4)) {
                        iTypeErrorReporter.report(object -> "Type check failed for " + String.valueOf(object));
                    }
                    var6_7 = 0;
                    var7_8 = 0;
                }
                yield BoogieType.createBitvectorType(var6_7 + var7_8);
            }
            default -> throw new MatchException(null, null);
        };
    }

    public static <T> BoogieType typeCheckIfThenElseExpression(BoogieType boogieType, BoogieType boogieType2, BoogieType boogieType3, ITypeErrorReporter<T> iTypeErrorReporter) {
        BoogieType boogieType4;
        if (!boogieType.equals(BoogieType.TYPE_ERROR) && !boogieType.equals(BoogieType.TYPE_BOOL)) {
            iTypeErrorReporter.report(object -> "if expects boolean type: " + String.valueOf(object));
        }
        if (!boogieType2.isUnifiableTo(boogieType3)) {
            iTypeErrorReporter.report(object -> "Type check failed for " + String.valueOf(object));
            boogieType4 = BoogieType.TYPE_ERROR;
        } else {
            boogieType4 = boogieType2.equals(BoogieType.TYPE_ERROR) ? boogieType3 : boogieType2;
        }
        return boogieType4;
    }

    public static <T> void typeCheckAssignStatement(String[] stringArray, BoogieType[] boogieTypeArray, BoogieType[] boogieTypeArray2, ITypeErrorReporter<T> iTypeErrorReporter) {
        if (boogieTypeArray.length != boogieTypeArray2.length) {
            iTypeErrorReporter.report(object -> "Number of variables do not match in " + String.valueOf(object));
        } else {
            int n = 0;
            while (n < boogieTypeArray.length) {
                int n2 = 0;
                while (n2 < n) {
                    if (stringArray[n].equals(stringArray[n2])) {
                        iTypeErrorReporter.report(object -> "Variable appears multiple times in assignment: " + String.valueOf(object));
                    }
                    ++n2;
                }
                BoogieType boogieType = boogieTypeArray[n];
                BoogieType boogieType2 = boogieTypeArray2[n];
                if (!(BoogieType.TYPE_ERROR.equals(boogieType) || BoogieType.TYPE_ERROR.equals(boogieType2) || boogieType.equals(boogieType2))) {
                    iTypeErrorReporter.report(object -> "Type mismatch (" + String.valueOf(boogieType) + " != " + String.valueOf(boogieType2) + ") in " + String.valueOf(object));
                }
                ++n;
            }
        }
    }

    public static void internalError(String string) {
        throw new AssertionError((Object)string);
    }

    public static int getBitVecLength(BoogieType boogieType) {
        if (!((boogieType = boogieType.getUnderlyingType()) instanceof BoogiePrimitiveType)) {
            return -1;
        }
        return ((BoogiePrimitiveType)boogieType).getTypeCode();
    }

    public static <T> BoogieType typeCheckArrayStoreExpression(BoogieType boogieType, List<BoogieType> list, BoogieType boogieType2, ITypeErrorReporter<T> iTypeErrorReporter) {
        BoogieType boogieType3;
        if (!(boogieType instanceof BoogieArrayType)) {
            if (!BoogieType.TYPE_ERROR.equals(boogieType)) {
                iTypeErrorReporter.report(object -> "Type check failed (not an array): " + String.valueOf(object));
            }
            boogieType3 = BoogieType.TYPE_ERROR;
        } else {
            BoogieArrayType boogieArrayType = (BoogieArrayType)boogieType;
            BoogieType[] boogieTypeArray = new BoogieType[boogieArrayType.getNumPlaceholders()];
            if (list.size() != boogieArrayType.getIndexCount()) {
                iTypeErrorReporter.report(object -> "Type check failed (wrong number of indices): " + String.valueOf(object));
            } else {
                int n = 0;
                while (n < list.size()) {
                    BoogieType boogieType4 = list.get(n);
                    if (!BoogieType.TYPE_ERROR.equals(boogieType4) && !boogieArrayType.getIndexType(n).unify(boogieType4, boogieTypeArray)) {
                        int n2 = n;
                        iTypeErrorReporter.report(object -> "Type check failed (index " + n2 + "): " + String.valueOf(object));
                    }
                    ++n;
                }
                if (!BoogieType.TYPE_ERROR.equals(boogieType2) && !boogieArrayType.getValueType().unify(boogieType2, boogieTypeArray)) {
                    iTypeErrorReporter.report(object -> "Type check failed (value): " + String.valueOf(object));
                }
            }
            boogieType3 = boogieArrayType;
        }
        return boogieType3;
    }

    public static String getLeftHandSideIdentifier(LeftHandSide leftHandSide) {
        while (leftHandSide instanceof ArrayLHS || leftHandSide instanceof StructLHS) {
            if (leftHandSide instanceof ArrayLHS) {
                ArrayLHS arrayLHS = (ArrayLHS)leftHandSide;
                leftHandSide = arrayLHS.getArray();
                continue;
            }
            if (!(leftHandSide instanceof StructLHS)) continue;
            StructLHS structLHS = (StructLHS)leftHandSide;
            leftHandSide = structLHS.getStruct();
        }
        return ((VariableLHS)leftHandSide).getIdentifier();
    }
}

