/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.AtomicBlockInfo;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AtomicBlockAnalyzer {
    private final BoogieIcfgContainer mIcfg;
    private final Set<BoogieIcfgLocation> mAtomicPoints;
    private final Set<BoogieIcfgLocation> mAtomicBegins;
    private final Set<BoogieIcfgLocation> mAtomicEnds;

    public AtomicBlockAnalyzer(BoogieIcfgContainer boogieIcfgContainer) {
        this.mIcfg = boogieIcfgContainer;
        this.mAtomicPoints = this.collectAtomicPoints();
        assert (this.getAllLocations().allMatch(boogieIcfgLocation -> !this.mAtomicPoints.contains(boogieIcfgLocation) || this.allPredecessorsAtomic((BoogieIcfgLocation)((Object)boogieIcfgLocation)))) : "Atomic point with unexpected non-atomic predecessor!";
        assert (this.getAllLocations().allMatch(boogieIcfgLocation -> !this.mAtomicPoints.contains(boogieIcfgLocation) || this.allSuccessorsAtomic((BoogieIcfgLocation)((Object)boogieIcfgLocation)))) : "Atomic point with unexpected non-atomic successor!";
        this.mAtomicBegins = this.getAllLocations().filter(boogieIcfgLocation -> !this.mAtomicPoints.contains(boogieIcfgLocation) && boogieIcfgLocation.getOutgoingEdges().stream().anyMatch(icfgEdge -> AtomicBlockInfo.isStartOfAtomicBlock(icfgEdge) || AtomicBlockInfo.isCompleteAtomicBlock(icfgEdge))).collect(Collectors.toCollection(HashSet::new));
        this.mAtomicEnds = this.getAllLocations().filter(boogieIcfgLocation -> !this.mAtomicPoints.contains(boogieIcfgLocation) && boogieIcfgLocation.getIncomingEdges().stream().anyMatch(icfgEdge -> AtomicBlockInfo.isEndOfAtomicBlock(icfgEdge) || AtomicBlockInfo.isCompleteAtomicBlock(icfgEdge))).collect(Collectors.toCollection(HashSet::new));
    }

    public boolean isInsideAtomicBlock(BoogieIcfgLocation boogieIcfgLocation) {
        boolean bl = this.mAtomicPoints.contains((Object)boogieIcfgLocation);
        if (bl) {
            assert (this.allPredecessorsAtomic(boogieIcfgLocation)) : "Atomic point " + String.valueOf((Object)boogieIcfgLocation) + " has non-atomic predecessors";
            assert (this.allSuccessorsAtomic(boogieIcfgLocation)) : "Atomic point " + String.valueOf((Object)boogieIcfgLocation) + " has non-atomic successors";
        }
        return bl;
    }

    public boolean isAtomicBoundary(BoogieIcfgLocation boogieIcfgLocation) {
        return this.isAtomicBegin(boogieIcfgLocation) || this.isAtomicEnd(boogieIcfgLocation);
    }

    public boolean isAtomicBegin(BoogieIcfgLocation boogieIcfgLocation) {
        return this.mAtomicBegins.contains((Object)boogieIcfgLocation);
    }

    public boolean isAtomicEnd(BoogieIcfgLocation boogieIcfgLocation) {
        return this.mAtomicEnds.contains((Object)boogieIcfgLocation);
    }

    public void removeLocation(BoogieIcfgLocation boogieIcfgLocation) {
        this.mAtomicPoints.remove((Object)boogieIcfgLocation);
        this.mAtomicBegins.remove((Object)boogieIcfgLocation);
        this.mAtomicEnds.remove((Object)boogieIcfgLocation);
    }

    public static void ensureAtomicCompositionIsComplete(BoogieIcfgContainer boogieIcfgContainer, ILogger iLogger) {
        Iterable iterable = AtomicBlockAnalyzer.getAllEdges(boogieIcfgContainer)::iterator;
        for (IcfgEdge icfgEdge : iterable) {
            AtomicBlockAnalyzer.ensureAtomicCompositionComplete(icfgEdge, iLogger);
        }
    }

    private static void ensureAtomicCompositionComplete(IcfgEdge icfgEdge, ILogger iLogger) {
        if (AtomicBlockInfo.isEndOfAtomicBlock(icfgEdge)) {
            throw new UnsupportedOperationException("Incomplete atomic composition (dangling end of atomic block: " + String.valueOf(icfgEdge) + "). Is there illegal control flow (e.g. loops) within an atomic block?");
        }
        if (!AtomicBlockInfo.isStartOfAtomicBlock(icfgEdge)) {
            AtomicBlockInfo.removeAnnotation(icfgEdge);
            return;
        }
        BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)icfgEdge.getTarget();
        if (boogieIcfgLocation.isErrorLocation()) {
            AtomicBlockInfo.removeAnnotation(icfgEdge);
            return;
        }
        boolean bl = boogieIcfgLocation.getOutgoingEdges().isEmpty();
        if (!bl) {
            throw new UnsupportedOperationException("Incomplete atomic composition (dangling start of atomic block: " + String.valueOf(icfgEdge) + "). Is there illegal control flow (e.g. loops) within an atomic block?");
        }
        iLogger.warn("Unexpected successor node of atomic block begin: %s is not an error location.", new Object[]{boogieIcfgLocation});
        AtomicBlockInfo.removeAnnotation(icfgEdge);
    }

    private static Stream<IcfgEdge> getAllEdges(BoogieIcfgContainer boogieIcfgContainer) {
        return IcfgUtils.getAllLocations((IIcfg)boogieIcfgContainer).flatMap(boogieIcfgLocation -> boogieIcfgLocation.getOutgoingEdges().stream()).distinct();
    }

    private Stream<BoogieIcfgLocation> getAllLocations() {
        return IcfgUtils.getAllLocations((IIcfg)this.mIcfg);
    }

    private Stream<IcfgEdge> getAllEdges() {
        return this.getAllLocations().flatMap(boogieIcfgLocation -> boogieIcfgLocation.getOutgoingEdges().stream()).distinct();
    }

    private Set<BoogieIcfgLocation> collectAtomicPoints() {
        HashSet<BoogieIcfgLocation> hashSet = new HashSet<BoogieIcfgLocation>();
        ArrayDeque<Pair> arrayDeque = new ArrayDeque<Pair>();
        HashMap<BoogieIcfgLocation, Integer> hashMap = new HashMap<BoogieIcfgLocation, Integer>();
        this.getAllEdges().filter(AtomicBlockInfo::isStartOfAtomicBlock).forEach(icfgEdge -> {
            boolean bl = arrayDeque.add(new Pair(icfgEdge, (Object)0));
        });
        while (!arrayDeque.isEmpty()) {
            Pair pair = (Pair)arrayDeque.poll();
            IcfgEdge icfgEdge2 = (IcfgEdge)pair.getFirst();
            int n = (Integer)pair.getSecond();
            BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)icfgEdge2.getTarget();
            int n2 = AtomicBlockInfo.isEndOfAtomicBlock(icfgEdge2) ? n - 1 : (AtomicBlockInfo.isStartOfAtomicBlock(icfgEdge2) ? n + 1 : n);
            if (n2 == 0) continue;
            hashSet.add(boogieIcfgLocation);
            int n3 = hashMap.getOrDefault((Object)boogieIcfgLocation, 0);
            if (n3 >= n2) continue;
            hashMap.put(boogieIcfgLocation, n2);
            for (IcfgEdge icfgEdge3 : boogieIcfgLocation.getOutgoingEdges()) {
                arrayDeque.add(new Pair((Object)icfgEdge3, (Object)n2));
            }
        }
        return hashSet;
    }

    private boolean allPredecessorsAtomic(BoogieIcfgLocation boogieIcfgLocation) {
        return boogieIcfgLocation.getIncomingEdges().stream().allMatch(icfgEdge -> this.mAtomicPoints.contains(icfgEdge.getSource()) || AtomicBlockInfo.isStartOfAtomicBlock(icfgEdge));
    }

    private boolean allSuccessorsAtomic(BoogieIcfgLocation boogieIcfgLocation) {
        return boogieIcfgLocation.getOutgoingEdges().stream().allMatch(icfgEdge -> this.mAtomicPoints.contains(icfgEdge.getTarget()) || AtomicBlockInfo.isEndOfAtomicBlock(icfgEdge));
    }
}

