/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare;

import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import java.util.Collection;

class HoareAnnotationStatisticsGenerator
implements IStatisticsDataProvider {
    private int mFormulaSimplifications;
    private long mFormulaSimplificationTreeSizeReduction;
    private long mHoareSimplificationTime;
    private int mFormulaSimplificationsInter;
    private long mFormulaSimplificationTreeSizeReductionInter;
    private long mHoareSimplificationTimeInter;
    private long mHoareAnnotationTime;
    private long mHoareAnnotationTreeSize;
    private int mLocationsWithAnnotation;
    private int mPreInvPairs;
    private int mNumberOfFragments;

    HoareAnnotationStatisticsGenerator() {
    }

    public Object getValue(String string) {
        HoareAnnotationStatisticsDefinitions hoareAnnotationStatisticsDefinitions = HoareAnnotationStatisticsDefinitions.valueOf(string);
        return switch (hoareAnnotationStatisticsDefinitions) {
            case HoareAnnotationStatisticsDefinitions.FormulaSimplifications -> this.mFormulaSimplifications;
            case HoareAnnotationStatisticsDefinitions.FormulaSimplificationTreeSizeReduction -> this.mFormulaSimplificationTreeSizeReduction;
            case HoareAnnotationStatisticsDefinitions.HoareSimplificationTime -> this.mHoareSimplificationTime;
            case HoareAnnotationStatisticsDefinitions.FormulaSimplificationsInter -> this.mFormulaSimplificationsInter;
            case HoareAnnotationStatisticsDefinitions.FormulaSimplificationTreeSizeReductionInter -> this.mFormulaSimplificationTreeSizeReductionInter;
            case HoareAnnotationStatisticsDefinitions.HoareSimplificationTimeInter -> this.mHoareSimplificationTimeInter;
            case HoareAnnotationStatisticsDefinitions.HoareAnnotationTime -> this.mHoareAnnotationTime;
            case HoareAnnotationStatisticsDefinitions.HoareAnnotationTreeSize -> this.mHoareAnnotationTreeSize;
            case HoareAnnotationStatisticsDefinitions.LocationsWithAnnotation -> this.mLocationsWithAnnotation;
            case HoareAnnotationStatisticsDefinitions.PreInvPairs -> this.mPreInvPairs;
            case HoareAnnotationStatisticsDefinitions.NumberOfFragments -> this.mNumberOfFragments;
            default -> throw new MatchException(null, null);
        };
    }

    public IStatisticsType getBenchmarkType() {
        return HoareAnnotationStatisticsType.getInstance();
    }

    public Collection<String> getKeys() {
        return this.getBenchmarkType().getKeys();
    }

    public void reportSimplification() {
        ++this.mFormulaSimplifications;
    }

    public void reportReduction(long l) {
        this.mFormulaSimplificationTreeSizeReduction += l;
    }

    public void reportSimplificationTime(long l) {
        this.mHoareSimplificationTime += l;
    }

    public void reportSimplificationInter() {
        ++this.mFormulaSimplificationsInter;
    }

    public void reportReductionInter(long l) {
        this.mFormulaSimplificationTreeSizeReductionInter += l;
    }

    public void reportSimplificationTimeInter(long l) {
        this.mHoareSimplificationTimeInter += l;
    }

    public void setLocationsWithHoareAnnotation(int n) {
        if (this.mLocationsWithAnnotation != 0) {
            throw new AssertionError((Object)"already set");
        }
        this.mLocationsWithAnnotation = n;
    }

    public void setPreInvPairs(int n) {
        if (this.mPreInvPairs != 0) {
            throw new AssertionError((Object)"already set");
        }
        this.mPreInvPairs = n;
    }

    public void setNumberOfFragments(int n) {
        if (this.mNumberOfFragments != 0) {
            throw new AssertionError((Object)"already set");
        }
        this.mNumberOfFragments = n;
    }

    public void reportAnnotationSize(long l) {
        this.mHoareAnnotationTreeSize += l;
    }
}

