/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.CopyingTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class InvariantBasedSimplification
extends CopyingTransformulaTransformer {
    private final IUltimateServiceProvider mServices;
    private final Map<IcfgLocation, IPredicate> mInvariants;
    private final ManagedScript mMgdScript;
    private long mOverallTreesizeReduction = 0L;
    private int mEdges = 0;
    private int mSimplifiedEdges = 0;
    private int mSimplifiedToFalse = 0;

    public InvariantBasedSimplification(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, CfgSmtToolkit cfgSmtToolkit, Map<IcfgLocation, IPredicate> map) {
        super(iLogger, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit);
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = cfgSmtToolkit.getManagedScript();
        this.mInvariants = map;
    }

    @Override
    public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> iIcfgTransition, UnmodifiableTransFormula unmodifiableTransFormula) {
        ++this.mEdges;
        if (iIcfgTransition instanceof IIcfgInternalTransition) {
            return this.trySimplification(iIcfgTransition, unmodifiableTransFormula);
        }
        if (iIcfgTransition instanceof IIcfgSummaryTransition) {
            if (((IIcfgSummaryTransition)iIcfgTransition).calledProcedureHasImplementation()) {
                return new ITransformulaTransformer.TransformulaTransformationResult(unmodifiableTransFormula);
            }
            return this.trySimplification(iIcfgTransition, unmodifiableTransFormula);
        }
        if (iIcfgTransition instanceof IIcfgCallTransition) {
            return new ITransformulaTransformer.TransformulaTransformationResult(unmodifiableTransFormula);
        }
        if (iIcfgTransition instanceof IIcfgReturnTransition) {
            return new ITransformulaTransformer.TransformulaTransformationResult(unmodifiableTransFormula);
        }
        throw new AssertionError((Object)("Unsupported edge " + iIcfgTransition.getClass().getSimpleName()));
    }

    public ITransformulaTransformer.TransformulaTransformationResult trySimplification(IIcfgTransition<? extends IcfgLocation> iIcfgTransition, UnmodifiableTransFormula unmodifiableTransFormula) throws AssertionError {
        IcfgLocation icfgLocation = iIcfgTransition.getSource();
        IPredicate iPredicate = this.mInvariants.get(icfgLocation);
        Objects.requireNonNull(iPredicate);
        SmtUtils.ExtendedSimplificationResult extendedSimplificationResult = SmtUtils.simplifyWithStatistics((ManagedScript)this.mMgdScript, (Term)unmodifiableTransFormula.getFormula(), (Term)iPredicate.getFormula(), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA2);
        long l = extendedSimplificationResult.getReductionOfTreeSize();
        if (unmodifiableTransFormula.getFormula() != extendedSimplificationResult.getSimplifiedTerm()) {
            ++this.mSimplifiedEdges;
            this.mOverallTreesizeReduction += l;
            if (!SmtUtils.isFalseLiteral((Term)unmodifiableTransFormula.getFormula()) && SmtUtils.isFalseLiteral((Term)extendedSimplificationResult.getSimplifiedTerm())) {
                ++this.mSimplifiedToFalse;
            }
            UnmodifiableTransFormula unmodifiableTransFormula2 = this.constructSimplifiedTransformula(unmodifiableTransFormula, extendedSimplificationResult.getSimplifiedTerm());
            return new ITransformulaTransformer.TransformulaTransformationResult(unmodifiableTransFormula2);
        }
        return new ITransformulaTransformer.TransformulaTransformationResult(unmodifiableTransFormula);
    }

    public UnmodifiableTransFormula constructSimplifiedTransformula(UnmodifiableTransFormula unmodifiableTransFormula, Term term2) {
        Set set;
        Map.Entry entry;
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(unmodifiableTransFormula.getFormula().getFreeVars()));
        HashSet<TermVariable> hashSet2 = new HashSet<TermVariable>(Arrays.asList(term2.getFreeVars()));
        HashMap hashMap = new HashMap(unmodifiableTransFormula.getInVars());
        HashMap hashMap2 = new HashMap(unmodifiableTransFormula.getOutVars());
        HashSet hashSet3 = hashMap.entrySet().iterator();
        while (hashSet3.hasNext()) {
            entry = hashSet3.next();
            if (!hashSet.contains(entry.getValue()) || hashSet2.contains(entry.getValue())) continue;
            hashSet3.remove();
            if (hashMap2.get(entry.getKey()) != entry.getValue()) continue;
            hashMap2.remove(entry.getKey());
        }
        if (unmodifiableTransFormula.getNonTheoryConsts().isEmpty()) {
            hashSet3 = unmodifiableTransFormula.getNonTheoryConsts();
        } else {
            hashSet3 = new HashSet(unmodifiableTransFormula.getNonTheoryConsts());
            entry = term -> term instanceof ApplicationTerm && !((ApplicationTerm)term).getFunction().isIntern();
            set = SubTermFinder.find((Term)term2, (Predicate)((Object)entry), (boolean)false);
            Iterator iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                IProgramConst iProgramConst = (IProgramConst)iterator.next();
                if (set.contains(iProgramConst.getDefaultConstant())) continue;
                iterator.remove();
            }
        }
        entry = new TransFormulaBuilder(hashMap, hashMap2, hashSet3.isEmpty(), hashSet3.isEmpty() ? null : unmodifiableTransFormula.getNonTheoryConsts(), unmodifiableTransFormula.getBranchEncoders().isEmpty(), (Collection)(unmodifiableTransFormula.getBranchEncoders().isEmpty() ? null : unmodifiableTransFormula.getBranchEncoders()), unmodifiableTransFormula.getAuxVars().isEmpty());
        entry.setFormula(term2);
        entry.addAuxVarsButRenameToFreshCopies(unmodifiableTransFormula.getAuxVars(), this.mMgdScript);
        if (SmtUtils.isFalseLiteral((Term)term2)) {
            entry.setInfeasibility(UnmodifiableTransFormula.Infeasibility.INFEASIBLE);
        } else {
            if (unmodifiableTransFormula.isInfeasible() == UnmodifiableTransFormula.Infeasibility.INFEASIBLE) {
                throw new AssertionError((Object)"Infeasible but not false");
            }
            entry.setInfeasibility(unmodifiableTransFormula.isInfeasible());
        }
        set = entry.finishConstruction(this.mMgdScript);
        return set;
    }

    public long getOverallTreesizeReduction() {
        return this.mOverallTreesizeReduction;
    }

    public int getEdges() {
        return this.mEdges;
    }

    public int getSimplifiedEdges() {
        return this.mSimplifiedEdges;
    }

    public int getSimplifiedToFalse() {
        return this.mSimplifiedToFalse;
    }
}

