/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc.eldarica;

import ap.api.SimpleAPI;
import ap.basetypes.IdealInt;
import ap.parser.IAtom;
import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IIntLit;
import ap.parser.ITerm;
import ap.terfor.preds.Predicate;
import ap.theories.arrays.ExtArray;
import ap.types.Sort;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.chc.eldarica.Backtranslator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BidirectionalMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lazabs.horn.bottomup.HornClauses;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.immutable.List;

class Translator {
    private static final Map<String, BiFunction<ITerm, ITerm, IExpression>> BINARY_EXPRESSION_TRANSLATION = Map.of("=", ITerm::$eq$eq$eq, "distinct", ITerm::$eq$div$eq, "<", ITerm::$less, "<=", ITerm::$less$eq, ">", ITerm::$greater, ">=", ITerm::$greater$eq, "+", ITerm::$plus, "-", ITerm::$minus);
    private final SimpleAPI mPrincess;
    private final BidirectionalMap<HcPredicateSymbol, Predicate> mPredicateMap = new BidirectionalMap();
    private final BidirectionalMap<TermVariable, ITerm> mVariableMap = new BidirectionalMap();
    private final NestedMap2<List<Sort>, Sort, ExtArray> mArrayTheories = new NestedMap2();

    public Translator(SimpleAPI simpleAPI) {
        this.mPrincess = simpleAPI;
    }

    public Backtranslator createBacktranslator(Script script) {
        return new Backtranslator(script, this.mPredicateMap);
    }

    public HornClauses.Clause translateClause(HornClause hornClause) {
        Object object;
        IAtom iAtom;
        if (hornClause.isHeadFalse()) {
            iAtom = new IAtom(HornClauses.FALSE(), Translator.toList(java.util.List.of()));
        } else {
            object = this.getPredicateSymbol(hornClause.getHeadPredicate());
            java.util.List list = hornClause.getTermVariablesForHeadPred().stream().map(HcVar::getTermVariable).map(this::translateTerm).collect(Collectors.toList());
            iAtom = new IAtom((Predicate)object, Translator.toList(list));
        }
        object = new ArrayList(hornClause.getRank());
        int n = 0;
        while (n < hornClause.getRank()) {
            Predicate predicate = this.getPredicateSymbol(hornClause.getBodyPredicates().get(n));
            java.util.List list = hornClause.getBodyPredToArgs().get(n).stream().map(this::translateTerm).collect(Collectors.toList());
            ((ArrayList)object).add(new IAtom(predicate, Translator.toList(list)));
            ++n;
        }
        IFormula iFormula = this.translateFormula(hornClause.getConstraintFormula());
        return new HornClauses.Clause(iAtom, Translator.toList(object), iFormula);
    }

    private static <X> List<X> toList(java.util.List<X> list) {
        return ((Iterator)JavaConverters.asScalaIteratorConverter(list.iterator()).asScala()).toList();
    }

    private Predicate getPredicateSymbol(HcPredicateSymbol hcPredicateSymbol) {
        return (Predicate)this.mPredicateMap.computeIfAbsent((Object)hcPredicateSymbol, this::createPredicate);
    }

    private Predicate createPredicate(HcPredicateSymbol hcPredicateSymbol) {
        java.util.List list = hcPredicateSymbol.getParameterSorts().stream().map(this::translateSort).collect(Collectors.toList());
        return this.mPrincess.createRelation(hcPredicateSymbol.getName(), Translator.toList(list));
    }

    private Sort translateSort(de.uni_freiburg.informatik.ultimate.logic.Sort sort) {
        if (SmtSortUtils.isIntSort((de.uni_freiburg.informatik.ultimate.logic.Sort)sort)) {
            return new Sort.Integer$();
        }
        if (SmtSortUtils.isBoolSort((de.uni_freiburg.informatik.ultimate.logic.Sort)sort)) {
            return new Sort.MultipleValueBool$();
        }
        if (SmtSortUtils.isArraySort((de.uni_freiburg.informatik.ultimate.logic.Sort)sort)) {
            return this.getArrayTheory(sort).sort();
        }
        throw new IllegalArgumentException(sort.getName());
    }

    private ExtArray getArrayTheory(de.uni_freiburg.informatik.ultimate.logic.Sort sort) {
        Sort sort2;
        de.uni_freiburg.informatik.ultimate.logic.Sort[] sortArray = sort.getArguments();
        assert (sortArray.length >= 2) : "arrays should have at least one index sort, and one domain sort";
        List list = Translator.toList(Arrays.stream(sortArray).limit(sortArray.length - 1).map(this::translateSort).collect(Collectors.toList()));
        ExtArray extArray = (ExtArray)this.mArrayTheories.get(list, (Object)(sort2 = this.translateSort(sortArray[sortArray.length - 1])));
        if (extArray == null) {
            extArray = new ExtArray(list, sort2);
            this.mArrayTheories.put(list, (Object)sort2, (Object)extArray);
        }
        return extArray;
    }

    public IFormula translateFormula(Term term) {
        IExpression iExpression = this.translateExpression(term);
        if (iExpression instanceof ITerm) {
            return new Sort.MultipleValueBool$().isTrue((ITerm)iExpression);
        }
        return (IFormula)this.translateExpression(term);
    }

    public ITerm translateTerm(Term term) {
        IExpression iExpression = this.translateExpression(term);
        if (iExpression instanceof IFormula) {
            Sort.MultipleValueBool$ multipleValueBool$ = new Sort.MultipleValueBool$();
            return IExpression.ite((IFormula)((IFormula)iExpression), (ITerm)multipleValueBool$.True(), (ITerm)multipleValueBool$.False());
        }
        return (ITerm)this.translateExpression(term);
    }

    private IExpression translateExpression(Term term) {
        if (term instanceof TermVariable) {
            return this.translateVariable((TermVariable)term);
        }
        if (term instanceof ApplicationTerm) {
            return this.translateApplication((ApplicationTerm)term);
        }
        if (term instanceof ConstantTerm) {
            return Translator.translateConstant((ConstantTerm)term);
        }
        throw new IllegalArgumentException(term.toString());
    }

    private IExpression translateVariable(TermVariable termVariable) {
        return (IExpression)this.mVariableMap.computeIfAbsent((Object)termVariable, this::createVariable);
    }

    private ITerm createVariable(TermVariable termVariable) {
        de.uni_freiburg.informatik.ultimate.logic.Sort sort = termVariable.getSort();
        return this.mPrincess.createConstant(termVariable.getName(), this.translateSort(sort));
    }

    private IExpression translateApplication(ApplicationTerm applicationTerm) {
        String string = applicationTerm.getFunction().getName();
        BiFunction<ITerm, ITerm, IExpression> biFunction = BINARY_EXPRESSION_TRANSLATION.get(string);
        if (biFunction != null) {
            return this.translateBinaryExpression(applicationTerm, biFunction);
        }
        switch (applicationTerm.getFunction().getName()) {
            case "true": 
            case "false": {
                String string2 = applicationTerm.getFunction().getName();
                assert (applicationTerm.getParameters().length == 0) : "Unexpected parameters for function " + string2;
                return new IBoolLit(Boolean.parseBoolean(string2));
            }
            case "and": {
                java.util.List list = Arrays.stream(applicationTerm.getParameters()).map(this::translateFormula).collect(Collectors.toList());
                return IExpression.and(Translator.toList(list));
            }
            case "or": {
                java.util.List list = Arrays.stream(applicationTerm.getParameters()).map(this::translateFormula).collect(Collectors.toList());
                return IExpression.or(Translator.toList(list));
            }
            case "=>": {
                IFormula iFormula = this.translateFormula(applicationTerm.getParameters()[0]);
                IFormula iFormula2 = this.translateFormula(applicationTerm.getParameters()[1]);
                return iFormula.$eq$eq$greater(iFormula2);
            }
            case "not": {
                return this.translateFormula(applicationTerm.getParameters()[0]).unary_$bang();
            }
            case "ite": {
                IFormula iFormula = this.translateFormula(applicationTerm.getParameters()[0]);
                ITerm iTerm = this.translateTerm(applicationTerm.getParameters()[1]);
                ITerm iTerm2 = this.translateTerm(applicationTerm.getParameters()[2]);
                return IExpression.ite((IFormula)iFormula, (ITerm)iTerm, (ITerm)iTerm2);
            }
            case "store": {
                ITerm iTerm = this.translateTerm(applicationTerm.getParameters()[0]);
                ITerm iTerm3 = this.translateTerm(applicationTerm.getParameters()[1]);
                ITerm iTerm4 = this.translateTerm(applicationTerm.getParameters()[2]);
                return new IFunApp(this.getArrayTheory(applicationTerm.getParameters()[0].getSort()).store(), Translator.toList(java.util.List.of(iTerm, iTerm3, iTerm4)));
            }
            case "select": {
                ITerm iTerm = this.translateTerm(applicationTerm.getParameters()[0]);
                ITerm iTerm5 = this.translateTerm(applicationTerm.getParameters()[1]);
                return new IFunApp(this.getArrayTheory(applicationTerm.getParameters()[0].getSort()).select(), Translator.toList(java.util.List.of(iTerm, iTerm5)));
            }
        }
        throw new IllegalArgumentException(applicationTerm.toString());
    }

    private IExpression translateBinaryExpression(ApplicationTerm applicationTerm, BiFunction<ITerm, ITerm, IExpression> biFunction) {
        assert (applicationTerm.getParameters().length == 2);
        ITerm iTerm = this.translateTerm(applicationTerm.getParameters()[0]);
        ITerm iTerm2 = this.translateTerm(applicationTerm.getParameters()[1]);
        return biFunction.apply(iTerm, iTerm2);
    }

    private static ITerm translateConstant(ConstantTerm constantTerm) {
        BigInteger bigInteger;
        Object object = constantTerm.getValue();
        if (object instanceof Rational) {
            assert (((Rational)object).denominator().equals(BigInteger.ONE));
            bigInteger = ((Rational)object).numerator();
        } else if (object instanceof BigInteger) {
            bigInteger = (BigInteger)object;
        } else {
            throw new IllegalArgumentException(constantTerm.toString());
        }
        return new IIntLit(IdealInt.apply((BigInteger)bigInteger));
    }
}

