/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.IBuchiNwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Analyze;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsDeterministic;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.QuotientNwaConstructor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DoubleDeckerVisitor;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IPartition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class AbstractMinimizeNwa<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IMinimizationCheckResultStateFactory<STATE>> {
    protected final IMinimizationStateFactory<STATE> mStateFactory;
    private INestedWordAutomaton<LETTER, STATE> mResult = null;
    private NestedWordAutomaton<LETTER, STATE> mTemporaryResult = null;
    private Map<STATE, STATE> mOldState2NewState = null;

    protected AbstractMinimizeNwa(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory) {
        super(automataLibraryServices);
        this.mStateFactory = iMinimizationStateFactory;
    }

    @Override
    protected abstract INestedWordAutomaton<LETTER, STATE> getOperand();

    @Override
    public final String exitMessage() {
        return "Finished " + this.getOperationName() + ". Reduced states from " + this.getOperand().size() + " to " + this.getResult().size() + ".";
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        if (this.mResult == null) {
            throw new NoSuchElementException("The result is not ready yet.");
        }
        return this.mResult;
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        this.addStatistics(automataOperationStatistics);
        return automataOperationStatistics;
    }

    private void addStatistics(AutomataOperationStatistics automataOperationStatistics) {
        int n = this.getOperand().size();
        automataOperationStatistics.addKeyValuePair(StatisticsType.STATES_INPUT, n);
        if (this.mResult != null) {
            int n2 = this.mResult.size();
            automataOperationStatistics.addKeyValuePair(StatisticsType.STATES_OUTPUT, n2);
            automataOperationStatistics.addDifferenceData(StatisticsType.STATES_INPUT, StatisticsType.STATES_OUTPUT, StatisticsType.STATES_REDUCTION_ABSOLUTE);
            automataOperationStatistics.addPercentageDataInverted(StatisticsType.STATES_INPUT, StatisticsType.STATES_OUTPUT, StatisticsType.STATES_REDUCTION_RELATIVE);
        }
        Analyze analyze = new Analyze(this.mServices, this.getOperand(), true);
        int n3 = analyze.getNumberOfTransitions(Analyze.SymbolType.TOTAL);
        automataOperationStatistics.addKeyValuePair(StatisticsType.BUCHI_NONDETERMINISTIC_STATES, analyze.getNumberOfNondeterministicStates());
        automataOperationStatistics.addKeyValuePair(StatisticsType.BUCHI_ALPHABET_SIZE, analyze.getNumberOfSymbols(Analyze.SymbolType.TOTAL));
        automataOperationStatistics.addKeyValuePair(StatisticsType.BUCHI_TRANSITIONS, n3);
        automataOperationStatistics.addKeyValuePair(StatisticsType.BUCHI_TRANSITION_DENSITY_MILLION, (int)Math.round(analyze.getTransitionDensity(Analyze.SymbolType.TOTAL) * 1000000.0));
        automataOperationStatistics.addKeyValuePair(StatisticsType.ALPHABET_SIZE_INTERNAL, analyze.getNumberOfSymbols(Analyze.SymbolType.INTERNAL));
        automataOperationStatistics.addKeyValuePair(StatisticsType.ALPHABET_SIZE_CALL, analyze.getNumberOfSymbols(Analyze.SymbolType.CALL));
        automataOperationStatistics.addKeyValuePair(StatisticsType.ALPHABET_SIZE_RETURN, analyze.getNumberOfSymbols(Analyze.SymbolType.RETURN));
        automataOperationStatistics.addKeyValuePair(StatisticsType.TRANSITIONS_INTERNAL_INPUT, analyze.getNumberOfTransitions(Analyze.SymbolType.INTERNAL));
        automataOperationStatistics.addKeyValuePair(StatisticsType.TRANSITIONS_CALL_INPUT, analyze.getNumberOfTransitions(Analyze.SymbolType.CALL));
        automataOperationStatistics.addKeyValuePair(StatisticsType.TRANSITIONS_RETURN_INPUT, analyze.getNumberOfTransitions(Analyze.SymbolType.RETURN));
        if (this.mResult != null) {
            Analyze<LETTER, STATE> analyze2 = new Analyze<LETTER, STATE>(this.mServices, this.mResult, true);
            int n4 = analyze2.getNumberOfTransitions(Analyze.SymbolType.TOTAL);
            automataOperationStatistics.addKeyValuePair(StatisticsType.RESULT_NONDETERMINISTIC_STATES, analyze2.getNumberOfNondeterministicStates());
            automataOperationStatistics.addKeyValuePair(StatisticsType.RESULT_ALPHABET_SIZE, analyze2.getNumberOfSymbols(Analyze.SymbolType.TOTAL));
            automataOperationStatistics.addKeyValuePair(StatisticsType.RESULT_TRANSITIONS, n4);
            automataOperationStatistics.addKeyValuePair(StatisticsType.RESULT_TRANSITION_DENSITY_MILLION, (int)Math.round(analyze2.getTransitionDensity(Analyze.SymbolType.TOTAL) * 1000000.0));
            automataOperationStatistics.addKeyValuePair(StatisticsType.REMOVED_TRANSITIONS, n3 - n4);
            automataOperationStatistics.addKeyValuePair(StatisticsType.TRANSITIONS_INTERNAL_OUTPUT, analyze2.getNumberOfTransitions(Analyze.SymbolType.INTERNAL));
            automataOperationStatistics.addKeyValuePair(StatisticsType.TRANSITIONS_CALL_OUTPUT, analyze2.getNumberOfTransitions(Analyze.SymbolType.CALL));
            automataOperationStatistics.addKeyValuePair(StatisticsType.TRANSITIONS_RETURN_OUTPUT, analyze2.getNumberOfTransitions(Analyze.SymbolType.RETURN));
            automataOperationStatistics.addDifferenceData(StatisticsType.BUCHI_TRANSITIONS, StatisticsType.RESULT_TRANSITIONS, StatisticsType.TRANSITIONS_REDUCTION_ABSOLUTE);
            automataOperationStatistics.addPercentageDataInverted(StatisticsType.BUCHI_TRANSITIONS, StatisticsType.RESULT_TRANSITIONS, StatisticsType.TRANSITIONS_REDUCTION_RELATIVE);
        }
    }

    @Override
    public final boolean checkResult(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
        Pair<Boolean, String> pair = this.checkResultHelper(iMinimizationCheckResultStateFactory);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        if (!((Boolean)pair.getFirst()).booleanValue()) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", (String)pair.getSecond(), this.getOperand());
        }
        return (Boolean)pair.getFirst();
    }

    public Map<STATE, STATE> getOldState2newState() {
        if (this.mOldState2NewState == null) {
            throw new NoSuchElementException("No map from old states to new states was added.");
        }
        return this.mOldState2NewState;
    }

    public boolean hasOldState2newState() {
        return this.mOldState2NewState != null;
    }

    protected final void directResultConstruction(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        if (this.mResult != null) {
            throw new AssertionError((Object)"The result has already been constructed.");
        }
        if (this.mTemporaryResult != null) {
            throw new AssertionError((Object)"The result construction has already been started.");
        }
        this.mResult = iNestedWordAutomaton;
    }

    protected void constructResultFromPartition(IPartition<STATE> iPartition, boolean bl) {
        QuotientNwaConstructor quotientNwaConstructor = new QuotientNwaConstructor(this.mServices, this.mStateFactory, this.getOperand(), iPartition, bl);
        this.constructResultFromQuotientConstructor(quotientNwaConstructor);
    }

    private void constructResultFromQuotientConstructor(QuotientNwaConstructor<LETTER, STATE> quotientNwaConstructor) {
        this.directResultConstruction(quotientNwaConstructor.getResult());
        Map<STATE, STATE> map = quotientNwaConstructor.getOldState2newState();
        if (map != null) {
            this.setOld2NewStateMap(map);
        }
    }

    protected final void startResultConstruction() {
        if (this.mResult != null) {
            throw new AssertionError((Object)"The result has already been constructed.");
        }
        this.mTemporaryResult = new DoubleDeckerAutomaton(this.mServices, this.getOperand().getVpAlphabet(), this.mStateFactory);
    }

    protected final void addState(boolean bl, boolean bl2, STATE STATE) {
        this.mTemporaryResult.addState(bl, bl2, STATE);
    }

    protected final STATE addState(boolean bl, boolean bl2, Collection<STATE> collection) {
        assert (!collection.isEmpty());
        STATE STATE = this.mStateFactory.merge(collection);
        this.mTemporaryResult.addState(bl, bl2, STATE);
        return STATE;
    }

    protected final void addInternalTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        this.mTemporaryResult.addInternalTransition(STATE, LETTER, STATE2);
    }

    protected final void addCallTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        this.mTemporaryResult.addCallTransition(STATE, LETTER, STATE2);
    }

    protected final void addReturnTransition(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        this.mTemporaryResult.addReturnTransition(STATE, STATE2, LETTER, STATE3);
    }

    protected final void finishResultConstruction(Map<STATE, STATE> map, boolean bl) {
        if (map != null) {
            this.setOld2NewStateMap(map);
            if (bl) {
                this.constructDoubleDeckerInformation();
            }
        }
        this.mResult = this.mTemporaryResult;
        this.mTemporaryResult = null;
    }

    private void constructDoubleDeckerInformation() {
        assert (this.mTemporaryResult instanceof DoubleDeckerAutomaton) : "The result must be a DoubleDeckerAutomaton.";
        DoubleDeckerAutomaton doubleDeckerAutomaton = (DoubleDeckerAutomaton)this.mTemporaryResult;
        assert (this.getOperand() instanceof IDoubleDeckerAutomaton) : "The operand must be an IDoubleDeckerAutomaton.";
        IDoubleDeckerAutomaton iDoubleDeckerAutomaton = (IDoubleDeckerAutomaton)this.getOperand();
        assert (!doubleDeckerAutomaton.up2DownIsSet()) : "The down state map was already set.";
        assert (this.mOldState2NewState != null) : "Need the mapping for construction.";
        HashMap hashMap = new HashMap();
        doubleDeckerAutomaton.setUp2Down(hashMap);
        Object STATE = this.getOperand().getEmptyStackState();
        Object STATE2 = this.mStateFactory.createEmptyStackState();
        for (Object STATE3 : this.getOperand().getStates()) {
            STATE STATE4 = this.mOldState2NewState.get(STATE3);
            HashMap hashMap2 = (HashMap)hashMap.get(STATE4);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                hashMap.put(STATE4, hashMap2);
            }
            for (Object STATE5 : iDoubleDeckerAutomaton.getDownStates(STATE3)) {
                Object STATE6 = STATE5 == STATE ? STATE2 : this.mOldState2NewState.get(STATE5);
                hashMap2.put(STATE6, DoubleDeckerVisitor.ReachFinal.UNKNOWN);
            }
        }
    }

    protected final void setOld2NewStateMap(Map<STATE, STATE> map) {
        if (map == null) {
            throw new AssertionError((Object)"The map must not be set to null.");
        }
        if (this.mOldState2NewState != null) {
            throw new AssertionError((Object)"The map has already been set.");
        }
        this.mOldState2NewState = Collections.unmodifiableMap(map);
    }

    protected final boolean isDfa() throws AutomataOperationCanceledException {
        return this.isDeterministic() && this.isFiniteAutomaton();
    }

    protected final boolean isDeterministic() throws AutomataOperationCanceledException {
        return new IsDeterministic(this.mServices, this.getOperand()).getResult();
    }

    protected final boolean isFiniteAutomaton() {
        return NestedWordAutomataUtils.isFiniteAutomaton(this.getOperand());
    }

    protected final void checkForContinuation() throws AutomataOperationCanceledException {
        if (this.isCancellationRequested()) {
            throw new AutomataOperationCanceledException(this.getClass());
        }
    }

    protected abstract Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> var1) throws AutomataLibraryException;

    protected final Pair<Boolean, String> checkLanguageEquivalence(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        IsEquivalent isEquivalent = new IsEquivalent(this.mServices, iNwaInclusionStateFactory, this.getOperand(), this.getResult());
        return new Pair((Object)isEquivalent.getResult(), (Object)isEquivalent.getViolationMessage());
    }

    protected final Pair<Boolean, String> checkBuchiEquivalence(IBuchiNwaInclusionStateFactory<STATE> iBuchiNwaInclusionStateFactory) throws AutomataLibraryException {
        BuchiIsEquivalent buchiIsEquivalent = new BuchiIsEquivalent(this.mServices, iBuchiNwaInclusionStateFactory, this.getOperand(), this.getResult());
        return new Pair((Object)buchiIsEquivalent.getResult(), (Object)buchiIsEquivalent.getViolationMessage());
    }

    protected static final int computeHashCap(int n) {
        return (int)((float)n * 1.34f + 1.0f);
    }
}

