/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class EqualityAnalysisResult {
    private final Set<Doubleton<Term>> mEqualDoubletons;
    private final Set<Doubleton<Term>> mDistinctDoubletons;
    private final Set<Doubleton<Term>> mUnknownDoubletons;

    public EqualityAnalysisResult(Set<Doubleton<Term>> set, Set<Doubleton<Term>> set2, Set<Doubleton<Term>> set3) {
        this.mEqualDoubletons = set;
        this.mDistinctDoubletons = set2;
        this.mUnknownDoubletons = set3;
    }

    public EqualityAnalysisResult(Set<Doubleton<Term>> set) {
        Set set2 = Collections.emptySet();
        this.mEqualDoubletons = set2;
        this.mDistinctDoubletons = set2;
        this.mUnknownDoubletons = set;
    }

    public Set<Doubleton<Term>> getEqualDoubletons() {
        return this.mEqualDoubletons;
    }

    public Set<Doubleton<Term>> getDistinctDoubletons() {
        return this.mDistinctDoubletons;
    }

    public Set<Doubleton<Term>> getUnknownDoubletons() {
        return this.mUnknownDoubletons;
    }

    public static Term equalTerm(Script script, Doubleton<Term> doubleton) {
        return SmtUtils.binaryEquality((Script)script, (Term)((Term)doubleton.getOneElement()), (Term)((Term)doubleton.getOtherElement()));
    }

    public static Term notEqualTerm(Script script, Doubleton<Term> doubleton) {
        return SmtUtils.not((Script)script, (Term)EqualityAnalysisResult.equalTerm(script, doubleton));
    }

    public List<Term> constructListOfEqualities(Script script) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Doubleton<Term> doubleton : this.getEqualDoubletons()) {
            arrayList.add(EqualityAnalysisResult.equalTerm(script, doubleton));
        }
        return arrayList;
    }

    public List<Term> constructListOfNotEquals(Script script) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Doubleton<Term> doubleton : this.getDistinctDoubletons()) {
            arrayList.add(EqualityAnalysisResult.notEqualTerm(script, doubleton));
        }
        return arrayList;
    }

    public EqualityStatus getEqualityStatus(Doubleton<Term> doubleton) {
        if (this.mEqualDoubletons.contains(doubleton)) {
            return EqualityStatus.EQUAL;
        }
        if (this.mDistinctDoubletons.contains(doubleton)) {
            return EqualityStatus.NOT_EQUAL;
        }
        if (this.mUnknownDoubletons.contains(doubleton)) {
            return EqualityStatus.UNKNOWN;
        }
        throw new IllegalArgumentException("unacquainted doublton " + String.valueOf(doubleton));
    }
}

