/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ModelBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.WeakCongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedLinkedHashSet;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayTheory
implements ITheory {
    private final Clausifier mClausifier;
    private final CClosure mCClosure;
    private final ScopedArrayList<CCTerm> mArrays = new ScopedArrayList();
    private final ScopedLinkedHashSet<CCAppTerm> mStores = new ScopedLinkedHashSet();
    private final ScopedLinkedHashSet<CCAppTerm> mDiffs = new ScopedLinkedHashSet();
    private final ScopedLinkedHashSet<CCAppTerm> mConsts = new ScopedLinkedHashSet();
    private final ArrayDeque<ArrayLemma> mPropClauses = new ArrayDeque();
    private final LogProxy mLogger;
    private int mPushPopLevel = 0;
    private int mNeedDiffIndexLevel = -1;
    Map<CCTerm, ArrayNode> mCongRoots = null;
    Map<ArrayNode, Map<CCTerm, Object>> mArrayModels = null;
    private int mNumInstsSelect = 0;
    private int mNumInstsEq = 0;
    private int mNumBuildWeakEQ = 0;
    private int mNumAddStores = 0;
    private int mNumMerges = 0;
    private int mNumModuloEdges = 0;
    private long mTimeBuildWeakEq = 0L;
    private long mTimeBuildWeakEqi = 0L;
    private long mTimePropagation = 0L;
    private long mTimeExplanations = 0L;

    public ArrayTheory(Clausifier clausifier, CClosure cClosure) {
        this.mClausifier = clausifier;
        this.mCClosure = cClosure;
        this.mLogger = this.mCClosure.getLogger();
    }

    @Override
    public Clause startCheck() {
        this.cleanCaches();
        return null;
    }

    @Override
    public void endCheck() {
    }

    @Override
    public Clause setLiteral(Literal literal) {
        if (literal instanceof CCEquality) {
            this.cleanCaches();
        } else {
            for (ArrayLemma arrayLemma : this.mPropClauses) {
                if (!arrayLemma.mUndecidedLits.remove(literal.negate()) || !arrayLemma.mUndecidedLits.isEmpty()) continue;
                return this.explainPropagation(arrayLemma);
            }
        }
        return null;
    }

    @Override
    public void backtrackLiteral(Literal literal) {
        this.cleanCaches();
    }

    @Override
    public Clause checkpoint() {
        if (this.mCongRoots == null && this.buildWeakEq()) {
            for (ArrayLemma arrayLemma : this.mPropClauses) {
                if (!arrayLemma.mUndecidedLits.isEmpty()) continue;
                return this.explainPropagation(arrayLemma);
            }
        }
        return null;
    }

    @Override
    public Clause computeConflictClause() {
        boolean bl;
        Clause clause = this.checkpoint();
        if (clause != null) {
            return clause;
        }
        if (this.mPropClauses.isEmpty() && (bl = this.computeWeakeqExt())) {
            this.mArrayModels = null;
        }
        return null;
    }

    @Override
    public Literal getPropagatedLiteral() {
        long l = System.nanoTime();
        for (ArrayLemma arrayLemma : this.mPropClauses) {
            if (arrayLemma.mUndecidedLits.size() != 1) continue;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("AL prop: " + String.valueOf(arrayLemma));
            }
            Literal literal = arrayLemma.mUndecidedLits.iterator().next();
            this.mTimePropagation += System.nanoTime() - l;
            literal.getAtom().mExplanation = this.explainPropagation(arrayLemma);
            return literal;
        }
        return null;
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        assert (literal instanceof CCEquality);
        if (this.mCongRoots == null) {
            this.buildWeakEq();
        }
        for (ArrayLemma arrayLemma : this.mPropClauses) {
            Set<CCEquality> set = arrayLemma.mUndecidedLits;
            if (!set.isEmpty() && (set.size() != 1 || !set.contains(literal))) continue;
            return this.explainPropagation(arrayLemma);
        }
        throw new AssertionError((Object)"Cannot explain unit literal!");
    }

    @Override
    public int checkCompleteness() {
        return 0;
    }

    private Clause explainPropagation(ArrayLemma arrayLemma) {
        SymmetricPair<CCTerm> symmetricPair = arrayLemma.getEquality();
        long l = System.nanoTime();
        ++this.mNumInstsSelect;
        WeakCongruencePath weakCongruencePath = new WeakCongruencePath(this);
        Clause clause = switch (arrayLemma.getRule()) {
            case CCAnnotation.RuleKind.READ_OVER_WEAKEQ -> weakCongruencePath.computeSelectOverWeakEQ((CCAppTerm)symmetricPair.getFirst(), (CCAppTerm)symmetricPair.getSecond(), this.mCClosure.isProofGenerationEnabled());
            case CCAnnotation.RuleKind.CONST_WEAKEQ -> weakCongruencePath.computeConstOverWeakEQ(this.findConst(symmetricPair.getFirst()), this.findConst(symmetricPair.getSecond()), this.mCClosure.isProofGenerationEnabled());
            case CCAnnotation.RuleKind.READ_CONST_WEAKEQ -> weakCongruencePath.computeSelectConstOverWeakEQ((CCAppTerm)symmetricPair.getFirst(), this.findConst(symmetricPair.getSecond()), this.mCClosure.isProofGenerationEnabled());
            default -> throw new AssertionError((Object)"Unknown Lemma");
        };
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("AL sw: " + String.valueOf(clause));
        }
        this.mTimeExplanations += System.nanoTime() - l;
        return clause;
    }

    @Override
    public Literal getSuggestion() {
        return null;
    }

    @Override
    public void printStatistics(LogProxy logProxy) {
        if (logProxy.isInfoEnabled()) {
            logProxy.info("Array: #Arrays: %d, #BuildWeakEQ: %d, #ModEdges: %d, #addStores: %d, #merges: %d", this.mArrays.size(), this.mNumBuildWeakEQ, this.mNumModuloEdges, this.mNumAddStores, this.mNumMerges);
            logProxy.info("Insts: ReadOverWeakEQ: %d, WeakeqExt: %d", this.mNumInstsSelect, this.mNumInstsEq);
            logProxy.info("Time: BuildWeakEq: %d.%03d ms, BuildWeakEqi: %d.%03d ms", this.mTimeBuildWeakEq / 1000000L, this.mTimeBuildWeakEq / 1000L % 1000L, this.mTimeBuildWeakEqi / 1000000L, this.mTimeBuildWeakEqi / 1000L % 1000L);
            logProxy.info("Time: Propagation %d.%03d ms, Explanations: %d.%03d ms", this.mTimePropagation / 1000000L, this.mTimePropagation / 1000L % 1000L, this.mTimeExplanations / 1000000L, this.mTimeExplanations / 1000L % 1000L);
        }
    }

    @Override
    public void dumpModel(LogProxy logProxy) {
        if (!logProxy.isInfoEnabled()) {
            return;
        }
        for (Map.Entry<ArrayNode, Map<CCTerm, Object>> entry : this.mArrayModels.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(entry.getKey().mTerm).append(" = store[");
            stringBuilder.append(entry.getKey().getWeakRepresentative().mTerm);
            for (Map.Entry<CCTerm, Object> entry2 : entry.getValue().entrySet()) {
                if (entry2.getKey() == null) continue;
                stringBuilder.append(",(").append(entry2.getKey()).append(":=").append(entry2.getValue()).append(')');
            }
            stringBuilder.append(']');
            logProxy.info(stringBuilder.toString());
        }
    }

    @Override
    public void increasedDecideLevel(int n) {
    }

    @Override
    public void decreasedDecideLevel(int n) {
    }

    @Override
    public void backtrackAll() {
        this.mPropClauses.clear();
    }

    @Override
    public void backtrackStart() {
        this.mPropClauses.clear();
    }

    @Override
    public Clause backtrackComplete() {
        return null;
    }

    @Override
    public void restart(int n) {
    }

    @Override
    public void removeAtom(DPLLAtom dPLLAtom) {
    }

    @Override
    public void push() {
        this.mArrays.beginScope();
        this.mStores.beginScope();
        this.mConsts.beginScope();
        this.mDiffs.beginScope();
        ++this.mPushPopLevel;
    }

    @Override
    public void pop() {
        if (this.mNeedDiffIndexLevel == this.mPushPopLevel) {
            this.mNeedDiffIndexLevel = -1;
        }
        --this.mPushPopLevel;
        this.mArrays.endScope();
        this.mStores.endScope();
        this.mConsts.endScope();
        this.mDiffs.endScope();
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":Array", new Object[][]{{"NumArrays", this.mArrays.size()}, {"BuildWeakEQ", this.mNumBuildWeakEQ}, {"AddStores", this.mNumAddStores}, {"Merges", this.mNumMerges}, {"ModuloEdges", this.mNumModuloEdges}, {"ReadOverWeakeq", this.mNumInstsSelect}, {"WeakeqExt", this.mNumInstsEq}, {"Times", new Object[][]{{"BuildWeakEq", this.mTimeBuildWeakEq}, {"BuildWeakEqi", this.mTimeBuildWeakEqi}, {"Propagation", this.mTimePropagation}, {"Explanations", this.mTimeExplanations}}}}};
    }

    /*
     * WARNING - void declaration
     */
    public void fillInModel(ModelBuilder modelBuilder, List<CCTerm> list) {
        Sort sort = list.get(0).getFlatTerm().getSort();
        assert (sort.isArraySort());
        Sort sort2 = sort.getArguments()[1];
        Model model = modelBuilder.getModel();
        Theory theory = modelBuilder.getTheory();
        ArraySortInterpretation arraySortInterpretation = (ArraySortInterpretation)model.provideSortInterpretation(sort);
        ArrayList<ArrayNode> arrayList = new ArrayList<ArrayNode>(list.size());
        for (CCTerm object2 : list) {
            arrayList.add(this.mCongRoots.get(object2));
        }
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>(arrayList);
        while (!arrayDeque.isEmpty()) {
            void var13_20;
            Object object;
            CCTerm cCTerm;
            Term term;
            Term term2;
            ArrayNode arrayNode = (ArrayNode)arrayDeque.removeFirst();
            if (modelBuilder.getModelValue(arrayNode.mTerm) != null) continue;
            ArrayNode arrayNode2 = arrayNode.mPrimaryEdge;
            if (arrayNode2 == null) {
                if (arrayNode.mConstTerm != null) {
                    term2 = modelBuilder.getModelValue(ArrayTheory.getValueFromConst(arrayNode.mConstTerm).getRepresentative());
                    if (term2 == null) {
                        assert (ArrayTheory.getValueFromConst(arrayNode.mConstTerm).getFlatTerm().getSort().isArraySort());
                        arrayDeque.addLast(arrayNode);
                        continue;
                    }
                    FunctionSymbol functionSymbol = theory.getFunctionWithResult("const", null, sort, new Sort[]{sort2});
                    term = theory.term(functionSymbol, new Term[]{term2});
                    modelBuilder.setModelValue(arrayNode.mTerm, term);
                    continue;
                }
                term2 = this.hasFiniteIndexSort(sort) ? model.getSomeValue(sort) : model.extendFresh(sort);
                for (Map.Entry entry : arrayNode.mSelects.entrySet()) {
                    cCTerm = (CCTerm)entry.getKey();
                    object = ((CCAppTerm)entry.getValue()).getRepresentative();
                    term2 = theory.term("store", new Term[]{term2, modelBuilder.getModelValue(cCTerm), modelBuilder.getModelValue((CCTerm)object)});
                }
                for (ArrayNode arrayNode3 : arrayList) {
                    if (arrayNode3.getWeakRepresentative() != arrayNode || arrayNode3 == arrayNode || arrayNode3.mSelects.isEmpty() || arrayNode3.mSecondaryEdge != null) continue;
                    assert (arrayNode3.mSelects.size() == 1);
                    cCTerm = arrayNode3.mSelects.keySet().iterator().next();
                    if (arrayNode.mSelects.containsKey(cCTerm)) continue;
                    object = model.extendFresh(sort2);
                    term2 = theory.term("store", new Term[]{term2, modelBuilder.getModelValue(cCTerm), object});
                }
                term2 = arraySortInterpretation.normalizeStoreTerm(term2);
                modelBuilder.setModelValue(arrayNode.mTerm, term2);
                continue;
            }
            term2 = modelBuilder.getModelValue(arrayNode2.mTerm);
            if (term2 == null) {
                arrayDeque.addFirst(arrayNode);
                arrayDeque.addFirst(arrayNode2);
                continue;
            }
            if (arrayNode.mSecondaryEdge != null) {
                Term term3 = modelBuilder.getModelValue(arrayNode.mSecondaryEdge.mTerm);
                if (term3 == null) {
                    arrayDeque.addFirst(arrayNode);
                    arrayDeque.addFirst(arrayNode.mSecondaryEdge);
                    continue;
                }
            } else {
                Object var13_19 = null;
            }
            term = ArrayTheory.getIndexFromStore(arrayNode.mPrimaryStore).getRepresentative();
            cCTerm = arrayNode.mSelects.get(term);
            object = modelBuilder.getModelValue((CCTerm)term);
            Term term4 = var13_20 != null ? arraySortInterpretation.getSelect((Term)var13_20, (Term)object) : (cCTerm == null ? model.extendFresh(sort2) : modelBuilder.getModelValue(cCTerm));
            Term term5 = theory.term("store", new Term[]{term2, object, term4});
            term5 = arraySortInterpretation.normalizeStoreTerm(term5);
            modelBuilder.setModelValue(arrayNode.mTerm, term5);
        }
    }

    public void notifyArray(CCTerm cCTerm, boolean bl, boolean bl2) {
        if (bl) {
            this.mStores.add((CCAppTerm)cCTerm);
            ++this.mNumAddStores;
        }
        if (bl2) {
            this.mConsts.add((CCAppTerm)cCTerm);
        }
        this.mArrays.add(cCTerm);
        this.cleanCaches();
    }

    public void notifyDiff(CCAppTerm cCAppTerm) {
        this.mDiffs.add(cCAppTerm);
    }

    public static boolean isStoreTerm(CCTerm cCTerm) {
        CCBaseTerm cCBaseTerm = ArrayTheory.getBaseTerm(cCTerm);
        if (cCBaseTerm.isFunctionSymbol()) {
            return cCBaseTerm.getFunctionSymbol().getName().equals("store");
        }
        return false;
    }

    public static boolean isSelectTerm(CCTerm cCTerm) {
        CCBaseTerm cCBaseTerm = ArrayTheory.getBaseTerm(cCTerm);
        if (cCBaseTerm.isFunctionSymbol()) {
            return cCBaseTerm.getFunctionSymbol().getName().equals("select");
        }
        return false;
    }

    public static boolean isConstTerm(CCTerm cCTerm) {
        CCBaseTerm cCBaseTerm = ArrayTheory.getBaseTerm(cCTerm);
        if (cCBaseTerm.isFunctionSymbol()) {
            return cCBaseTerm.getFunctionSymbol().getName().equals("const");
        }
        return false;
    }

    public static boolean isDiffTerm(CCTerm cCTerm) {
        CCBaseTerm cCBaseTerm = ArrayTheory.getBaseTerm(cCTerm);
        if (cCBaseTerm.isFunctionSymbol()) {
            return cCBaseTerm.getFunctionSymbol().getName().equals("@diff");
        }
        return false;
    }

    public static CCTerm getArrayFromSelect(CCAppTerm cCAppTerm) {
        assert (ArrayTheory.isSelectTerm(cCAppTerm));
        return ArrayTheory.getSecondToLastArgument(cCAppTerm);
    }

    public static CCTerm getIndexFromSelect(CCAppTerm cCAppTerm) {
        assert (ArrayTheory.isSelectTerm(cCAppTerm));
        return cCAppTerm.getArg();
    }

    public static CCTerm getArrayFromStore(CCAppTerm cCAppTerm) {
        assert (ArrayTheory.isStoreTerm(cCAppTerm));
        return ArrayTheory.getThirdToLastArgument(cCAppTerm);
    }

    public static CCTerm getIndexFromStore(CCAppTerm cCAppTerm) {
        assert (ArrayTheory.isStoreTerm(cCAppTerm));
        return ArrayTheory.getSecondToLastArgument(cCAppTerm);
    }

    public static CCTerm getValueFromStore(CCAppTerm cCAppTerm) {
        assert (ArrayTheory.isStoreTerm(cCAppTerm));
        return cCAppTerm.getArg();
    }

    public static CCTerm getValueFromConst(CCAppTerm cCAppTerm) {
        assert (ArrayTheory.isConstTerm(cCAppTerm));
        return cCAppTerm.getArg();
    }

    public static CCTerm getLeftFromDiff(CCAppTerm cCAppTerm) {
        assert (ArrayTheory.isDiffTerm(cCAppTerm));
        return ArrayTheory.getSecondToLastArgument(cCAppTerm);
    }

    public static CCTerm getRightFromDiff(CCAppTerm cCAppTerm) {
        assert (ArrayTheory.isDiffTerm(cCAppTerm));
        return cCAppTerm.getArg();
    }

    public static Sort getArraySortFromSelect(CCAppTerm cCAppTerm) {
        assert (ArrayTheory.isSelectTerm(cCAppTerm));
        return ArrayTheory.getBaseTerm(cCAppTerm).getFunctionSymbol().getParameterSorts()[0];
    }

    public static Sort getArraySortFromStore(CCAppTerm cCAppTerm) {
        assert (ArrayTheory.isStoreTerm(cCAppTerm));
        return ArrayTheory.getBaseTerm(cCAppTerm).getFunctionSymbol().getParameterSorts()[0];
    }

    private static CCBaseTerm getBaseTerm(CCTerm cCTerm) {
        if (cCTerm instanceof CCBaseTerm) {
            return (CCBaseTerm)cCTerm;
        }
        CCTerm cCTerm2 = cCTerm;
        while (cCTerm2 instanceof CCAppTerm) {
            cCTerm2 = ((CCAppTerm)cCTerm2).getFunc();
        }
        assert (cCTerm2 instanceof CCBaseTerm);
        return (CCBaseTerm)cCTerm2;
    }

    private static CCTerm getSecondToLastArgument(CCTerm cCTerm) {
        assert (cCTerm instanceof CCAppTerm);
        CCTerm cCTerm2 = ((CCAppTerm)cCTerm).getFunc();
        assert (cCTerm2 instanceof CCAppTerm);
        return ((CCAppTerm)cCTerm2).getArg();
    }

    private static CCTerm getThirdToLastArgument(CCTerm cCTerm) {
        assert (cCTerm instanceof CCAppTerm);
        return ArrayTheory.getSecondToLastArgument(((CCAppTerm)cCTerm).getFunc());
    }

    CCAppTerm findConst(CCTerm cCTerm) {
        for (CCAppTerm cCAppTerm : this.mConsts) {
            if (cCTerm != ArrayTheory.getValueFromConst(cCAppTerm)) continue;
            return cCAppTerm;
        }
        throw new AssertionError((Object)("Constant term not found for " + String.valueOf(cCTerm)));
    }

    private void setConst(CCAppTerm cCAppTerm) {
        CCTerm cCTerm = ArrayTheory.getValueFromConst(cCAppTerm);
        CCTerm cCTerm2 = cCAppTerm.getRepresentative();
        ArrayNode arrayNode = this.mCongRoots.get(cCTerm2);
        if (arrayNode.mConstTerm != null) {
            CCTerm cCTerm3 = ArrayTheory.getValueFromConst(arrayNode.mConstTerm);
            if (cCTerm.getRepresentative() != cCTerm3.getRepresentative()) {
                this.mPropClauses.add(new ArrayLemma(CCAnnotation.RuleKind.CONST_WEAKEQ, cCTerm, cCTerm3));
            }
        } else {
            arrayNode.mConstTerm = cCAppTerm;
            for (CCAppTerm cCAppTerm2 : arrayNode.mSelects.values()) {
                if (cCAppTerm2.getRepresentative() == cCTerm.getRepresentative()) continue;
                this.mPropClauses.add(new ArrayLemma(CCAnnotation.RuleKind.READ_CONST_WEAKEQ, cCAppTerm2, cCTerm));
            }
        }
    }

    private void merge(CCAppTerm cCAppTerm) {
        ArrayNode arrayNode;
        CCTerm cCTerm = ArrayTheory.getArrayFromStore(cCAppTerm);
        ArrayNode arrayNode2 = this.mCongRoots.get(cCTerm.getRepresentative());
        if (arrayNode2 == (arrayNode = this.mCongRoots.get(cCAppTerm.getRepresentative()))) {
            return;
        }
        ++this.mNumMerges;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("Merge: [" + String.valueOf(ArrayTheory.getIndexFromStore(cCAppTerm).getRepresentative()) + "] " + String.valueOf(arrayNode2) + " and " + String.valueOf(arrayNode));
        }
        arrayNode2.makeWeakRepresentative();
        arrayNode.makeWeakRepresentative();
        if (arrayNode2.mPrimaryEdge == null) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("  PrimaryEdge");
            }
            arrayNode2.mergeWith(arrayNode, cCAppTerm, this.mPropClauses);
        } else {
            HashSet<CCTerm> hashSet = new HashSet<CCTerm>();
            CCTerm cCTerm2 = ArrayTheory.getIndexFromStore(cCAppTerm).getRepresentative();
            hashSet.add(cCTerm2);
            ArrayNode arrayNode3 = arrayNode2;
            while (arrayNode3.mPrimaryEdge != null) {
                CCTerm cCTerm3 = ArrayTheory.getIndexFromStore(arrayNode3.mPrimaryStore).getRepresentative();
                if (hashSet.add(cCTerm3) && arrayNode3.getWeakIRepresentative(cCTerm3) != arrayNode) {
                    ++this.mNumModuloEdges;
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug("  SecondaryEdge: [" + String.valueOf(cCTerm3) + "] " + String.valueOf(arrayNode3) + " to " + String.valueOf(arrayNode));
                    }
                    arrayNode3.mergeSecondary(arrayNode, cCAppTerm, this.mPropClauses);
                }
                arrayNode3 = arrayNode3.mPrimaryEdge;
            }
        }
    }

    private void computeStoreIndices(CCTerm cCTerm, CCTerm cCTerm2, CCTerm cCTerm3, Set<CCTerm> set) {
        ArrayNode arrayNode = this.mCongRoots.get(cCTerm2.getRepresentative());
        ArrayNode arrayNode2 = this.mCongRoots.get(cCTerm3.getRepresentative());
        Cursor cursor = new Cursor(cCTerm2, arrayNode);
        Cursor cursor2 = new Cursor(cCTerm3, arrayNode2);
        assert (cCTerm == cCTerm.getRepresentative());
        cursor.collect(cCTerm, cursor2, set);
    }

    private void createPropagatedClauses() {
        for (ArrayLemma arrayLemma : this.mPropClauses) {
            CCTerm cCTerm = arrayLemma.getEquality().getFirst();
            CCTerm cCTerm2 = arrayLemma.getEquality().getSecond();
            assert (cCTerm.getRepresentative() != cCTerm2.getRepresentative());
            switch (arrayLemma.getRule()) {
                case READ_OVER_WEAKEQ: {
                    Object object2 = (CCAppTerm)cCTerm;
                    Object object3 = (CCAppTerm)cCTerm2;
                    CCTerm cCTerm3 = ArrayTheory.getIndexFromSelect((CCAppTerm)object2);
                    CCTerm cCTerm4 = ArrayTheory.getArrayFromSelect((CCAppTerm)object2);
                    Object object4 = ArrayTheory.getArrayFromSelect((CCAppTerm)object3);
                    LinkedHashSet<CCTerm> linkedHashSet = new LinkedHashSet<CCTerm>();
                    this.computeStoreIndices(cCTerm3.getRepresentative(), cCTerm4, (CCTerm)object4, linkedHashSet);
                    Object object5 = new LinkedHashSet();
                    for (CCTerm cCTerm5 : linkedHashSet) {
                        assert (cCTerm3.getRepresentative() != cCTerm5.getRepresentative());
                        CCEquality cCEquality = this.getCClosure().createEquality(cCTerm3, cCTerm5, false);
                        if (cCEquality == null) continue;
                        assert (cCEquality.getDecideStatus() != cCEquality);
                        if (cCEquality.getDecideStatus() != null) continue;
                        object5.add(cCEquality);
                    }
                    CCEquality cCEquality = this.getCClosure().createEquality((CCTerm)object2, (CCTerm)object3, false);
                    if (cCEquality != null) {
                        assert (cCEquality.getDecideStatus() != cCEquality);
                        if (cCEquality.getDecideStatus() == null) {
                            object5.add(cCEquality);
                        }
                    }
                    arrayLemma.mUndecidedLits = object5;
                    break;
                }
                case CONST_WEAKEQ: {
                    Object object2 = this.getCClosure().createEquality(cCTerm, cCTerm2, false);
                    assert (object2 == null || ((DPLLAtom)object2).getDecideStatus() != object2);
                    Object object3 = new LinkedHashSet();
                    if (object2 != null && ((DPLLAtom)object2).getDecideStatus() == null) {
                        object3.add(object2);
                    }
                    arrayLemma.mUndecidedLits = object3;
                    break;
                }
                case READ_CONST_WEAKEQ: {
                    Object object5;
                    Object object2 = (CCAppTerm)cCTerm;
                    Object object3 = ArrayTheory.getIndexFromSelect((CCAppTerm)object2);
                    CCTerm cCTerm3 = ArrayTheory.getArrayFromSelect((CCAppTerm)object2);
                    CCTerm cCTerm4 = this.findConst(cCTerm2);
                    Object object4 = new LinkedHashSet();
                    this.computeStoreIndices(((CCTerm)object3).getRepresentative(), cCTerm3, cCTerm4, (Set<CCTerm>)object4);
                    LinkedHashSet<CCTerm> linkedHashSet = new LinkedHashSet();
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        object5 = (CCTerm)iterator.next();
                        assert (((CCTerm)object3).getRepresentative() != ((CCTerm)object5).getRepresentative());
                        CCEquality cCEquality = this.getCClosure().createEquality((CCTerm)object3, (CCTerm)object5, false);
                        if (cCEquality == null) continue;
                        assert (cCEquality.getDecideStatus() != cCEquality);
                        if (cCEquality.getDecideStatus() != null) continue;
                        linkedHashSet.add((CCTerm)((Object)cCEquality));
                    }
                    object5 = this.getCClosure().createEquality(cCTerm, cCTerm2, false);
                    if (object5 != null) {
                        assert (((DPLLAtom)object5).getDecideStatus() != object5);
                        if (((DPLLAtom)object5).getDecideStatus() == null) {
                            linkedHashSet.add((CCTerm)object5);
                        }
                    }
                    arrayLemma.mUndecidedLits = linkedHashSet;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown Array Rule: " + String.valueOf((Object)arrayLemma.getRule())));
                }
            }
        }
    }

    private boolean buildWeakEq() {
        ++this.mNumBuildWeakEQ;
        long l = System.nanoTime();
        this.mCongRoots = new LinkedHashMap<CCTerm, ArrayNode>();
        for (CCTerm cCTerm : this.mArrays) {
            CCTerm cCTerm2 = cCTerm.getRepresentative();
            if (this.mCongRoots.containsKey(cCTerm2)) continue;
            ArrayNode arrayNode = new ArrayNode(cCTerm2);
            arrayNode.computeSelects();
            this.mCongRoots.put(cCTerm2, arrayNode);
        }
        for (CCAppTerm cCAppTerm : this.mConsts) {
            this.setConst(cCAppTerm);
        }
        for (CCAppTerm cCAppTerm : this.mStores) {
            this.merge(cCAppTerm);
        }
        this.createPropagatedClauses();
        this.mTimeBuildWeakEq += System.nanoTime() - l;
        return !this.mPropClauses.isEmpty();
    }

    private void makeConstReps() {
        for (CCTerm cCTerm : this.mConsts) {
            ArrayNode arrayNode = this.mCongRoots.get(cCTerm.getRepresentative());
            arrayNode.makeWeakRepresentative();
        }
    }

    private boolean computeWeakeqExt() {
        Object object;
        Object object2;
        long l = System.nanoTime();
        this.makeConstReps();
        this.mArrayModels = new LinkedHashMap<ArrayNode, Map<CCTerm, Object>>();
        HashMap<Object, ArrayNode> hashMap = new HashMap<Object, ArrayNode>();
        LinkedHashSet<SymmetricPair<ArrayNode>> linkedHashSet = new LinkedHashSet<SymmetricPair<ArrayNode>>();
        ArrayDeque<ArrayNode> arrayDeque = new ArrayDeque<ArrayNode>(this.mCongRoots.values());
        while (!arrayDeque.isEmpty()) {
            ArrayNode object4 = arrayDeque.getFirst();
            if (this.mArrayModels.containsKey(object4)) {
                arrayDeque.removeFirst();
                continue;
            }
            if (object4.mPrimaryEdge != null && !this.mArrayModels.containsKey(object4.mPrimaryEdge)) {
                arrayDeque.addFirst(object4.mPrimaryEdge);
                continue;
            }
            arrayDeque.removeFirst();
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            object2 = null;
            object = object4.getWeakRepresentative();
            if (((ArrayNode)object).mConstTerm != null) {
                object2 = ArrayTheory.getValueFromConst(((ArrayNode)object).mConstTerm).getRepresentative();
            }
            if (object4 == object) {
                if (this.mNeedDiffIndexLevel >= 0 || this.hasFiniteIndexSort(object4.mTerm.getFlatTerm().getSort())) {
                    linkedHashMap.put(null, object4.mTerm.getFlatTerm().getSort());
                } else {
                    linkedHashMap.put(null, object4);
                }
                for (Map.Entry entry : object4.mSelects.entrySet()) {
                    var12_19 = ((CCAppTerm)entry.getValue()).getRepresentative();
                    assert (object2 == null || var12_19 == object2);
                    if (var12_19 == object2) continue;
                    linkedHashMap.put((CCTerm)entry.getKey(), var12_19);
                }
            } else {
                CCTerm cCTerm = ArrayTheory.getIndexFromStore(object4.mPrimaryStore).getRepresentative();
                linkedHashMap.putAll(this.mArrayModels.get(object4.mPrimaryEdge));
                linkedHashMap.remove(cCTerm);
                ArrayNode arrayNode = object4.getWeakIRepresentative(cCTerm);
                var12_19 = arrayNode.mSelects.get(cCTerm);
                if (var12_19 != null) {
                    if (var12_19.getRepresentative() != object2) {
                        linkedHashMap.put(cCTerm, var12_19.getRepresentative());
                    }
                } else if (arrayNode != object) {
                    linkedHashMap.put(cCTerm, arrayNode);
                }
            }
            this.mArrayModels.put(object4, linkedHashMap);
            ArrayNode arrayNode = hashMap.put(linkedHashMap, object4);
            if (arrayNode == null) continue;
            linkedHashSet.add(new SymmetricPair<ArrayNode>(arrayNode, object4));
        }
        for (SymmetricPair symmetricPair : linkedHashSet) {
            if (((ArrayNode)symmetricPair.getFirst()).getWeakRepresentative() != ((ArrayNode)symmetricPair.getSecond()).getWeakRepresentative()) continue;
            ++this.mNumInstsEq;
            object2 = new WeakCongruencePath(this);
            object = ((WeakCongruencePath)object2).computeWeakeqExt(((ArrayNode)symmetricPair.getFirst()).mTerm, ((ArrayNode)symmetricPair.getSecond()).mTerm, this.mCClosure.isProofGenerationEnabled());
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("AL sw: " + String.valueOf(object));
            }
            this.mCClosure.getEngine().learnClause((Clause)object);
        }
        for (SymmetricPair symmetricPair : linkedHashSet) {
            if (((ArrayNode)symmetricPair.getFirst()).getWeakRepresentative() == ((ArrayNode)symmetricPair.getSecond()).getWeakRepresentative()) continue;
            assert (this.mNeedDiffIndexLevel >= 0 || this.hasFiniteIndexSort(((ArrayNode)symmetricPair.getFirst()).mTerm.getFlatTerm().getSort()));
            object2 = this.mClausifier.getTheory().term("@diff", new Term[]{((ArrayNode)symmetricPair.getFirst()).mTerm.getFlatTerm(), ((ArrayNode)symmetricPair.getSecond()).mTerm.getFlatTerm()});
            this.mClausifier.addTermAxioms((Term)object2, new SourceAnnotation("", null));
        }
        this.mTimeBuildWeakEqi += System.nanoTime() - l;
        return !linkedHashSet.isEmpty();
    }

    private boolean hasFiniteIndexSort(Sort sort) {
        assert (sort.isArraySort());
        assert (sort.getArguments().length == 2);
        Sort sort2 = sort.getArguments()[0];
        return !this.mClausifier.isStablyInfinite(sort2);
    }

    CClosure getCClosure() {
        return this.mCClosure;
    }

    Clausifier getClausifier() {
        return this.mClausifier;
    }

    public void cleanCaches() {
        this.mCongRoots = null;
        this.mPropClauses.clear();
    }

    public CCTerm getWeakRep(CCTerm cCTerm) {
        assert (cCTerm != null && cCTerm.getFlatTerm().getSort().isArraySort());
        if (this.mCongRoots == null) {
            this.buildWeakEq();
        }
        ArrayNode arrayNode = this.mCongRoots.get(cCTerm.getRepresentative()).getWeakRepresentative();
        assert (arrayNode != null);
        return arrayNode.mTerm;
    }

    public void setNeedDiffIndices() {
        if (this.mNeedDiffIndexLevel < 0) {
            this.mNeedDiffIndexLevel = this.mPushPopLevel;
        }
    }

    private static class ArrayLemma {
        CCAnnotation.RuleKind mRule;
        SymmetricPair<CCTerm> mPropagatedEq;
        Set<CCEquality> mUndecidedLits;

        public ArrayLemma(CCAnnotation.RuleKind ruleKind, CCTerm cCTerm, CCTerm cCTerm2) {
            this.mRule = ruleKind;
            this.mPropagatedEq = new SymmetricPair<CCTerm>(cCTerm, cCTerm2);
        }

        public CCAnnotation.RuleKind getRule() {
            return this.mRule;
        }

        public SymmetricPair<CCTerm> getEquality() {
            return this.mPropagatedEq;
        }

        public int hashCode() {
            return HashUtils.hashJenkins((int)this.mRule.hashCode(), this.mPropagatedEq);
        }

        public boolean equals(Object object) {
            if (object instanceof ArrayLemma) {
                ArrayLemma arrayLemma = (ArrayLemma)object;
                return this.mRule == arrayLemma.mRule && this.mPropagatedEq.equals(arrayLemma.mPropagatedEq);
            }
            return false;
        }

        public String toString() {
            return "ArrayLemma[" + String.valueOf(this.mPropagatedEq) + " ; " + String.valueOf(this.mUndecidedLits) + "]";
        }
    }

    class ArrayNode {
        CCTerm mTerm;
        ArrayNode mPrimaryEdge;
        CCAppTerm mPrimaryStore;
        ArrayNode mSecondaryEdge;
        CCAppTerm mSecondaryStore;
        Map<CCTerm, CCAppTerm> mSelects;
        CCAppTerm mConstTerm;

        public ArrayNode(CCTerm cCTerm) {
            assert (cCTerm.isRepresentative());
            this.mTerm = cCTerm;
            this.mSecondaryEdge = null;
            this.mPrimaryEdge = null;
            this.mPrimaryStore = null;
        }

        public void computeSelects() {
            this.mSelects = new LinkedHashMap<CCTerm, CCAppTerm>();
            CCParentInfo cCParentInfo = this.mTerm.mCCPars;
            while (cCParentInfo != null) {
                CCTerm cCTerm;
                if (cCParentInfo.mCCParents != null && !cCParentInfo.mCCParents.isEmpty() && (cCTerm = cCParentInfo.mCCParents.iterator().next().getData().getFunc()) instanceof CCBaseTerm && ((CCBaseTerm)cCTerm).getFunctionSymbol().getName() == "select") {
                    for (CCAppTerm.Parent parent : cCParentInfo.mCCParents) {
                        CCParentInfo cCParentInfo2 = parent.getData().getRepresentative().mCCPars.getExistingParentInfo(0);
                        for (CCAppTerm.Parent parent2 : cCParentInfo2.mCCParents) {
                            CCAppTerm cCAppTerm = parent2.getData();
                            assert (ArrayTheory.getArrayFromSelect(cCAppTerm).getRepresentative() == this.mTerm);
                            assert (cCAppTerm != null);
                            this.mSelects.put(cCAppTerm.mArg.getRepresentative(), cCAppTerm);
                        }
                    }
                }
                cCParentInfo = cCParentInfo.mNext;
            }
        }

        public ArrayNode getWeakRepresentative() {
            ArrayNode arrayNode = this;
            while (arrayNode.mPrimaryEdge != null) {
                arrayNode = arrayNode.mPrimaryEdge;
            }
            return arrayNode;
        }

        public ArrayNode getWeakIRepresentative(CCTerm cCTerm) {
            cCTerm = cCTerm.getRepresentative();
            ArrayNode arrayNode = this;
            while (arrayNode.mPrimaryEdge != null) {
                if (ArrayTheory.getIndexFromStore(arrayNode.mPrimaryStore).getRepresentative() == cCTerm) {
                    if (arrayNode.mSecondaryEdge == null) break;
                    arrayNode = arrayNode.mSecondaryEdge;
                    continue;
                }
                arrayNode = arrayNode.mPrimaryEdge;
            }
            return arrayNode;
        }

        public void makeWeakIRepresentative() {
            assert (this.mPrimaryEdge != null);
            assert (this.mSecondaryEdge != null);
            CCTerm cCTerm = ArrayTheory.getIndexFromStore(this.mPrimaryStore).getRepresentative();
            assert (this.getWeakIRepresentative(cCTerm) != this.getWeakRepresentative());
            ArrayNode arrayNode = this;
            ArrayNode arrayNode2 = arrayNode.mSecondaryEdge;
            CCAppTerm cCAppTerm = arrayNode.mSecondaryStore;
            while (arrayNode2 != null) {
                arrayNode2 = arrayNode2.findSecondaryNode(cCTerm);
                ArrayNode arrayNode3 = arrayNode2.mSecondaryEdge;
                CCAppTerm cCAppTerm2 = arrayNode2.mSecondaryStore;
                arrayNode2.mSecondaryEdge = arrayNode;
                arrayNode2.mSecondaryStore = cCAppTerm;
                arrayNode = arrayNode2;
                cCAppTerm = cCAppTerm2;
                arrayNode2 = arrayNode3;
            }
            this.mSecondaryEdge = null;
            this.mSecondaryStore = null;
            this.mSelects = arrayNode.mSelects;
            arrayNode.mSelects = Collections.emptyMap();
        }

        public void makeWeakRepresentative() {
            Object object;
            Object object2;
            Object object3;
            if (this.mPrimaryEdge == null) {
                return;
            }
            LinkedHashMap<CCTerm, Object> linkedHashMap = new LinkedHashMap<CCTerm, Object>();
            LinkedHashMap linkedHashMap2 = new LinkedHashMap();
            LinkedHashMap linkedHashMap3 = new LinkedHashMap();
            LinkedHashMap<CCTerm, CCAppTerm> linkedHashMap4 = new LinkedHashMap<CCTerm, CCAppTerm>();
            Object object4 = this;
            ArrayNode arrayNode = null;
            CCAppTerm cCAppTerm = null;
            while (((ArrayNode)object4).mPrimaryEdge != null) {
                object3 = ((ArrayNode)object4).mPrimaryEdge;
                CCAppTerm entry = ((ArrayNode)object4).mPrimaryStore;
                ((ArrayNode)object4).mPrimaryEdge = arrayNode;
                ((ArrayNode)object4).mPrimaryStore = cCAppTerm;
                CCTerm cCTerm = ArrayTheory.getIndexFromStore(entry).getRepresentative();
                object2 = (ArrayNode)linkedHashMap.put(cCTerm, object3);
                if (object2 != object4) {
                    if (((ArrayNode)object4).mSecondaryEdge != null) {
                        if (object2 == null) {
                            linkedHashMap2.put(cCTerm, ((ArrayNode)object4).mSecondaryEdge);
                            linkedHashMap3.put(cCTerm, ((ArrayNode)object4).mSecondaryStore);
                        } else {
                            assert (ArrayTheory.getIndexFromStore(((ArrayNode)object2).mPrimaryStore).getRepresentative() == cCTerm);
                            assert (((ArrayNode)object2).mSecondaryEdge == null);
                            ((ArrayNode)object2).mSecondaryEdge = ((ArrayNode)object4).mSecondaryEdge;
                            ((ArrayNode)object2).mSecondaryStore = ((ArrayNode)object4).mSecondaryStore;
                        }
                        ((ArrayNode)object4).mSecondaryEdge = null;
                        ((ArrayNode)object4).mSecondaryStore = null;
                    } else if (!((ArrayNode)object4).mSelects.isEmpty()) {
                        if (object2 == null) {
                            assert (((ArrayNode)object4).mSelects.get(cCTerm) != null);
                            linkedHashMap4.put(cCTerm, ((ArrayNode)object4).mSelects.get(cCTerm));
                        } else {
                            ((ArrayNode)object2).mSelects = ((ArrayNode)object4).mSelects;
                        }
                        ((ArrayNode)object4).mSelects = Collections.emptyMap();
                    }
                }
                arrayNode = object4;
                object4 = object3;
                cCAppTerm = entry;
            }
            ((ArrayNode)object4).mPrimaryEdge = arrayNode;
            ((ArrayNode)object4).mPrimaryStore = cCAppTerm;
            this.mConstTerm = ((ArrayNode)object4).mConstTerm;
            ((ArrayNode)object4).mConstTerm = null;
            object3 = ((ArrayNode)object4).mSelects;
            ((ArrayNode)object4).mSelects = Collections.emptyMap();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                object2 = (CCTerm)entry.getKey();
                object = (CCAppTerm)object3.remove(object2);
                if (object == null) continue;
                ((ArrayNode)entry.getValue()).mSelects = Collections.singletonMap(object2, object);
            }
            for (Map.Entry entry : linkedHashMap2.entrySet()) {
                object2 = (CCTerm)entry.getKey();
                object = (ArrayNode)entry.getValue();
                object = ((ArrayNode)object).findSecondaryNode((CCTerm)object2);
                if (((ArrayNode)object).mSecondaryEdge != null) {
                    ((ArrayNode)object).makeWeakIRepresentative();
                }
                ((ArrayNode)object).mSecondaryEdge = this;
                ((ArrayNode)object).mSecondaryStore = (CCAppTerm)linkedHashMap3.get(object2);
                linkedHashMap4.putAll(((ArrayNode)object).mSelects);
                ((ArrayNode)object).mSelects = Collections.emptyMap();
            }
            linkedHashMap4.putAll((Map<CCTerm, CCAppTerm>)object3);
            this.mSelects = linkedHashMap4;
        }

        public void mergeWith(ArrayNode arrayNode, CCAppTerm cCAppTerm, Collection<ArrayLemma> collection) {
            CCTerm cCTerm;
            Map<CCTerm, CCAppTerm> map;
            assert (this.mPrimaryEdge == null && arrayNode.mPrimaryEdge == null);
            this.mPrimaryEdge = arrayNode;
            this.mPrimaryStore = cCAppTerm;
            LinkedHashMap<CCTerm, CCAppTerm> linkedHashMap = new LinkedHashMap<CCTerm, CCAppTerm>();
            if (this.mConstTerm != null) {
                if (arrayNode.mConstTerm == null) {
                    arrayNode.mConstTerm = this.mConstTerm;
                    this.mConstTerm = null;
                    linkedHashMap.putAll(arrayNode.mSelects);
                } else {
                    map = ArrayTheory.getValueFromConst(this.mConstTerm);
                    CCTerm object2 = ArrayTheory.getValueFromConst(arrayNode.mConstTerm);
                    if (((CCTerm)((Object)map)).getRepresentative() != object2.getRepresentative()) {
                        collection.add(new ArrayLemma(CCAnnotation.RuleKind.CONST_WEAKEQ, (CCTerm)((Object)map), object2));
                    }
                }
            } else if (arrayNode.mConstTerm != null) {
                linkedHashMap.putAll(this.mSelects);
            }
            linkedHashMap.remove(ArrayTheory.getIndexFromStore(cCAppTerm).getRepresentative());
            map = Collections.emptyMap();
            for (Map.Entry<CCTerm, CCAppTerm> entry : this.mSelects.entrySet()) {
                CCTerm cCTerm2 = entry.getKey();
                CCAppTerm cCAppTerm2 = entry.getValue();
                assert (cCAppTerm2 != null);
                if (cCTerm2 == ArrayTheory.getIndexFromStore(cCAppTerm).getRepresentative()) {
                    map = Collections.singletonMap(cCTerm2, cCAppTerm2);
                    continue;
                }
                cCTerm = arrayNode.mSelects.get(cCTerm2);
                if (cCTerm == null) {
                    arrayNode.mSelects.put(cCTerm2, cCAppTerm2);
                    continue;
                }
                linkedHashMap.remove(cCTerm2);
                if (cCAppTerm2.getRepresentative() == cCTerm.getRepresentative()) continue;
                collection.add(new ArrayLemma(CCAnnotation.RuleKind.READ_OVER_WEAKEQ, cCAppTerm2, cCTerm));
            }
            this.mSelects = map;
            if (arrayNode.mConstTerm != null) {
                CCTerm cCTerm3 = ArrayTheory.getValueFromConst(arrayNode.mConstTerm);
                ArrayNode arrayNode2 = ArrayTheory.this.mCongRoots.get(arrayNode.mConstTerm.getRepresentative());
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    cCTerm = (CCTerm)entry.getKey();
                    CCAppTerm cCAppTerm3 = (CCAppTerm)entry.getValue();
                    if (arrayNode2.getWeakIRepresentative(cCTerm) != arrayNode) continue;
                    arrayNode.mSelects.remove(cCTerm);
                    if (cCAppTerm3.getRepresentative() == cCTerm3.getRepresentative()) continue;
                    collection.add(new ArrayLemma(CCAnnotation.RuleKind.READ_CONST_WEAKEQ, cCAppTerm3, cCTerm3));
                }
            }
        }

        public void mergeSecondary(ArrayNode arrayNode, CCAppTerm cCAppTerm, Collection<ArrayLemma> collection) {
            CCAppTerm cCAppTerm2;
            Object object;
            assert (arrayNode.mPrimaryEdge == null);
            assert (this.mPrimaryEdge != null);
            assert (ArrayTheory.getIndexFromStore(this.mPrimaryStore).getRepresentative() != ArrayTheory.getIndexFromStore(cCAppTerm).getRepresentative());
            if (this.mSecondaryEdge != null) {
                this.makeWeakIRepresentative();
            }
            this.mSecondaryEdge = arrayNode;
            this.mSecondaryStore = cCAppTerm;
            CCTerm cCTerm = ArrayTheory.getIndexFromStore(this.mPrimaryStore).getRepresentative();
            if (!this.mSelects.isEmpty()) {
                object = this.mSelects.get(cCTerm);
                assert (object != null);
                cCAppTerm2 = arrayNode.mSelects.get(cCTerm);
                if (cCAppTerm2 == null) {
                    arrayNode.mSelects.put(cCTerm, (CCAppTerm)object);
                } else if (((CCTerm)object).getRepresentative() != cCAppTerm2.getRepresentative()) {
                    collection.add(new ArrayLemma(CCAnnotation.RuleKind.READ_OVER_WEAKEQ, (CCTerm)object, cCAppTerm2));
                }
                this.mSelects = Collections.emptyMap();
            }
            if (arrayNode.mConstTerm != null && ((ArrayNode)(object = ArrayTheory.this.mCongRoots.get(arrayNode.mConstTerm.getRepresentative()))).getWeakIRepresentative(cCTerm) == arrayNode) {
                cCAppTerm2 = arrayNode.mSelects.remove(cCTerm);
                CCTerm cCTerm2 = ArrayTheory.getValueFromConst(arrayNode.mConstTerm);
                if (cCAppTerm2 != null && cCAppTerm2.getRepresentative() != cCTerm2.getRepresentative()) {
                    collection.add(new ArrayLemma(CCAnnotation.RuleKind.READ_CONST_WEAKEQ, cCAppTerm2, cCTerm2));
                }
            }
        }

        public int countSecondaryEdges(CCTerm cCTerm) {
            assert (cCTerm.isRepresentative());
            int n = 0;
            ArrayNode arrayNode = this;
            while (arrayNode.mPrimaryEdge != null) {
                if (ArrayTheory.getIndexFromStore(arrayNode.mPrimaryStore).getRepresentative() == cCTerm) {
                    if (arrayNode.mSecondaryEdge == null) break;
                    arrayNode = arrayNode.mSecondaryEdge;
                    ++n;
                    continue;
                }
                arrayNode = arrayNode.mPrimaryEdge;
            }
            return n;
        }

        public ArrayNode findSecondaryNode(CCTerm cCTerm) {
            assert (cCTerm.isRepresentative());
            ArrayNode arrayNode = this;
            while (arrayNode.mPrimaryEdge != null && ArrayTheory.getIndexFromStore(arrayNode.mPrimaryStore).getRepresentative() != cCTerm) {
                arrayNode = arrayNode.mPrimaryEdge;
            }
            return arrayNode;
        }

        public int countPrimaryEdges() {
            int n = 0;
            ArrayNode arrayNode = this;
            while (arrayNode.mPrimaryEdge != null) {
                arrayNode = arrayNode.mPrimaryEdge;
                ++n;
            }
            return n;
        }

        public int hashCode() {
            return this.mTerm.hashCode();
        }

        public String toString() {
            return "ArrayNode[" + String.valueOf(this.mTerm) + "]";
        }
    }

    private class Cursor {
        ArrayNode mNode;

        public Cursor(CCTerm cCTerm, ArrayNode arrayNode) {
            this.mNode = arrayNode;
        }

        public void collectOverPrimaries(ArrayNode arrayNode, Set<CCTerm> set) {
            int n = this.mNode.countPrimaryEdges();
            int n2 = arrayNode.countPrimaryEdges();
            while (n > n2) {
                set.add(ArrayTheory.getIndexFromStore(this.mNode.mPrimaryStore));
                this.mNode = this.mNode.mPrimaryEdge;
                --n;
            }
            while (n2 > n) {
                set.add(ArrayTheory.getIndexFromStore(arrayNode.mPrimaryStore));
                arrayNode = arrayNode.mPrimaryEdge;
                --n2;
            }
            while (this.mNode != arrayNode) {
                set.add(ArrayTheory.getIndexFromStore(this.mNode.mPrimaryStore));
                set.add(ArrayTheory.getIndexFromStore(arrayNode.mPrimaryStore));
                this.mNode = this.mNode.mPrimaryEdge;
                arrayNode = arrayNode.mPrimaryEdge;
            }
        }

        private void collectOneSecondary(CCTerm cCTerm, Set<CCTerm> set) {
            ArrayNode arrayNode = this.mNode.findSecondaryNode(cCTerm);
            CCAppTerm cCAppTerm = arrayNode.mSecondaryStore;
            CCTerm cCTerm2 = ArrayTheory.getArrayFromStore(cCAppTerm);
            ArrayNode arrayNode2 = ArrayTheory.this.mCongRoots.get(cCTerm2.getRepresentative());
            ArrayNode arrayNode3 = ArrayTheory.this.mCongRoots.get(cCAppTerm.getRepresentative());
            if (arrayNode2.findSecondaryNode(cCTerm) == arrayNode) {
                this.collectOverPrimaries(arrayNode2, set);
                this.mNode = arrayNode3;
            } else {
                assert (arrayNode3.findSecondaryNode(cCTerm) == arrayNode);
                this.collectOverPrimaries(arrayNode3, set);
                this.mNode = arrayNode2;
            }
            set.add(ArrayTheory.getIndexFromStore(cCAppTerm));
        }

        public void collect(CCTerm cCTerm, Cursor cursor, Set<CCTerm> set) {
            int n = this.mNode.countSecondaryEdges(cCTerm);
            int n2 = cursor.mNode.countSecondaryEdges(cCTerm);
            while (n > n2) {
                this.collectOneSecondary(cCTerm, set);
                --n;
            }
            while (n2 > n) {
                cursor.collectOneSecondary(cCTerm, set);
                --n2;
            }
            while (this.mNode.findSecondaryNode(cCTerm) != cursor.mNode.findSecondaryNode(cCTerm)) {
                this.collectOneSecondary(cCTerm, set);
                cursor.collectOneSecondary(cCTerm, set);
            }
            this.collectOverPrimaries(cursor.mNode, set);
        }
    }
}

