/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.DeterminizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DeterminizeDD;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import java.util.Set;

public final class Determinize<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mResult;
    private final IStateDeterminizer<LETTER, STATE> mStateDeterminizer;

    public Determinize(AutomataLibraryServices automataLibraryServices, IDeterminizeStateFactory<STATE> iDeterminizeStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iDeterminizeStateFactory, iNwaOutgoingLetterAndTransitionProvider, null);
    }

    public Determinize(AutomataLibraryServices automataLibraryServices, IDeterminizeStateFactory<STATE> iDeterminizeStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, Set<STATE> set) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mStateDeterminizer = new PowersetDeterminizer<LETTER, STATE>(this.mOperand, true, iDeterminizeStateFactory);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        DeterminizeNwa<LETTER, STATE> determinizeNwa = set == null ? new DeterminizeNwa<LETTER, STATE>(this.mServices, this.mOperand, this.mStateDeterminizer, iDeterminizeStateFactory) : new DeterminizeNwa<LETTER, STATE>(this.mServices, this.mOperand, this.mStateDeterminizer, iDeterminizeStateFactory, set, false);
        this.mResult = new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, determinizeNwa);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation();
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        boolean bl = true;
        if (this.mStateDeterminizer instanceof PowersetDeterminizer) {
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
            }
            Object object = new DeterminizeDD<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mOperand).getResult();
            bl &= new IsEquivalent<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, object, this.mResult).getResult().booleanValue();
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
            }
        } else if (this.mLogger.isWarnEnabled()) {
            this.mLogger.warn((Object)"result was not tested");
        }
        if (!bl) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mOperand);
        }
        return bl;
    }
}

