/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSepSettings;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class ComputeMemlocInitializingTransformula {
    private final ManagedScript mMgdScript;
    private Term mInitializingTerm;
    private Map<IProgramVar, TermVariable> mMemlocInVars;
    private Map<IProgramVar, TermVariable> mMemlocOutVars;
    private final HeapSepSettings mSettings;
    private final MemlocArrayManager mMemlocArrayManager;
    private final UnmodifiableTransFormula mResult;

    ComputeMemlocInitializingTransformula(MemlocArrayManager memlocArrayManager, IProgramVar iProgramVar, HeapSepSettings heapSepSettings, ManagedScript managedScript) {
        this.mMgdScript = managedScript;
        this.mSettings = Objects.requireNonNull(heapSepSettings);
        this.mMemlocArrayManager = memlocArrayManager;
        this.computeInitializingTerm(Objects.requireNonNull(memlocArrayManager), Objects.requireNonNull(iProgramVar));
        this.mResult = this.computeInitializingTransformula();
    }

    private void computeInitializingTerm(MemlocArrayManager memlocArrayManager, IProgramVar iProgramVar) {
        this.mMemlocInVars = new HashMap<IProgramVar, TermVariable>();
        this.mMemlocOutVars = new HashMap<IProgramVar, TermVariable>();
        Set<IProgramNonOldVar> set = memlocArrayManager.getGlobalLocArrays();
        this.mMgdScript.lock((Object)this);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (IProgramNonOldVar iProgramNonOldVar : set) {
            TermVariable termVariable = this.mMgdScript.constructFreshTermVariable(iProgramNonOldVar.getGloballyUniqueId(), iProgramNonOldVar.getSort());
            Term term = this.mMemlocArrayManager.getInitConstArrayForGlobalLocArray(iProgramNonOldVar, this);
            arrayList.add(SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)termVariable, (Term)term));
            this.mMemlocInVars.put((IProgramVar)iProgramNonOldVar, termVariable);
            this.mMemlocOutVars.put((IProgramVar)iProgramNonOldVar, termVariable);
        }
        this.mInitializingTerm = SmtUtils.and((Script)this.mMgdScript.getScript(), arrayList);
        this.mMgdScript.unlock((Object)this);
    }

    Map<IProgramVar, TermVariable> getMemlocInVars() {
        return this.mMemlocInVars;
    }

    Map<IProgramVar, TermVariable> getMemlocOutVars() {
        return this.mMemlocOutVars;
    }

    public UnmodifiableTransFormula computeInitializingTransformula() {
        Map<IProgramVar, TermVariable> map = this.getMemlocInVars();
        Map<IProgramVar, TermVariable> map2 = this.getMemlocOutVars();
        HashSet<HeapSepProgramConst> hashSet = new HashSet<HeapSepProgramConst>(this.mMemlocArrayManager.getInitLocLits());
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(map, map2, hashSet.isEmpty(), hashSet, true, null, true);
        Term term = this.mInitializingTerm;
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        UnmodifiableTransFormula unmodifiableTransFormula = transFormulaBuilder.finishConstruction(this.mMgdScript);
        return unmodifiableTransFormula;
    }

    public UnmodifiableTransFormula getResult() {
        return this.mResult;
    }
}

