/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.backtranslation;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.BackTransValue;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.InlinedCallAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CallReinserter {
    private final Deque<BackTransValue> mPrevBackTranslations = new ArrayDeque<BackTransValue>();

    public List<AtomicTraceElement<BoogieASTNode>> recoverInlinedCallsBefore(AtomicTraceElement<BoogieASTNode> atomicTraceElement, BackTransValue backTransValue, IRelevanceInformation iRelevanceInformation) {
        boolean bl = atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.PROC_CALL);
        boolean bl2 = atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.PROC_RETURN);
        assert (!bl || !bl2) : "Simultaneous call and return: " + String.valueOf(atomicTraceElement);
        InlinedCallAnnotation inlinedCallAnnotation = InlinedCallAnnotation.getAnnotation((IElement)atomicTraceElement.getTraceElement());
        if (inlinedCallAnnotation == null) {
            return Collections.emptyList();
        }
        AtomicTraceElement.AtomicTraceElementBuilder atomicTraceElementBuilder = new AtomicTraceElement.AtomicTraceElementBuilder();
        atomicTraceElementBuilder.setToStringFunc(BoogiePrettyPrinter.getBoogieToStringProvider());
        atomicTraceElementBuilder.setStepAndElement((Object)inlinedCallAnnotation.getCallStatement());
        if (atomicTraceElement.hasThreadId()) {
            atomicTraceElementBuilder.setThreadId(atomicTraceElement.getThreadId());
        }
        if (inlinedCallAnnotation.isReturn()) {
            atomicTraceElementBuilder.setRelevanceInformation(iRelevanceInformation);
            atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.PROC_RETURN});
            atomicTraceElementBuilder.setProcedures(inlinedCallAnnotation.getCallStatement().getMethodName(), null);
            this.mPrevBackTranslations.remove();
        } else {
            atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.PROC_CALL});
            atomicTraceElementBuilder.setProcedures(null, inlinedCallAnnotation.getCallStatement().getMethodName());
            this.mPrevBackTranslations.add(backTransValue);
        }
        return Collections.singletonList(atomicTraceElementBuilder.build());
    }

    public Set<String> unreturnedInlinedProcedures() {
        HashSet<String> hashSet = new HashSet<String>();
        for (BackTransValue backTransValue : this.mPrevBackTranslations) {
            for (CallStatement callStatement : backTransValue.getOriginalCallStack()) {
                hashSet.add(callStatement.getMethodName());
            }
            hashSet.add(backTransValue.getInlineEntryProcId());
        }
        return hashSet;
    }
}

