/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.SubtaskFileIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.SubtaskIterationIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.NwaFloydHoareValidityCheck;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.CoverageAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheckCraig;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckSpWp;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BinaryStatePredicateManager;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiAutomizerModuleDecompositionBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiAutomizerUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiCegarLoopBenchmarkGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiInterpolantAutomatonBouncer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiInterpolantAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiInterpolantAutomatonConstructionStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiInterpolantAutomatonConstructionStyle;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.LassoCheck;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.RankVarConstructor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.TermcompProofBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar.BuchiCegarLoopResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.DeterministicInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.NondeterministicInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.InterpolationPreferenceChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.StrategyFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;
import de.uni_freiburg.informatik.ultimate.util.HistogramOfIterable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractBuchiCegarLoop<L extends IIcfgTransition<?>, A extends IAutomaton<L, IPredicate>> {
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    protected final IUltimateServiceProvider mServices;
    protected final ILogger mLogger;
    protected final String mIdentifier;
    protected final boolean mIsConcurrent;
    protected int mIteration;
    protected NestedLassoRun<L, IPredicate> mCounterexample;
    protected final PredicateFactoryForInterpolantAutomata mDefaultStateFactory;
    protected final BuchiCegarLoopBenchmarkGenerator mBenchmarkGenerator;
    protected final PredicateFactory mPredicateFactory;
    protected boolean mIsSemiDeterministic;
    protected boolean mUseDoubleDeckers;
    protected final TAPreferences mPref;
    private final BuchiAutomizerModuleDecompositionBenchmark mMDBenchmark;
    private final boolean mConstructTermcompProof;
    private final TermcompProofBenchmark mTermcompProofBenchmark;
    private final InterpolationTechnique mInterpolation;
    private CoverageAnalysis.BackwardCoveringInformation mBci;
    private final CfgSmtToolkit mCsToolkitWithoutRankVars;
    private final CfgSmtToolkit mCsToolkitWithRankVars;
    private final BinaryStatePredicateManager mBinaryStatePredicateManager;
    private A mAbstraction;
    private final StrategyFactory<L> mRefinementStrategyFactory;
    private final TaskIdentifier mTaskIdentifier;
    private final BuchiInterpolantAutomatonBuilder<L> mInterpolantAutomatonBuilder;
    private final List<BuchiInterpolantAutomatonConstructionStyle> mBiaConstructionStyleSequence;
    private final TraceAbstractionPreferenceInitializer.Minimization mAutomataMinimizationAfterFeasibilityBasedRefinement;
    private final TraceAbstractionPreferenceInitializer.Minimization mAutomataMinimizationAfterRankBasedRefinement;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$buchiautomizer$LassoCheck$ContinueDirective;

    public AbstractBuchiCegarLoop(IIcfg<?> iIcfg, RankVarConstructor rankVarConstructor, PredicateFactory predicateFactory, TAPreferences tAPreferences, IUltimateServiceProvider iUltimateServiceProvider, Class<L> clazz, A a, BuchiCegarLoopBenchmarkGenerator buchiCegarLoopBenchmarkGenerator) {
        assert (iUltimateServiceProvider != null);
        this.mIdentifier = iIcfg.getIdentifier();
        this.mTaskIdentifier = new SubtaskFileIdentifier(null, this.mIdentifier);
        this.mIsConcurrent = IcfgUtils.isConcurrent(iIcfg);
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mMDBenchmark = new BuchiAutomizerModuleDecompositionBenchmark(this.mServices.getBacktranslationService());
        this.mPredicateFactory = predicateFactory;
        this.mCsToolkitWithoutRankVars = iIcfg.getCfgSmtToolkit();
        this.mCsToolkitWithRankVars = rankVarConstructor.getCsToolkitWithRankVariables();
        this.mBinaryStatePredicateManager = new BinaryStatePredicateManager(this.mCsToolkitWithRankVars, predicateFactory, rankVarConstructor.getUnseededVariable(), rankVarConstructor.getOldRankVariables(), this.mServices, SIMPLIFICATION_TECHNIQUE);
        this.mBenchmarkGenerator = buchiCegarLoopBenchmarkGenerator;
        this.mBenchmarkGenerator.start(CegarLoopStatisticsDefinitions.OverallTime.toString());
        this.mPref = tAPreferences;
        this.mDefaultStateFactory = new PredicateFactoryForInterpolantAutomata(this.mCsToolkitWithRankVars.getManagedScript(), predicateFactory, this.mPref.getHoareSettings().computeHoareAnnotation());
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mInterpolation = (InterpolationTechnique)iPreferenceProvider.getEnum("Compute Interpolants along a Counterexample", InterpolationTechnique.class);
        this.mUseDoubleDeckers = !iPreferenceProvider.getBoolean("Ignore down states");
        InterpolationPreferenceChecker.check((String)"BuchiAutomizer", (InterpolationTechnique)this.mInterpolation, (IUltimateServiceProvider)this.mServices);
        this.mConstructTermcompProof = iPreferenceProvider.getBoolean("Construct termination proof for TermComp");
        this.mTermcompProofBenchmark = this.mConstructTermcompProof ? new TermcompProofBenchmark(this.mServices) : null;
        TaCheckAndRefinementPreferences taCheckAndRefinementPreferences = new TaCheckAndRefinementPreferences(this.mServices, this.mPref, this.mInterpolation, SIMPLIFICATION_TECHNIQUE, this.mCsToolkitWithoutRankVars, this.mPredicateFactory, iIcfg);
        this.mRefinementStrategyFactory = new StrategyFactory(this.mLogger, this.mPref, taCheckAndRefinementPreferences, iIcfg, this.mPredicateFactory, this.mDefaultStateFactory, clazz);
        this.mAbstraction = a;
        this.mInterpolantAutomatonBuilder = new BuchiInterpolantAutomatonBuilder(this.mServices, this.mCsToolkitWithRankVars, SIMPLIFICATION_TECHNIQUE, predicateFactory, this.mInterpolation);
        this.mBiaConstructionStyleSequence = ((BuchiInterpolantAutomatonConstructionStrategy)iPreferenceProvider.getEnum("Buchi interpolant automaton construction strategy", BuchiInterpolantAutomatonConstructionStrategy.class)).getBiaConstrucionStyleSequence(iPreferenceProvider);
        this.mAutomataMinimizationAfterFeasibilityBasedRefinement = (TraceAbstractionPreferenceInitializer.Minimization)iPreferenceProvider.getEnum("Automata minimization after feasibility-based refinement", TraceAbstractionPreferenceInitializer.Minimization.class);
        this.mAutomataMinimizationAfterRankBasedRefinement = (TraceAbstractionPreferenceInitializer.Minimization)iPreferenceProvider.getEnum("Automata minimization after rank-based refinement", TraceAbstractionPreferenceInitializer.Minimization.class);
    }

    protected abstract boolean isAbstractionEmpty(A var1) throws AutomataLibraryException;

    protected abstract A refineFinite(A var1, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> var2) throws AutomataLibraryException;

    protected abstract A refineBuchi(A var1, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> var2) throws AutomataLibraryException;

    protected abstract A reduceAbstractionSize(A var1, TraceAbstractionPreferenceInitializer.Minimization var2) throws AutomataOperationCanceledException;

    public final BuchiCegarLoopResult<L> runCegarLoop() throws IOException {
        boolean bl;
        this.mLogger.info((Object)("Interprodecural is " + this.mPref.interprocedural()));
        this.mLogger.info((Object)("Hoare is " + String.valueOf(this.mPref.getHoareSettings().getHoarePositions())));
        this.mLogger.info((Object)("Compute interpolants for " + String.valueOf(this.mInterpolation)));
        this.mLogger.info((Object)("Backedges is " + String.valueOf(this.mPref.interpolantAutomaton())));
        this.mLogger.info((Object)("Determinization is " + String.valueOf(this.mPref.interpolantAutomatonEnhancement())));
        this.mLogger.info((Object)("Difference is " + this.mPref.differenceSenwa()));
        this.mLogger.info((Object)("Minimize is " + String.valueOf(this.mPref.getMinimization())));
        this.mIteration = 0;
        String string = this.getClass().getSimpleName();
        this.mLogger.info("======== Iteration %s == of CEGAR loop == %s ========", new Object[]{this.mIteration, string});
        if (this.mPref.dumpAutomata()) {
            String string2 = this.mIdentifier + "_" + string + "Abstraction" + this.mIteration;
            BuchiAutomizerUtils.writeAutomatonToFile(this.mServices, this.mAbstraction, this.mPref.dumpPath(), string2, this.mPref.getAutomataFormat(), "");
        }
        try {
            bl = this.isAbstractionEmpty(this.mAbstraction);
        }
        catch (AutomataLibraryException automataLibraryException) {
            this.mLogger.warn((Object)"Verification cancelled");
            this.mMDBenchmark.reportRemainderModule(this.mAbstraction.size(), false);
            return BuchiCegarLoopResult.constructTimeoutResult(new ToolchainCanceledException(automataLibraryException.getClassOfThrower()), this.mMDBenchmark, this.mTermcompProofBenchmark);
        }
        if (bl) {
            this.mMDBenchmark.reportNoRemainderModule();
            return BuchiCegarLoopResult.constructTerminatingResult(this.mMDBenchmark, this.mTermcompProofBenchmark);
        }
        this.mIteration = 1;
        while (this.mIteration <= this.mPref.maxIterations()) {
            NestedWord<L> nestedWord;
            LassoCheck<L> lassoCheck;
            Object object;
            Object object2;
            boolean bl2;
            this.mLogger.info("======== Iteration %s ============", new Object[]{this.mIteration});
            this.mBenchmarkGenerator.announceNextIteration();
            try {
                bl2 = this.isAbstractionEmpty(this.mAbstraction);
            }
            catch (AutomataLibraryException automataLibraryException) {
                this.mLogger.warn((Object)"Verification cancelled");
                this.reportRemainderModule(false);
                return BuchiCegarLoopResult.constructTimeoutResult(new ToolchainCanceledException(automataLibraryException.getClassOfThrower()), this.mMDBenchmark, this.mTermcompProofBenchmark);
            }
            if (bl2) {
                this.mMDBenchmark.reportNoRemainderModule();
                if (this.mConstructTermcompProof) {
                    this.mTermcompProofBenchmark.reportNoRemainderModule();
                }
                return BuchiCegarLoopResult.constructTerminatingResult(this.mMDBenchmark, this.mTermcompProofBenchmark);
            }
            try {
                try {
                    object2 = new SubtaskIterationIdentifier(this.mTaskIdentifier, this.mIteration);
                    this.mBenchmarkGenerator.start("LassoAnalysisTime");
                    object = this.mIdentifier + "_Iteration" + this.mIteration;
                    lassoCheck = new LassoCheck<L>(this.mCsToolkitWithoutRankVars, this.mPredicateFactory, this.mCsToolkitWithoutRankVars.getSmtFunctionsAndAxioms(), this.mBinaryStatePredicateManager, this.mCounterexample, this::getControlConfiguration, (String)object, this.mServices, SIMPLIFICATION_TECHNIQUE, this.mRefinementStrategyFactory, this.mAbstraction, (TaskIdentifier)object2, this.mBenchmarkGenerator);
                    if (lassoCheck.getLassoCheckResult().getContinueDirective() == LassoCheck.ContinueDirective.REPORT_UNKNOWN) {
                        nestedWord = new SubtaskAdditionalLoopUnwinding((TaskIdentifier)object2, 1);
                        this.mLogger.info((Object)"Result of lasso check was UNKNOWN. I will concatenate loop to stem and try again.");
                        NestedRun nestedRun = this.mCounterexample.getStem().concatenate(this.mCounterexample.getLoop());
                        this.mCounterexample = new NestedLassoRun(nestedRun, this.mCounterexample.getLoop());
                        lassoCheck = new LassoCheck<L>(this.mCsToolkitWithoutRankVars, this.mPredicateFactory, this.mCsToolkitWithoutRankVars.getSmtFunctionsAndAxioms(), this.mBinaryStatePredicateManager, this.mCounterexample, this::getControlConfiguration, (String)object, this.mServices, SIMPLIFICATION_TECHNIQUE, this.mRefinementStrategyFactory, this.mAbstraction, (TaskIdentifier)nestedWord, this.mBenchmarkGenerator);
                    }
                }
                catch (ToolchainCanceledException toolchainCanceledException) {
                    int n = new HistogramOfIterable((Iterable)this.mCounterexample.getStem().getWord()).getMax();
                    int n2 = new HistogramOfIterable((Iterable)this.mCounterexample.getLoop().getWord()).getMax();
                    nestedWord = "analyzing lasso (stem: length " + this.mCounterexample.getStem().getLength() + " TraceHistMax " + n + " loop: length " + this.mCounterexample.getLoop().getLength() + " TraceHistMax " + n2 + ")";
                    toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), (String)nestedWord));
                    BuchiCegarLoopResult buchiCegarLoopResult = BuchiCegarLoopResult.constructTimeoutResult(toolchainCanceledException, this.mMDBenchmark, this.mTermcompProofBenchmark);
                    this.mBenchmarkGenerator.stop("LassoAnalysisTime");
                    return buchiCegarLoopResult;
                }
            }
            finally {
                this.mBenchmarkGenerator.stop("LassoAnalysisTime");
            }
            object2 = lassoCheck.getLassoCheckResult().getContinueDirective();
            this.mBenchmarkGenerator.reportLassoAnalysis(lassoCheck);
            try {
                switch (AbstractBuchiCegarLoop.$SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$buchiautomizer$LassoCheck$ContinueDirective()[((Enum)object2).ordinal()]) {
                    case 5: {
                        this.mAbstraction = this.refineFiniteInternal(this.refineBuchiInternal(lassoCheck), lassoCheck);
                        break;
                    }
                    case 1: {
                        this.mAbstraction = this.refineFiniteInternal(this.mAbstraction, lassoCheck);
                        break;
                    }
                    case 2: {
                        this.mAbstraction = this.refineBuchiInternal(lassoCheck);
                        break;
                    }
                    case 3: 
                    case 4: {
                        object = new HashSet(this.mCsToolkitWithoutRankVars.getConcurrencyInformation().getInUseErrorNodeMap().values());
                        NestedWord<L> nestedWord2 = AbstractBuchiCegarLoop.getWordWithoutLocs(this.mCounterexample.getStem(), (Set<IcfgLocation>)object);
                        nestedWord = AbstractBuchiCegarLoop.getWordWithoutLocs(this.mCounterexample.getLoop(), (Set<IcfgLocation>)object);
                        if (object2 == LassoCheck.ContinueDirective.REPORT_NONTERMINATION && this.getOverapproximations().isEmpty()) {
                            this.reportRemainderModule(true);
                            if (nestedWord.length() == 0) {
                                return BuchiCegarLoopResult.constructInsufficientThreadsResult();
                            }
                            return BuchiCegarLoopResult.constructNonTerminatingResult(nestedWord2, nestedWord, lassoCheck.getNonTerminationArgument(), this.mMDBenchmark, this.mTermcompProofBenchmark);
                        }
                        this.reportRemainderModule(false);
                        return BuchiCegarLoopResult.constructUnknownResult(nestedWord2, nestedWord, this.getOverapproximations(), this.mMDBenchmark, this.mTermcompProofBenchmark);
                    }
                    default: {
                        throw new AssertionError((Object)"impossible case");
                    }
                }
                this.mLogger.info((Object)("Abstraction has " + this.mAbstraction.sizeInformation()));
                if (this.mPref.dumpAutomata()) {
                    object = this.mIdentifier + "_" + string + "Abstraction" + this.mIteration;
                    BuchiAutomizerUtils.writeAutomatonToFile(this.mServices, this.mAbstraction, this.mPref.dumpPath(), (String)object, this.mPref.getAutomataFormat(), "");
                }
            }
            catch (AutomataLibraryException automataLibraryException) {
                return BuchiCegarLoopResult.constructTimeoutResult(new ToolchainCanceledException(automataLibraryException.getClassOfThrower()), this.mMDBenchmark, this.mTermcompProofBenchmark);
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                return BuchiCegarLoopResult.constructTimeoutResult(toolchainCanceledException, this.mMDBenchmark, this.mTermcompProofBenchmark);
            }
            ++this.mIteration;
        }
        return BuchiCegarLoopResult.constructTimeoutResult(new ToolchainCanceledException(this.getClass(), "exceeding the number of iterations"), this.mMDBenchmark, this.mTermcompProofBenchmark);
    }

    private static <L extends IIcfgTransition<?>> NestedWord<L> getWordWithoutLocs(NestedRun<L, ?> nestedRun, Set<IcfgLocation> set) {
        if (set.isEmpty()) {
            return nestedRun.getWord();
        }
        Object[] objectArray = (IIcfgTransition[])nestedRun.getWord().asList().stream().filter(iIcfgTransition -> !set.contains(iIcfgTransition.getTarget())).toArray(IIcfgTransition[]::new);
        return NestedWord.nestedWord((Word)new Word(objectArray));
    }

    private A refineFiniteInternal(A a, LassoCheck<L> lassoCheck) throws AutomataLibraryException {
        A a2;
        this.mBenchmarkGenerator.start(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
        IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> iRefinementEngineResult = this.constructRefinementEngineResult(lassoCheck);
        NestedWordAutomaton nestedWordAutomaton = (NestedWordAutomaton)iRefinementEngineResult.getInfeasibilityProof();
        IHoareTripleChecker iHoareTripleChecker = HoareTripleCheckerUtils.constructEfficientHoareTripleCheckerWithCaching((IUltimateServiceProvider)this.mServices, (HoareTripleCheckerUtils.HoareTripleChecks)HoareTripleCheckerUtils.HoareTripleChecks.INCREMENTAL, (CfgSmtToolkit)this.mCsToolkitWithRankVars, (IPredicateUnifier)iRefinementEngineResult.getPredicateUnifier());
        DeterministicInterpolantAutomaton deterministicInterpolantAutomaton = new DeterministicInterpolantAutomaton(this.mServices, this.mCsToolkitWithRankVars, iHoareTripleChecker, (INestedWordAutomaton)nestedWordAutomaton, iRefinementEngineResult.getPredicateUnifier(), false, false);
        try {
            a2 = this.reduceAbstractionSize(this.refineFinite(a, (INwaOutgoingLetterAndTransitionProvider<L, IPredicate>)deterministicInterpolantAutomaton), this.mAutomataMinimizationAfterFeasibilityBasedRefinement);
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            this.mBenchmarkGenerator.stop(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
            throw automataOperationCanceledException;
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            this.mBenchmarkGenerator.stop(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
            throw toolchainCanceledException;
        }
        deterministicInterpolantAutomaton.switchToReadonlyMode();
        if (this.mPref.dumpAutomata()) {
            String string = this.mIdentifier + "_interpolAutomatonUsedInRefinement" + this.mIteration + "after";
            BuchiAutomizerUtils.writeAutomatonToFile(this.mServices, nestedWordAutomaton, this.mPref.dumpPath(), string, this.mPref.getAutomataFormat(), "");
        }
        if (this.mConstructTermcompProof) {
            this.mTermcompProofBenchmark.reportFiniteModule(this.mIteration, (INwaOutgoingLetterAndTransitionProvider<?, IPredicate>)nestedWordAutomaton);
        }
        this.mMDBenchmark.reportTrivialModule(this.mIteration, nestedWordAutomaton.size());
        assert (NwaFloydHoareValidityCheck.forInterpolantAutomaton((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mCsToolkitWithRankVars.getManagedScript(), (IHoareTripleChecker)new IncrementalHoareTripleChecker(this.mCsToolkitWithRankVars, false), (IPredicateUnifier)iRefinementEngineResult.getPredicateUnifier(), (INestedWordAutomaton)nestedWordAutomaton, (boolean)true).getResult());
        this.mBenchmarkGenerator.addEdgeCheckerData(iHoareTripleChecker.getStatistics());
        this.mBenchmarkGenerator.stop(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
        return a2;
    }

    private IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> constructRefinementEngineResult(LassoCheck<L> lassoCheck) {
        LassoCheck.LassoCheckResult lassoCheckResult = lassoCheck.getLassoCheckResult();
        if (lassoCheck.getLassoCheckResult().getStemFeasibility() == LassoCheck.TraceCheckResult.INFEASIBLE) {
            int n = this.mCounterexample.getStem().getLength();
            int n2 = this.mCounterexample.getLoop().getLength();
            if (lassoCheckResult.getLoopFeasibility() == LassoCheck.TraceCheckResult.INFEASIBLE && n2 <= n) {
                return lassoCheck.getLoopCheck();
            }
            return lassoCheck.getStemCheck();
        }
        if (lassoCheckResult.getLoopFeasibility() == LassoCheck.TraceCheckResult.INFEASIBLE) {
            return lassoCheck.getLoopCheck();
        }
        assert (lassoCheckResult.getConcatFeasibility() == LassoCheck.TraceCheckResult.INFEASIBLE);
        return lassoCheck.getConcatCheck();
    }

    private A refineBuchiInternal(LassoCheck<L> lassoCheck) throws AutomataOperationCanceledException {
        BinaryStatePredicateManager.BspmResult bspmResult = lassoCheck.getBspmResult();
        IPredicate iPredicate = bspmResult.getHondaPredicate();
        IPredicate iPredicate2 = bspmResult.getRankEqAndSi();
        assert (!SmtUtils.isFalseLiteral((Term)bspmResult.getStemPrecondition().getFormula()));
        assert (!SmtUtils.isFalseLiteral((Term)iPredicate.getFormula()));
        assert (!SmtUtils.isFalseLiteral((Term)iPredicate2.getFormula()));
        boolean bl = this.mPref.dumpAutomata();
        String string = this.mPref.dumpPath();
        AutomatonDefinitionPrinter.Format format = this.mPref.getAutomataFormat();
        RankingFunction rankingFunction = bspmResult.getTerminationArgument().getRankingFunction();
        Script script = this.mCsToolkitWithRankVars.getManagedScript().getScript();
        this.mMDBenchmark.reportRankingFunction(this.mIteration, rankingFunction, script);
        this.mBenchmarkGenerator.start(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
        int n = 0;
        for (BuchiInterpolantAutomatonConstructionStyle buchiInterpolantAutomatonConstructionStyle : this.mBiaConstructionStyleSequence) {
            boolean bl2;
            A a;
            INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider;
            Object object;
            Object object2;
            try {
                String string2;
                object2 = new PredicateUnifier(this.mLogger, this.mServices, this.mCsToolkitWithRankVars.getManagedScript(), (BasicPredicateFactory)this.mPredicateFactory, this.mCsToolkitWithRankVars.getSymbolTable(), SIMPLIFICATION_TECHNIQUE, new IPredicate[]{bspmResult.getStemPrecondition(), iPredicate, iPredicate2, bspmResult.getStemPostcondition(), bspmResult.getRankDecreaseAndBound(), bspmResult.getSiConjunction()});
                object = this.getStemInterpolants((NestedRun<L, IPredicate>)this.mCounterexample.getStem(), bspmResult.getStemPrecondition(), bspmResult.getStemPostcondition(), (PredicateUnifier)object2);
                IPredicate[] iPredicateArray = this.getLoopInterpolants((NestedRun<L, IPredicate>)this.mCounterexample.getLoop(), iPredicate, iPredicate2, (PredicateUnifier)object2);
                NestedWordAutomaton<L, IPredicate> nestedWordAutomaton = this.mInterpolantAutomatonBuilder.constructInterpolantAutomaton(bspmResult.getStemPrecondition(), this.mCounterexample, (IPredicate[])object, iPredicate, iPredicateArray, (VpAlphabet<L>)BuchiAutomizerUtils.getVpAlphabet(this.mAbstraction), (IEmptyStackStateFactory<IPredicate>)this.mDefaultStateFactory);
                if (bl) {
                    string2 = this.mIdentifier + "_InterpolantAutomatonBuchi" + this.mIteration;
                    BuchiAutomizerUtils.writeAutomatonToFile(this.mServices, nestedWordAutomaton, string, string2, format, buchiInterpolantAutomatonConstructionStyle.toString());
                }
                string2 = HoareTripleCheckerUtils.constructEfficientHoareTripleCheckerWithCaching((IUltimateServiceProvider)this.mServices, (HoareTripleCheckerUtils.HoareTripleChecks)HoareTripleCheckerUtils.HoareTripleChecks.INCREMENTAL, (CfgSmtToolkit)this.mCsToolkitWithRankVars, (IPredicateUnifier)object2);
                BuchiHoareTripleChecker buchiHoareTripleChecker = new BuchiHoareTripleChecker((IHoareTripleChecker)string2);
                buchiHoareTripleChecker.putDecreaseEqualPair(iPredicate, iPredicate2);
                assert (NwaFloydHoareValidityCheck.forInterpolantAutomaton((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mCsToolkitWithRankVars.getManagedScript(), (IHoareTripleChecker)buchiHoareTripleChecker, (IPredicateUnifier)object2, nestedWordAutomaton, (boolean)true, (IPredicate)bspmResult.getStemPrecondition()).getResult());
                assert (new BuchiAccepts(new AutomataLibraryServices(this.mServices), nestedWordAutomaton, this.mCounterexample.getNestedLassoWord()).getResult().booleanValue());
                iNwaOutgoingLetterAndTransitionProvider = this.mInterpolantAutomatonBuilder.constructGeneralizedAutomaton(this.mCounterexample, buchiInterpolantAutomatonConstructionStyle, bspmResult, (PredicateUnifier)object2, (IPredicate[])object, iPredicateArray, nestedWordAutomaton, buchiHoareTripleChecker);
                this.mIsSemiDeterministic = buchiInterpolantAutomatonConstructionStyle.isAlwaysSemiDeterministic();
                a = this.refineBuchi(this.mAbstraction, iNwaOutgoingLetterAndTransitionProvider);
                if (iNwaOutgoingLetterAndTransitionProvider instanceof NondeterministicInterpolantAutomaton) {
                    ((NondeterministicInterpolantAutomaton)iNwaOutgoingLetterAndTransitionProvider).switchToReadonlyMode();
                } else if (iNwaOutgoingLetterAndTransitionProvider instanceof BuchiInterpolantAutomatonBouncer) {
                    ((BuchiInterpolantAutomatonBouncer)iNwaOutgoingLetterAndTransitionProvider).switchToReadonlyMode();
                }
                this.mBenchmarkGenerator.addEdgeCheckerData(buchiHoareTripleChecker.getStatistics());
                bl2 = this.isUsefulInterpolantAutomaton(iNwaOutgoingLetterAndTransitionProvider, this.mCounterexample);
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                this.mBenchmarkGenerator.stop(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
                object = new RunningTaskInfo(this.getClass(), "applying stage " + n);
                throw new ToolchainCanceledException((IRunningTaskStackProvider)automataOperationCanceledException, (RunningTaskInfo)object);
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                this.mBenchmarkGenerator.stop(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
                throw toolchainCanceledException;
            }
            catch (AutomataLibraryException automataLibraryException) {
                throw new AssertionError((Object)automataLibraryException.getMessage());
            }
            if (bl) {
                object2 = iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getCallAlphabet().isEmpty() ? "interpolBuchiAutomatonUsedInRefinement" : "interpolBuchiNestedWordAutomatonUsedInRefinement";
                object = this.mIdentifier + "_" + (String)object2 + this.mIteration + "after";
                BuchiAutomizerUtils.writeAutomatonToFile(this.mServices, iNwaOutgoingLetterAndTransitionProvider, string, (String)object, format, buchiInterpolantAutomatonConstructionStyle.toString());
            }
            if (bl2) {
                if (this.mConstructTermcompProof) {
                    this.mTermcompProofBenchmark.reportBuchiModule(this.mIteration, iNwaOutgoingLetterAndTransitionProvider);
                }
                this.mBenchmarkGenerator.announceSuccessfullRefinementStage(n);
                switch (buchiInterpolantAutomatonConstructionStyle.getInterpolantAutomaton()) {
                    case LASSO_AUTOMATON: 
                    case DETERMINISTIC: {
                        this.mMDBenchmark.reportDeterministicModule(this.mIteration, iNwaOutgoingLetterAndTransitionProvider.size());
                        break;
                    }
                    case EAGER_NONDETERMINISM: 
                    case SCROOGE_NONDETERMINISM: {
                        this.mMDBenchmark.reportNonDeterministicModule(this.mIteration, iNwaOutgoingLetterAndTransitionProvider.size());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"unsupported");
                    }
                }
                this.mBenchmarkGenerator.stop(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
                this.mBenchmarkGenerator.addBackwardCoveringInformationBuchi(this.mBci);
                return this.reduceAbstractionSize(a, this.mAutomataMinimizationAfterRankBasedRefinement);
            }
            ++n;
        }
        throw new AssertionError((Object)"no settings was sufficient");
    }

    private boolean isUsefulInterpolantAutomaton(INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, NestedLassoRun<L, IPredicate> nestedLassoRun) throws AutomataLibraryException {
        NestedWordAutomatonReachableStates nestedWordAutomatonReachableStates = new RemoveUnreachable(new AutomataLibraryServices(this.mServices), iNwaOutgoingLetterAndTransitionProvider).getResult();
        NestedWord nestedWord = nestedLassoRun.getStem().getWord();
        NestedWord nestedWord2 = nestedLassoRun.getLoop().getWord();
        NestedWord nestedWord3 = nestedWord.concatenate(nestedWord2);
        NestedLassoWord nestedLassoWord = new NestedLassoWord(nestedWord3, nestedWord2);
        NestedWord nestedWord4 = nestedWord2.concatenate(nestedWord2);
        NestedLassoWord nestedLassoWord2 = new NestedLassoWord(nestedWord, nestedWord4);
        boolean bl = new BuchiAccepts(new AutomataLibraryServices(this.mServices), (INwaOutgoingLetterAndTransitionProvider)nestedWordAutomatonReachableStates, nestedLassoRun.getNestedLassoWord()).getResult();
        if (!bl) {
            this.mLogger.info((Object)"Bad chosen interpolant automaton: word not accepted");
            return false;
        }
        boolean bl2 = new BuchiAccepts(new AutomataLibraryServices(this.mServices), (INwaOutgoingLetterAndTransitionProvider)nestedWordAutomatonReachableStates, nestedLassoWord).getResult();
        if (!bl2) {
            throw new AssertionError((Object)"Bad chosen interpolant automaton: stem extension not accepted");
        }
        boolean bl3 = new BuchiAccepts(new AutomataLibraryServices(this.mServices), (INwaOutgoingLetterAndTransitionProvider)nestedWordAutomatonReachableStates, nestedLassoWord2).getResult();
        if (!bl3) {
            throw new AssertionError((Object)"Bad chosen interpolant automaton: loop extension not accepted");
        }
        return true;
    }

    private IPredicate[] getStemInterpolants(NestedRun<L, IPredicate> nestedRun, IPredicate iPredicate, IPredicate iPredicate2, PredicateUnifier predicateUnifier) {
        if (BuchiAutomizerUtils.isEmptyStem(nestedRun)) {
            return null;
        }
        InterpolatingTraceCheck<L> interpolatingTraceCheck = this.constructTraceCheck(iPredicate, iPredicate2, nestedRun, predicateUnifier);
        if (interpolatingTraceCheck.isCorrect() != Script.LBool.UNSAT) {
            throw new AssertionError((Object)"incorrect predicates - stem");
        }
        return interpolatingTraceCheck.getInterpolants();
    }

    private IPredicate[] getLoopInterpolants(NestedRun<L, IPredicate> nestedRun, IPredicate iPredicate, IPredicate iPredicate2, PredicateUnifier predicateUnifier) {
        InterpolatingTraceCheck<L> interpolatingTraceCheck = this.constructTraceCheck(iPredicate2, iPredicate, nestedRun, predicateUnifier);
        if (interpolatingTraceCheck.isCorrect() != Script.LBool.UNSAT) {
            throw new AssertionError((Object)"incorrect predicates - loop");
        }
        this.mBci = TraceCheckUtils.computeCoverageCapability((IUltimateServiceProvider)this.mServices, interpolatingTraceCheck, (ILogger)this.mLogger);
        return interpolatingTraceCheck.getInterpolants();
    }

    private InterpolatingTraceCheck<L> constructTraceCheck(IPredicate iPredicate, IPredicate iPredicate2, NestedRun<L, IPredicate> nestedRun, PredicateUnifier predicateUnifier) {
        switch (this.mInterpolation) {
            case Craig_NestedInterpolation: 
            case Craig_TreeInterpolation: {
                return new InterpolatingTraceCheckCraig(iPredicate, iPredicate2, new TreeMap(), new Counterexample((Word)nestedRun.getWord()), this.mServices, this.mCsToolkitWithRankVars, this.mPredicateFactory, (IPredicateUnifier)predicateUnifier, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, false, false, this.mInterpolation, true, SIMPLIFICATION_TECHNIQUE);
            }
            case ForwardPredicates: 
            case BackwardPredicates: 
            case FPandBP: 
            case FPandBPonlyIfFpWasNotPerfect: {
                return new TraceCheckSpWp(iPredicate, iPredicate2, new TreeMap(), new Counterexample((Word)nestedRun.getWord()), this.mCsToolkitWithRankVars, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, ITraceCheckPreferences.UnsatCores.CONJUNCT_LEVEL, true, this.mServices, false, this.mPredicateFactory, (IPredicateUnifier)predicateUnifier, this.mInterpolation, this.mCsToolkitWithRankVars.getManagedScript(), SIMPLIFICATION_TECHNIQUE, false);
            }
        }
        throw new UnsupportedOperationException("unsupported interpolation");
    }

    private void reportRemainderModule(boolean bl) {
        this.mMDBenchmark.reportRemainderModule(this.mAbstraction.size(), bl);
        if (this.mConstructTermcompProof) {
            this.mTermcompProofBenchmark.reportRemainderModule(bl);
        }
    }

    private HashRelation<String, ILocation> getOverapproximations() {
        NestedWord nestedWord = this.mCounterexample.getStem().getWord();
        NestedWord nestedWord2 = this.mCounterexample.getLoop().getWord();
        HashRelation hashRelation = new HashRelation();
        hashRelation.addAll((AbstractRelation)Overapprox.getOverapproximations((List)nestedWord.asList()));
        hashRelation.addAll((AbstractRelation)Overapprox.getOverapproximations((List)nestedWord2.asList()));
        return hashRelation;
    }

    protected Object getControlConfiguration(IPredicate iPredicate) {
        if (this.mIsConcurrent) {
            return ((IMLPredicate)iPredicate).getProgramPoints();
        }
        return ((ISLPredicate)iPredicate).getProgramPoint();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$buchiautomizer$LassoCheck$ContinueDirective() {
        if ($SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$buchiautomizer$LassoCheck$ContinueDirective != null) {
            return $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$buchiautomizer$LassoCheck$ContinueDirective;
        }
        int[] nArray = new int[LassoCheck.ContinueDirective.values().length];
        try {
            nArray[LassoCheck.ContinueDirective.REFINE_BOTH.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LassoCheck.ContinueDirective.REFINE_BUCHI.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LassoCheck.ContinueDirective.REFINE_FINITE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LassoCheck.ContinueDirective.REPORT_NONTERMINATION.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LassoCheck.ContinueDirective.REPORT_UNKNOWN.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$buchiautomizer$LassoCheck$ContinueDirective = nArray;
        return nArray;
    }

    private static class SubtaskAdditionalLoopUnwinding
    extends TaskIdentifier {
        private final int mAdditionaUnwindings;

        public SubtaskAdditionalLoopUnwinding(TaskIdentifier taskIdentifier, int n) {
            super(taskIdentifier);
            this.mAdditionaUnwindings = n;
        }

        protected String getSubtaskIdentifier() {
            return this.mAdditionaUnwindings + "additionalUnwindings";
        }
    }
}

