/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsLoopSummarization;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator.IAccelerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;

public class AcceleratorQvasrs
implements IAccelerator {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private boolean mFoundAcceleration;
    private final boolean mIsOverapprox;

    public AcceleratorQvasrs(ILogger iLogger, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mFoundAcceleration = false;
        this.mIsOverapprox = false;
    }

    @Override
    public UnmodifiableTransFormula accelerateLoop(UnmodifiableTransFormula unmodifiableTransFormula, IcfgLocation icfgLocation) {
        try {
            this.mLogger.debug((Object)"Accelerating Loop using Qvasr Summarization");
            QvasrsLoopSummarization qvasrsLoopSummarization = new QvasrsLoopSummarization(this.mLogger, this.mServices, this.mScript);
            UnmodifiableTransFormula unmodifiableTransFormula2 = qvasrsLoopSummarization.getQvasrsAcceleration(unmodifiableTransFormula, false);
            this.mFoundAcceleration = true;
            return unmodifiableTransFormula2;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.mFoundAcceleration = false;
            this.mLogger.info((Object)("Qvasrs could not accelerate loop because " + String.valueOf(unsupportedOperationException)));
            return unmodifiableTransFormula;
        }
    }

    @Override
    public boolean accelerationFinishedCorrectly() {
        return this.mFoundAcceleration;
    }

    @Override
    public boolean isOverapprox() {
        return this.mIsOverapprox;
    }
}

