/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BasePayloadContainer;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public final class PathProgram
extends BasePayloadContainer
implements IIcfg<IcfgLocation> {
    private static final long serialVersionUID = 6691317791231881900L;
    private final String mIdentifier;
    private final Map<String, Map<DebugIdentifier, IcfgLocation>> mProgramPoints;
    private final Map<String, IcfgLocation> mProcEntries;
    private final Map<String, IcfgLocation> mProcExits;
    private final Map<String, Set<IcfgLocation>> mProcError;
    private final Set<IcfgLocation> mInitialNodes;
    private final Set<IcfgLocation> mLoopLocations;
    private final Set<IcfgLocation> mLocationsOfInterest;
    private final transient CfgSmtToolkit mCfgSmtToolkit;

    private PathProgram(String string, CfgSmtToolkit cfgSmtToolkit, Map<String, Map<DebugIdentifier, IcfgLocation>> map, Map<String, IcfgLocation> map2, Map<String, IcfgLocation> map3, Map<String, Set<IcfgLocation>> map4, Set<IcfgLocation> set, Set<IcfgLocation> set2, Set<IcfgLocation> set3) {
        this.mIdentifier = Objects.requireNonNull(string);
        this.mCfgSmtToolkit = Objects.requireNonNull(cfgSmtToolkit);
        this.mProgramPoints = Objects.requireNonNull(map);
        this.mProcEntries = Objects.requireNonNull(map2);
        this.mProcExits = Objects.requireNonNull(map3);
        this.mProcError = Objects.requireNonNull(map4);
        this.mInitialNodes = Objects.requireNonNull(set);
        this.mLoopLocations = Objects.requireNonNull(set2);
        this.mLocationsOfInterest = Objects.requireNonNull(set3);
    }

    public static PathProgramConstructionResult constructPathProgram(String string, IIcfg<?> iIcfg, Set<? extends IIcfgTransition<?>> set, Set<IcfgLocation> set2, Predicate<IcfgLocation> predicate) {
        return new PathProgramConstructor(iIcfg, set, string, set2, predicate).getResult();
    }

    public Map<String, Map<DebugIdentifier, IcfgLocation>> getProgramPoints() {
        return this.mProgramPoints;
    }

    public Map<String, IcfgLocation> getProcedureEntryNodes() {
        return this.mProcEntries;
    }

    public Map<String, IcfgLocation> getProcedureExitNodes() {
        return this.mProcExits;
    }

    public Map<String, Set<IcfgLocation>> getProcedureErrorNodes() {
        return this.mProcError;
    }

    public CfgSmtToolkit getCfgSmtToolkit() {
        return this.mCfgSmtToolkit;
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public Set<IcfgLocation> getInitialNodes() {
        return this.mInitialNodes;
    }

    public Set<IcfgLocation> getLoopLocations() {
        return this.mLoopLocations;
    }

    public Set<IcfgLocation> getLocationsOfInterest() {
        return this.mLocationsOfInterest;
    }

    public Class<IcfgLocation> getLocationClass() {
        return IcfgLocation.class;
    }

    public String toString() {
        return this.graphStructureToString();
    }

    private static final class PathProgramCallAction<T extends IcfgEdge>
    extends PathProgramIcfgAction<T>
    implements IIcfgCallTransition<IcfgLocation> {
        private static final long serialVersionUID = 1L;

        protected PathProgramCallAction(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, T t) {
            super(icfgLocation, icfgLocation2, t);
        }

        public UnmodifiableTransFormula getLocalVarsAssignment() {
            return ((ICallAction)this.getBacking()).getLocalVarsAssignment();
        }
    }

    public static final class PathProgramConstructionResult {
        private final PathProgram mPathProgram;
        private final Map<IcfgLocation, IcfgLocation> mOldLoc2NewLoc;
        private final Map<IIcfgTransition<?>, IIcfgTransition<?>> mOldTransition2NewTransition;

        private PathProgramConstructionResult(PathProgram pathProgram, Map<IcfgLocation, IcfgLocation> map, Map<IIcfgTransition<?>, IIcfgTransition<?>> map2) {
            this.mPathProgram = pathProgram;
            this.mOldLoc2NewLoc = map;
            this.mOldTransition2NewTransition = map2;
        }

        public PathProgram getPathProgram() {
            return this.mPathProgram;
        }

        public Map<IcfgLocation, IcfgLocation> getLocationMapping() {
            return Collections.unmodifiableMap(this.mOldLoc2NewLoc);
        }

        public Map<IIcfgTransition<?>, IIcfgTransition<?>> getOldTransition2NewTransition() {
            return Collections.unmodifiableMap(this.mOldTransition2NewTransition);
        }
    }

    private static final class PathProgramConstructor {
        private final IIcfg<?> mOriginalIcfg;
        private final Set<IcfgLocation> mAdditionalInitialNodes;
        private final Map<IcfgLocation, IcfgLocation> mOldLoc2NewLoc;
        private final Map<IIcfgTransition<?>, IIcfgTransition<?>> mOldTransition2NewTransition;
        private final Map<IIcfgTransition<?>, PathProgramCallAction<?>> mOldCall2NewCall;
        private final DefaultIcfgSymbolTable mSymbolTable;
        private final Set<String> mProcedures;
        private final Map<String, Map<DebugIdentifier, IcfgLocation>> mProgramPoints;
        private final Map<String, IcfgLocation> mProcEntries;
        private final Map<String, IcfgLocation> mProcExits;
        private final Map<String, Set<IcfgLocation>> mProcError;
        private final Set<IcfgLocation> mInitialNodes;
        private final Set<IcfgLocation> mLoopLocations;
        private final Set<IcfgLocation> mLocationsOfInterest;
        private final Predicate<IcfgLocation> mLoopLocationFilter;
        private final PathProgramConstructionResult mResult;

        private PathProgramConstructor(IIcfg<?> iIcfg, Set<? extends IIcfgTransition<?>> set, String string, Set<IcfgLocation> set2, Predicate<IcfgLocation> predicate) {
            String string2 = Objects.requireNonNull(string);
            Set<IIcfgTransition<?>> set3 = Objects.requireNonNull(set);
            this.mOriginalIcfg = Objects.requireNonNull(iIcfg);
            for (IcfgLocation object2 : set2) {
                if (!((IcfgLocation)((Map)this.mOriginalIcfg.getProgramPoints().get(object2.getProcedure())).get(object2.getDebugIdentifier())).equals((Object)object2)) {
                    throw new AssertionError((Object)("Additional initial location not in original CFG: " + String.valueOf(object2)));
                }
            }
            this.mAdditionalInitialNodes = new LinkedHashSet<IcfgLocation>(set2);
            this.mLoopLocationFilter = predicate;
            this.mOldLoc2NewLoc = new LinkedHashMap<IcfgLocation, IcfgLocation>();
            this.mOldTransition2NewTransition = new LinkedHashMap();
            this.mOldCall2NewCall = new LinkedHashMap();
            this.mSymbolTable = new DefaultIcfgSymbolTable();
            this.mProcedures = new LinkedHashSet<String>();
            this.mProgramPoints = new LinkedHashMap<String, Map<DebugIdentifier, IcfgLocation>>();
            this.mProcEntries = new LinkedHashMap<String, IcfgLocation>();
            this.mProcExits = new LinkedHashMap<String, IcfgLocation>();
            this.mProcError = new LinkedHashMap<String, Set<IcfgLocation>>();
            this.mInitialNodes = new LinkedHashSet<IcfgLocation>();
            this.mLoopLocations = new LinkedHashSet<IcfgLocation>();
            this.mLocationsOfInterest = new LinkedHashSet<IcfgLocation>();
            Predicate<IIcfgTransition> predicate2 = iIcfgTransition -> iIcfgTransition instanceof IIcfgReturnTransition;
            set3.stream().filter(predicate2.negate()).forEach(this::createPathProgramTransition);
            set3.stream().filter(predicate2).forEach(this::createPathProgramTransition);
            CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
            ModifiableGlobalsTable modifiableGlobalsTable = this.constructModifiableGlobalsTable(cfgSmtToolkit.getModifiableGlobalsTable());
            if (IcfgUtils.isConcurrent(iIcfg)) {
                throw new UnsupportedOperationException("Construction of path programs is not yet supported for concurrent programs");
            }
            CfgSmtToolkit cfgSmtToolkit2 = new CfgSmtToolkit(modifiableGlobalsTable, cfgSmtToolkit.getManagedScript(), (IIcfgSymbolTable)this.mSymbolTable, this.mProcedures, cfgSmtToolkit.getInParams(), cfgSmtToolkit.getOutParams(), cfgSmtToolkit.getIcfgEdgeFactory(), null, cfgSmtToolkit.getSmtFunctionsAndAxioms());
            PathProgram pathProgram = new PathProgram(string2, cfgSmtToolkit2, this.mProgramPoints, this.mProcEntries, this.mProcExits, this.mProcError, this.mInitialNodes, this.mLoopLocations, this.mLocationsOfInterest);
            ModelUtils.copyAnnotations(iIcfg, (IElement)pathProgram);
            this.mResult = new PathProgramConstructionResult(pathProgram, this.mOldLoc2NewLoc, this.mOldTransition2NewTransition);
            assert (!this.mResult.getPathProgram().getInitialNodes().isEmpty()) : "You cannot have a path program that does not start at an initial location";
        }

        private PathProgramConstructionResult getResult() {
            return this.mResult;
        }

        private void createPathProgramTransition(IIcfgTransition<?> iIcfgTransition) {
            IcfgLocation icfgLocation = iIcfgTransition.getSource();
            IcfgLocation icfgLocation2 = iIcfgTransition.getTarget();
            IcfgLocation icfgLocation3 = this.addPathProgramLocation(icfgLocation);
            IcfgLocation icfgLocation4 = this.addPathProgramLocation(icfgLocation2);
            IcfgEdge icfgEdge = this.createPathProgramTransition(icfgLocation3, icfgLocation4, iIcfgTransition);
            if (iIcfgTransition instanceof IIcfgCallTransition) {
                this.mOldCall2NewCall.put(iIcfgTransition, (PathProgramCallAction)icfgEdge);
            }
            icfgEdge.redirectSource((IModifiableExplicitEdgesMultigraph)icfgLocation3);
            icfgEdge.redirectTarget((IModifiableExplicitEdgesMultigraph)icfgLocation4);
        }

        private IcfgEdge createPathProgramTransition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IIcfgTransition<?> iIcfgTransition) {
            PathProgramIcfgAction pathProgramIcfgAction;
            if (iIcfgTransition instanceof IIcfgCallTransition) {
                IIcfgCallTransition iIcfgCallTransition = (IIcfgCallTransition)iIcfgTransition;
                this.addVarsToSymboltable(iIcfgCallTransition.getLocalVarsAssignment(), iIcfgTransition);
                pathProgramIcfgAction = new PathProgramCallAction<IcfgEdge>(icfgLocation, icfgLocation2, (IcfgEdge)((ICallAction)iIcfgTransition));
            } else if (iIcfgTransition instanceof IIcfgInternalTransition) {
                IIcfgInternalTransition iIcfgInternalTransition = (IIcfgInternalTransition)iIcfgTransition;
                this.addVarsToSymboltable(iIcfgInternalTransition.getTransformula(), iIcfgTransition);
                pathProgramIcfgAction = new PathProgramInternalAction<IcfgEdge>(icfgLocation, icfgLocation2, (IcfgEdge)((IInternalAction)iIcfgTransition));
            } else if (iIcfgTransition instanceof IIcfgReturnTransition) {
                IIcfgReturnTransition iIcfgReturnTransition = (IIcfgReturnTransition)iIcfgTransition;
                this.addVarsToSymboltable(iIcfgReturnTransition.getAssignmentOfReturn(), iIcfgTransition);
                PathProgramCallAction<?> pathProgramCallAction = this.mOldCall2NewCall.get(iIcfgReturnTransition.getCorrespondingCall());
                pathProgramIcfgAction = new PathProgramReturnAction<IcfgEdge>(icfgLocation, icfgLocation2, pathProgramCallAction, (IcfgEdge)((IReturnAction)iIcfgTransition));
            } else {
                throw new UnsupportedOperationException("Cannot create path program transition for " + iIcfgTransition.getClass().getSimpleName());
            }
            this.mOldTransition2NewTransition.put(iIcfgTransition, (IIcfgTransition<?>)pathProgramIcfgAction);
            return pathProgramIcfgAction;
        }

        private void addVarsToSymboltable(UnmodifiableTransFormula unmodifiableTransFormula, IIcfgTransition<?> iIcfgTransition) {
            this.mProcedures.add(iIcfgTransition.getPrecedingProcedure());
            this.mProcedures.add(iIcfgTransition.getSucceedingProcedure());
            unmodifiableTransFormula.getInVars().keySet().stream().filter(iProgramVar -> !iProgramVar.isOldvar()).forEach(arg_0 -> ((DefaultIcfgSymbolTable)this.mSymbolTable).add(arg_0));
            unmodifiableTransFormula.getOutVars().keySet().stream().filter(iProgramVar -> !iProgramVar.isOldvar()).forEach(arg_0 -> ((DefaultIcfgSymbolTable)this.mSymbolTable).add(arg_0));
            unmodifiableTransFormula.getNonTheoryConsts().stream().forEach(arg_0 -> ((DefaultIcfgSymbolTable)this.mSymbolTable).add(arg_0));
        }

        private IcfgLocation createPathProgramLocation(IcfgLocation icfgLocation) {
            Objects.requireNonNull(icfgLocation, "ICFG location must not be null");
            IcfgLocation icfgLocation2 = this.mOldLoc2NewLoc.get(icfgLocation);
            if (icfgLocation2 == null) {
                PathProgramIcfgLocation pathProgramIcfgLocation = new PathProgramIcfgLocation(icfgLocation);
                this.mOldLoc2NewLoc.put(icfgLocation, pathProgramIcfgLocation);
                return pathProgramIcfgLocation;
            }
            return icfgLocation2;
        }

        private IcfgLocation addPathProgramLocation(IcfgLocation icfgLocation) {
            LinkedHashSet<IcfgLocation> linkedHashSet;
            Set<IcfgLocation> set;
            Set set2;
            IcfgLocation icfgLocation2;
            IcfgLocation icfgLocation3 = this.createPathProgramLocation(icfgLocation);
            String string = icfgLocation.getProcedure();
            IcfgLocation icfgLocation4 = (IcfgLocation)this.mOriginalIcfg.getProcedureEntryNodes().get(string);
            if (icfgLocation.equals((Object)icfgLocation4)) {
                this.mProcEntries.put(string, icfgLocation3);
            }
            if (icfgLocation.equals((Object)(icfgLocation2 = (IcfgLocation)this.mOriginalIcfg.getProcedureExitNodes().get(string)))) {
                this.mProcExits.put(string, icfgLocation3);
            }
            if ((set2 = (Set)this.mOriginalIcfg.getProcedureErrorNodes().get(string)) != null && set2.contains(icfgLocation)) {
                set = this.mProcError.get(string);
                if (set == null) {
                    linkedHashSet = new LinkedHashSet<IcfgLocation>();
                    this.mProcError.put(string, linkedHashSet);
                } else {
                    linkedHashSet = set;
                }
                linkedHashSet.add(icfgLocation3);
            }
            if ((set = this.mProgramPoints.get(string)) == null) {
                linkedHashSet = new LinkedHashMap<DebugIdentifier, IcfgLocation>();
                this.mProgramPoints.put(string, (Map<DebugIdentifier, IcfgLocation>)((Object)linkedHashSet));
            } else {
                linkedHashSet = set;
            }
            linkedHashSet.put((DebugIdentifier)icfgLocation3.getDebugIdentifier(), (IcfgLocation)icfgLocation3);
            if (this.mOriginalIcfg.getInitialNodes().contains(icfgLocation) || this.mAdditionalInitialNodes.contains(icfgLocation)) {
                this.mInitialNodes.add(icfgLocation3);
            }
            if (this.mOriginalIcfg.getLoopLocations().contains(icfgLocation) && this.mLoopLocationFilter.test(icfgLocation)) {
                this.mLoopLocations.add(icfgLocation3);
            }
            if (this.mOriginalIcfg.getLocationsOfInterest().contains(icfgLocation)) {
                this.mLocationsOfInterest.add(icfgLocation3);
            }
            return icfgLocation3;
        }

        private ModifiableGlobalsTable constructModifiableGlobalsTable(ModifiableGlobalsTable modifiableGlobalsTable) {
            HashRelation hashRelation = new HashRelation();
            Set set = this.mSymbolTable.getGlobals();
            for (String string : this.mProcedures) {
                Set set2 = modifiableGlobalsTable.getModifiedBoogieVars(string);
                for (IProgramNonOldVar iProgramNonOldVar : set2) {
                    if (!set.contains(iProgramNonOldVar)) continue;
                    hashRelation.addPair((Object)string, (Object)iProgramNonOldVar);
                }
            }
            return new ModifiableGlobalsTable(hashRelation);
        }
    }

    private static class PathProgramIcfgAction<T extends IcfgEdge>
    extends IcfgEdge {
        private static final long serialVersionUID = 1L;
        private final T mBacking;

        protected PathProgramIcfgAction(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, T t) {
            super(icfgLocation, icfgLocation2, null);
            this.mBacking = (IcfgEdge)Objects.requireNonNull(t, "Backing cannot be null");
        }

        public IPayload getPayload() {
            return this.mBacking.getPayload();
        }

        public boolean hasPayload() {
            return this.mBacking.hasPayload();
        }

        public IcfgEdge getLabel() {
            return this.mBacking;
        }

        public String getPrecedingProcedure() {
            return this.getBacking().getPrecedingProcedure();
        }

        public String getSucceedingProcedure() {
            return this.getBacking().getSucceedingProcedure();
        }

        public int hashCode() {
            return this.mBacking.hashCode();
        }

        protected T getBacking() {
            return this.mBacking;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != object.getClass()) {
                return false;
            }
            PathProgramIcfgAction pathProgramIcfgAction = (PathProgramIcfgAction)((Object)object);
            return this.mBacking.equals(pathProgramIcfgAction.mBacking);
        }

        public UnmodifiableTransFormula getTransformula() {
            return this.mBacking.getTransformula();
        }

        public String toString() {
            return this.mBacking.toString();
        }
    }

    private static final class PathProgramIcfgLocation
    extends IcfgLocation {
        private static final long serialVersionUID = 1L;
        private final IcfgLocation mBacking;

        protected PathProgramIcfgLocation(IcfgLocation icfgLocation) {
            super(icfgLocation.getDebugIdentifier(), icfgLocation.getProcedure());
            this.mBacking = Objects.requireNonNull(icfgLocation, "Backing cannot be null");
        }

        public IcfgLocation getLabel() {
            return this.mBacking;
        }

        public IPayload getPayload() {
            return this.mBacking.getPayload();
        }

        public boolean hasPayload() {
            return this.mBacking.hasPayload();
        }

        public int hashCode() {
            return this.mBacking.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != object.getClass()) {
                return false;
            }
            PathProgramIcfgLocation pathProgramIcfgLocation = (PathProgramIcfgLocation)((Object)object);
            return this.mBacking.equals((Object)pathProgramIcfgLocation.mBacking);
        }
    }

    private static final class PathProgramInternalAction<T extends IcfgEdge>
    extends PathProgramIcfgAction<T>
    implements IIcfgInternalTransition<IcfgLocation> {
        private static final long serialVersionUID = 1L;

        protected PathProgramInternalAction(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, T t) {
            super(icfgLocation, icfgLocation2, t);
        }

        @Override
        public UnmodifiableTransFormula getTransformula() {
            return this.getBacking().getTransformula();
        }
    }

    private static final class PathProgramReturnAction<T extends IcfgEdge>
    extends PathProgramIcfgAction<T>
    implements IIcfgReturnTransition<IcfgLocation, PathProgramCallAction<?>> {
        private static final long serialVersionUID = 1L;
        private final PathProgramCallAction<?> mCorrespondingCall;

        protected PathProgramReturnAction(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, PathProgramCallAction<?> pathProgramCallAction, T t) {
            super(icfgLocation, icfgLocation2, t);
            this.mCorrespondingCall = pathProgramCallAction;
        }

        public UnmodifiableTransFormula getAssignmentOfReturn() {
            return ((IReturnAction)this.getBacking()).getAssignmentOfReturn();
        }

        public UnmodifiableTransFormula getLocalVarsAssignmentOfCall() {
            return ((IReturnAction)this.getBacking()).getLocalVarsAssignmentOfCall();
        }

        public PathProgramCallAction<?> getCorrespondingCall() {
            return this.mCorrespondingCall;
        }
    }
}

