/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class TermNormalFormTransformer
implements INormalFormable<Term> {
    private final Script mScript;
    private final Term mTrue;
    private final Term mFalse;

    public TermNormalFormTransformer(Script script) {
        this.mScript = script;
        this.mTrue = this.mScript.term("true", new Term[0]);
        this.mFalse = this.mScript.term("false", new Term[0]);
    }

    public Term changeForall(Term term, Term term2) {
        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
        return this.mScript.quantifier(1, quantifiedFormula.getVariables(), term2, (Term[][])new Term[0][]);
    }

    public Term makeAnd(Term term, Term term2) {
        return this.mScript.term("and", new Term[]{term, term2});
    }

    public Term makeFalse() {
        return this.mFalse;
    }

    public Term makeTrue() {
        return this.mTrue;
    }

    public Term changeExists(Term term, Term term2) {
        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
        return this.mScript.quantifier(0, quantifiedFormula.getVariables(), term2, (Term[][])new Term[0][]);
    }

    public Term makeOr(Iterator<Term> iterator) {
        return this.mScript.term("or", TermNormalFormTransformer.toArray(iterator));
    }

    public Term makeAnd(Iterator<Term> iterator) {
        return this.mScript.term("and", TermNormalFormTransformer.toArray(iterator));
    }

    public Term makeNot(Term term) {
        return this.mScript.term("not", new Term[]{term});
    }

    public Term getOperand(Term term) {
        ApplicationTerm applicationTerm;
        if (term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getParameters().length == 1) {
            return applicationTerm.getParameters()[0];
        }
        if (term instanceof QuantifiedFormula) {
            applicationTerm = (QuantifiedFormula)term;
            return applicationTerm.getSubformula();
        }
        throw new IllegalArgumentException("Term " + String.valueOf(term) + " has no single operand");
    }

    public Collection<? extends Term> normalizeNesting(Term term, Term term2) {
        throw new UnsupportedOperationException();
    }

    public Term rewritePredNotEquals(Term term) {
        throw new UnsupportedOperationException();
    }

    public Term negatePred(Term term) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Term> getOperands(Term term) {
        throw new UnsupportedOperationException();
    }

    public boolean isAtom(Term term) {
        return term instanceof TermVariable || term instanceof ConstantTerm;
    }

    public boolean isLiteral(Term term) {
        ApplicationTerm applicationTerm;
        if (this.isAtom(term)) {
            return true;
        }
        if (term instanceof ApplicationTerm && "not".equals((applicationTerm = (ApplicationTerm)term).getFunction().getName())) {
            Term term2 = applicationTerm.getParameters()[0];
            return this.isAtom(term2);
        }
        return false;
    }

    public boolean isNot(Term term) {
        return TermNormalFormTransformer.isFunctionApplication(term, "not");
    }

    public boolean isAnd(Term term) {
        return TermNormalFormTransformer.isFunctionApplication(term, "and");
    }

    public boolean isOr(Term term) {
        return TermNormalFormTransformer.isFunctionApplication(term, "or");
    }

    public boolean isExists(Term term) {
        return TermNormalFormTransformer.isQuantifier(term, 0);
    }

    public boolean isForall(Term term) {
        return TermNormalFormTransformer.isQuantifier(term, 1);
    }

    public boolean isEqual(Term term, Term term2) {
        return Objects.equals(term, term2);
    }

    private static boolean isFunctionApplication(Term term, String string) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            return applicationTerm.getFunction().getName().equals(string);
        }
        return false;
    }

    private static boolean isQuantifier(Term term, int n) {
        if (term instanceof QuantifiedFormula) {
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
            return quantifiedFormula.getQuantifier() == n;
        }
        return false;
    }

    private static Term[] toArray(Iterator<Term> iterator) {
        ArrayList arrayList = new ArrayList();
        iterator.forEachRemaining(arrayList::add);
        Term[] termArray = arrayList.toArray(new Term[arrayList.size()]);
        return termArray;
    }

    public boolean isTrue(Term term) {
        return "true".equals(term.toString());
    }

    public boolean isFalse(Term term) {
        return "false".equals(term.toString());
    }
}

