/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public final class DataRaceAnnotation
extends ModernAnnotations {
    private static final long serialVersionUID = 1L;
    private static final String KEY = DataRaceAnnotation.class.getName();
    private final Set<Race> mRaces;

    private DataRaceAnnotation(Race race) {
        this(Set.of(race));
    }

    private DataRaceAnnotation(Set<Race> set) {
        this.mRaces = set;
    }

    public Set<Race> getRaces() {
        return Collections.unmodifiableSet(this.mRaces);
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations == null || iAnnotations == this) {
            return this;
        }
        if (iAnnotations instanceof DataRaceAnnotation) {
            return new DataRaceAnnotation(DataStructureUtils.union(this.mRaces, ((DataRaceAnnotation)iAnnotations).mRaces));
        }
        return super.merge(iAnnotations);
    }

    public static Race annotateAccess(IElement iElement, String string, ILocation iLocation, boolean bl) {
        Race race = new Race(bl, string, null, iLocation);
        iElement.getPayload().getAnnotations().put(KEY, new DataRaceAnnotation(race));
        return race;
    }

    public static void annotateCheck(IElement iElement, Race[] raceArray, ILocation iLocation) {
        boolean bl = raceArray[0].isWrite();
        String string = raceArray[0].mAccessPath;
        iElement.getPayload().getAnnotations().put(KEY, new DataRaceAnnotation(new Race(bl, string, raceArray, iLocation)));
    }

    public static DataRaceAnnotation getAnnotation(IElement iElement) {
        return (DataRaceAnnotation)ModelUtils.getAnnotation((IElement)iElement, (String)KEY, DataRaceAnnotation.class::cast);
    }

    public static final class Race {
        private final boolean mIsWrite;
        private final String mAccessPath;
        private final Set<Race> mTwinAccesses;
        private final ILocation mOriginalLocation;

        private Race(boolean bl, String string, Race[] raceArray, ILocation iLocation) {
            this.mIsWrite = bl;
            this.mAccessPath = string;
            this.mTwinAccesses = raceArray == null ? null : Set.of(raceArray);
            this.mOriginalLocation = iLocation;
        }

        public boolean isTwin(Race race) {
            if (this.isCheck()) {
                return this.mTwinAccesses.contains(race);
            }
            if (race.isCheck()) {
                return race.mTwinAccesses.contains(this);
            }
            return false;
        }

        public Optional<Boolean> isConflictingAccess(Race race) {
            if (!this.isCheck()) {
                throw new UnsupportedOperationException("Conflicting accesses can only be found for data race checks");
            }
            if (!this.isWrite() && !race.isWrite() || this.mTwinAccesses.contains(race)) {
                return Optional.of(false);
            }
            if (race.isCheck()) {
                return Optional.of(false);
            }
            if (this.isUndeterminedRace() || race.isUndeterminedRace()) {
                return Optional.empty();
            }
            return Optional.of(this.mAccessPath.startsWith(race.mAccessPath) || race.mAccessPath.startsWith(this.mAccessPath));
        }

        public String getVariable() {
            if (this.mAccessPath == null) {
                throw new IllegalStateException("heap race has no variable");
            }
            return this.mAccessPath;
        }

        public boolean isWrite() {
            return this.mIsWrite;
        }

        public boolean isCheck() {
            return this.mTwinAccesses != null;
        }

        public boolean isUndeterminedRace() {
            return this.mAccessPath == null;
        }

        public ILocation getOriginalLocation() {
            return this.mOriginalLocation;
        }
    }
}

