/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.DeclarableFunctionSymbol;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.HistoryRecordingScript;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.NonDeclaringTermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SmtFunctionsAndAxioms {
    public static final int HARDCODED_SERIALNUMBER_FOR_AXIOMS = 0;
    private final HistoryRecordingScript mScript;
    private final ManagedScript mMgdScript;
    private final IPredicate mAxioms;

    public SmtFunctionsAndAxioms(ManagedScript managedScript) {
        this(managedScript.getScript().term("true", new Term[0]), Collections.emptySet(), managedScript);
    }

    public SmtFunctionsAndAxioms(Term term, Set<IProgramFunction> set, ManagedScript managedScript) {
        this(new BasicPredicate(0, term, Collections.emptySet(), set, term), managedScript);
    }

    public SmtFunctionsAndAxioms(IPredicate iPredicate, ManagedScript managedScript) {
        this.mAxioms = Objects.requireNonNull(iPredicate);
        this.mMgdScript = managedScript;
        this.mScript = Objects.requireNonNull(HistoryRecordingScript.extractHistoryRecordingScript((Script)Objects.requireNonNull(managedScript.getScript())));
        assert (iPredicate.getClosedFormula() == iPredicate.getFormula()) : "Axioms are not closed";
        assert (iPredicate.getFormula().getFreeVars().length == 0) : "Axioms are not closed";
    }

    public SmtFunctionsAndAxioms addAxiom(Term term, IIcfgSymbolTable iIcfgSymbolTable) {
        Term term2 = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{this.mAxioms.getClosedFormula(), term});
        Script.LBool lBool = this.mScript.assertTerm(term);
        assert (lBool != Script.LBool.UNSAT) : "Axioms are inconsistent";
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns(term2, this.mMgdScript, iIcfgSymbolTable);
        BasicPredicate basicPredicate = new BasicPredicate(0, termVarsFuns.getFormula(), termVarsFuns.getVars(), termVarsFuns.getFuns(), termVarsFuns.getClosedFormula());
        return new SmtFunctionsAndAxioms(basicPredicate, this.mMgdScript);
    }

    public void transferAllSymbols(Script script) {
        HistoryRecordingScript.transferHistoryFromRecord((Script)this.mScript, (Script)script);
        NonDeclaringTermTransferrer nonDeclaringTermTransferrer = new NonDeclaringTermTransferrer(script);
        Term term = nonDeclaringTermTransferrer.transform(this.mAxioms.getClosedFormula());
        if (!SmtUtils.isTrueLiteral((Term)term)) {
            Script.LBool lBool = script.assertTerm(term);
            assert (lBool != Script.LBool.UNSAT) : "Axioms are inconsistent";
        }
    }

    public Term inline(Term term) {
        return new SmtFunctionInliner().inline(this.mMgdScript, term);
    }

    public IPredicate getAxioms() {
        return this.mAxioms;
    }

    public Map<String, DeclarableFunctionSymbol> getDefinedFunctions() {
        return this.mScript.getSymbolTable().entrySet().stream().filter(entry -> entry.getValue() instanceof DeclarableFunctionSymbol).map(entry -> (DeclarableFunctionSymbol)entry.getValue()).filter(declarableFunctionSymbol -> declarableFunctionSymbol.getDefinition() != null).collect(Collectors.toMap(DeclarableFunctionSymbol::getName, declarableFunctionSymbol -> declarableFunctionSymbol));
    }

    private static class SmtFunctionInliner
    extends TermTransformer {
        private ManagedScript mMgdScript;
        private HistoryRecordingScript mScript;

        private SmtFunctionInliner() {
        }

        public Term inline(ManagedScript managedScript, Term term) {
            this.mMgdScript = managedScript;
            this.mScript = HistoryRecordingScript.extractHistoryRecordingScript((Script)managedScript.getScript());
            if (this.mScript == null) {
                throw new IllegalArgumentException(String.valueOf(managedScript.getScript().getClass()) + " does not contain a " + String.valueOf(HistoryRecordingScript.class));
            }
            return this.transform(term);
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            String string = applicationTerm.getFunction().getName();
            ISmtDeclarable iSmtDeclarable = (ISmtDeclarable)this.mScript.getSymbolTable().get(string);
            if (iSmtDeclarable == null) {
                this.setResult(SmtUtils.convertApplicationTerm((ApplicationTerm)applicationTerm, (Term[])termArray, (Script)this.mScript));
                return;
            }
            assert (iSmtDeclarable instanceof DeclarableFunctionSymbol);
            DeclarableFunctionSymbol declarableFunctionSymbol = (DeclarableFunctionSymbol)iSmtDeclarable;
            Term term = declarableFunctionSymbol.getDefinition();
            if (term == null) {
                this.setResult(SmtUtils.convertApplicationTerm((ApplicationTerm)applicationTerm, (Term[])termArray, (Script)this.mScript));
                return;
            }
            if (applicationTerm.getParameters().length == 0) {
                this.setResult(term);
                return;
            }
            Term[] termArray2 = declarableFunctionSymbol.getParamVars();
            assert (termArray.length == termArray2.length);
            HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
            int n = 0;
            while (n < termArray2.length) {
                Term term2 = termArray2[n];
                if (term2 != null) {
                    hashMap.put(term2, termArray[n]);
                }
                ++n;
            }
            this.setResult(Substitution.apply((ManagedScript)this.mMgdScript, hashMap, (Term)term));
        }
    }
}

