/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class QuantifierOverapproximatingSolver
extends WrapperScript {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final Stack<Boolean> mOverapproxiamtionStack;
    private boolean mInUsatCoreMode;
    private Set<Term> mAdditionalUnsatCoreContent;

    public QuantifierOverapproximatingSolver(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, Script script) {
        super(script);
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = new ManagedScript(iUltimateServiceProvider, script);
        this.mOverapproxiamtionStack = new Stack();
        this.mOverapproxiamtionStack.push(false);
    }

    public void setOption(String string, Object object) throws UnsupportedOperationException, SMTLIBException {
        Boolean bl;
        if (string.equals(":produce-unsat-cores") && (bl = (Boolean)object).booleanValue()) {
            this.mInUsatCoreMode = true;
            assert (this.mAdditionalUnsatCoreContent == null);
            this.mAdditionalUnsatCoreContent = new HashSet<Term>();
        }
        this.mScript.setOption(string, object);
    }

    public void push(int n) throws SMTLIBException {
        int n2 = 0;
        while (n2 < n) {
            this.mOverapproxiamtionStack.push(false);
            ++n2;
        }
        this.mScript.push(n);
    }

    public void pop(int n) throws SMTLIBException {
        int n2 = 0;
        while (n2 < n) {
            this.mOverapproxiamtionStack.pop();
            ++n2;
        }
        this.mScript.pop(n);
    }

    private Term skolemizeOA(QuantifiedFormula quantifiedFormula) {
        QuantifierSequence quantifierSequence = new QuantifierSequence(this.mMgdScript, (Term)quantifiedFormula);
        QuantifierSequence.QuantifiedVariables quantifiedVariables = (QuantifierSequence.QuantifiedVariables)quantifierSequence.getQuantifierBlocks().get(0);
        Term term = quantifierSequence.getInnerTerm();
        int n = 0;
        while (n < quantifierSequence.getQuantifierBlocks().size()) {
            List list = quantifierSequence.getQuantifierBlocks();
            if (((QuantifierSequence.QuantifiedVariables)list.get(n)).getQuantifier() == 0 && n == 0) {
                HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
                for (TermVariable termVariable : quantifiedVariables.getVariables()) {
                    TermVariable termVariable2 = this.mMgdScript.constructFreshTermVariable("skolemconst", termVariable.getSort());
                    Term term2 = SmtUtils.termVariable2constant((Script)this.mMgdScript.getScript(), (TermVariable)termVariable2, (boolean)true);
                    hashMap.put(termVariable, term2);
                }
                term = Substitution.apply((ManagedScript)this.mMgdScript, hashMap, (Term)term);
            }
            ++n;
        }
        Term term3 = QuantifierSequence.prependQuantifierSequence((Script)this.mMgdScript.getScript(), (List)quantifierSequence.getQuantifierBlocks(), (Term)term);
        return term3;
    }

    private Term overApproximate(Term term) {
        Term term2 = new NnfTransformer(this.mMgdScript, this.mServices, NnfTransformer.QuantifierHandling.KEEP).transform(term);
        Term term3 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term2);
        Term term4 = this.mMgdScript.getScript().term("true", new Term[0]);
        Term[] termArray = SmtUtils.getConjuncts((Term)term3);
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term5;
            Term term6 = termArray[n2];
            if (!QuantifierUtils.isQuantifierFree((Term)term6) && !QuantifierUtils.isQuantifierFree((Term)(term5 = new PrenexNormalForm(this.mMgdScript).transform(term6)))) {
                Term term7 = this.skolemizeOA((QuantifiedFormula)term5);
                term6 = term7 instanceof QuantifiedFormula ? this.mMgdScript.getScript().term("true", new Term[0]) : term7;
            }
            term4 = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{term6, term4});
            ++n2;
        }
        return term4;
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        Script.LBool lBool;
        Term term2 = new FormulaUnLet().transform(term);
        if (!QuantifierUtils.isQuantifierFree((Term)term2)) {
            if (!this.mOverapproxiamtionStack.peek().booleanValue()) {
                this.mOverapproxiamtionStack.pop();
                this.mOverapproxiamtionStack.push(true);
            }
            term2 = this.overApproximate(term2);
        }
        if ((lBool = this.mScript.assertTerm(term2)).equals((Object)Script.LBool.SAT) && this.wasSomeAssertedTermOverapproximated()) {
            return Script.LBool.UNKNOWN;
        }
        return lBool;
    }

    private boolean wasSomeAssertedTermOverapproximated() {
        return this.mOverapproxiamtionStack.stream().anyMatch(bl -> bl);
    }

    public Script.LBool checkSat() throws SMTLIBException {
        Script.LBool lBool = this.mScript.checkSat();
        if (lBool.equals((Object)Script.LBool.SAT) && this.wasSomeAssertedTermOverapproximated()) {
            return Script.LBool.UNKNOWN;
        }
        if (this.mInUsatCoreMode && lBool.equals((Object)Script.LBool.UNSAT)) {
            Term[] termArray = this.getUnsatCore();
            this.mAdditionalUnsatCoreContent.addAll(Arrays.asList(termArray));
        }
        return lBool;
    }

    public boolean isInUsatCoreMode() {
        return this.mInUsatCoreMode;
    }

    public Set<Term> getAdditionalUnsatCoreContent() {
        return this.mAdditionalUnsatCoreContent;
    }
}

