/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.CopyingTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAcceleration;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;

public class JordanLoopAccelerationIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final IIcfg<INLOC> mOriginalIcfg;
    private final ITransformulaTransformer mTransformer;
    private final IUltimateServiceProvider mServices;
    private final IIcfg<OUTLOC> mResult;

    public JordanLoopAccelerationIcfgTransformer(ILogger iLogger, IIcfg<INLOC> iIcfg, Class<OUTLOC> clazz, ILocationFactory<INLOC, OUTLOC> iLocationFactory, String string, IcfgTransformationBacktranslator icfgTransformationBacktranslator, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mOriginalIcfg = iIcfg;
        this.mServices = iUltimateServiceProvider;
        this.mTransformer = new JordanLoopAccelerationTransformer(this.mLogger, iIcfg.getCfgSmtToolkit().getManagedScript(), iIcfg.getCfgSmtToolkit());
        this.mResult = new IcfgTransformer<INLOC, OUTLOC>(this.mLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, string, this.mTransformer).getResult();
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }

    private final class JordanLoopAccelerationTransformer
    extends CopyingTransformulaTransformer {
        public JordanLoopAccelerationTransformer(ILogger iLogger, ManagedScript managedScript, CfgSmtToolkit cfgSmtToolkit) {
            super(iLogger, managedScript, cfgSmtToolkit);
        }

        @Override
        public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> iIcfgTransition, UnmodifiableTransFormula unmodifiableTransFormula) {
            if (iIcfgTransition.getSource() == iIcfgTransition.getTarget()) {
                UnmodifiableTransFormula unmodifiableTransFormula2 = iIcfgTransition.getTransformula();
                JordanLoopAcceleration.JordanLoopAccelerationResult jordanLoopAccelerationResult = JordanLoopAcceleration.accelerateLoop(JordanLoopAccelerationIcfgTransformer.this.mServices, JordanLoopAccelerationIcfgTransformer.this.mOriginalIcfg.getCfgSmtToolkit().getManagedScript(), unmodifiableTransFormula2, true);
                JordanLoopAccelerationIcfgTransformer.this.mLogger.info((Object)("Jordan loop acceleration statistics: " + String.valueOf(jordanLoopAccelerationResult.getJordanLoopAccelerationStatistics())));
                if (jordanLoopAccelerationResult.getAccelerationStatus() == JordanLoopAcceleration.JordanLoopAccelerationResult.AccelerationStatus.SUCCESS) {
                    JordanLoopAccelerationIcfgTransformer.this.mLogger.info("Accelerated %s to %s", new Object[]{unmodifiableTransFormula2, jordanLoopAccelerationResult.getTransFormula()});
                    StatisticsData statisticsData = new StatisticsData();
                    statisticsData.aggregateBenchmarkData((IStatisticsDataProvider)jordanLoopAccelerationResult.getJordanLoopAccelerationStatistics());
                    JordanLoopAccelerationIcfgTransformer.this.mServices.getResultService().reportResult("IcfgTransformer", (IResult)new StatisticsResult("IcfgTransformer", "Jordan loop acceleration statistics", (ICsvProviderProvider)statisticsData));
                    return new ITransformulaTransformer.TransformulaTransformationResult(jordanLoopAccelerationResult.getTransFormula());
                }
                throw new IllegalArgumentException(String.valueOf((Object)jordanLoopAccelerationResult.getAccelerationStatus()) + " " + jordanLoopAccelerationResult.getErrorMessage());
            }
            return super.transform(iIcfgTransition, unmodifiableTransFormula);
        }
    }
}

