/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MultiDimensionalNestedStore
implements ITermProvider {
    private final Term mArray;
    private final List<ArrayIndex> mIndices;
    private final List<Term> mValues;

    public MultiDimensionalNestedStore(Term term, List<ArrayIndex> list, List<Term> list2) {
        this.mArray = term;
        this.mIndices = list;
        this.mValues = list2;
    }

    public MultiDimensionalNestedStore(MultiDimensionalStore multiDimensionalStore) {
        this.mArray = multiDimensionalStore.getArray();
        this.mIndices = Collections.singletonList(multiDimensionalStore.getIndex());
        this.mValues = Collections.singletonList(multiDimensionalStore.getValue());
    }

    public Term getArray() {
        return this.mArray;
    }

    public List<ArrayIndex> getIndices() {
        return this.mIndices;
    }

    public List<Term> getValues() {
        return this.mValues;
    }

    public int getDimension() {
        return this.mIndices.get(0).size();
    }

    @Override
    public Term toTerm(Script script) {
        Term term = this.mArray;
        int n = 0;
        while (n < this.mIndices.size()) {
            term = SmtUtils.multiDimensionalStore(script, term, this.mIndices.get(n), this.mValues.get(n));
            ++n;
        }
        return term;
    }

    public MultiDimensionalStore getInnermost() {
        return new MultiDimensionalStore(this.mArray, this.mIndices.get(0), this.mValues.get(0));
    }

    public MultiDimensionalStore extractDowngradeToHigherDimensions(Script script, int n) {
        assert (n >= 1 && n < this.getDimension());
        ArrayIndex arrayIndex = this.mIndices.get(0).getFirst(n);
        Term term = new MultiDimensionalSelect(this.mArray, arrayIndex).toTerm(script);
        ArrayList<ArrayIndex> arrayList = new ArrayList<ArrayIndex>();
        for (ArrayIndex list2 : this.mIndices) {
            ArrayIndex arrayIndex2 = list2.getFirst(n);
            if (!arrayIndex2.equals(arrayIndex)) break;
            ArrayIndex arrayIndex3 = list2.getLast(this.getDimension() - n);
            arrayList.add(arrayIndex3);
        }
        List<Term> list = this.mValues.stream().limit(arrayList.size()).collect(Collectors.toList());
        MultiDimensionalNestedStore multiDimensionalNestedStore = new MultiDimensionalNestedStore(term, arrayList, list);
        return new MultiDimensionalStore(this.mArray, arrayIndex, multiDimensionalNestedStore.toTerm(script));
    }

    public int hashCode() {
        return Objects.hash(this.mArray, this.mIndices, this.mValues);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalNestedStore multiDimensionalNestedStore = (MultiDimensionalNestedStore)object;
        if (this.mArray == null ? multiDimensionalNestedStore.mArray != null : !this.mArray.equals(multiDimensionalNestedStore.mArray)) {
            return false;
        }
        if (this.mIndices == null ? multiDimensionalNestedStore.mIndices != null : !this.mIndices.equals(multiDimensionalNestedStore.mIndices)) {
            return false;
        }
        return !(this.mValues == null ? multiDimensionalNestedStore.mValues != null : !this.mValues.equals(multiDimensionalNestedStore.mValues));
    }

    public static MultiDimensionalNestedStore of(Term term) {
        MultiDimensionalNestedStore multiDimensionalNestedStore = MultiDimensionalNestedStore.convert1mdseq(term);
        if (multiDimensionalNestedStore == null) {
            return null;
        }
        Term term2 = multiDimensionalNestedStore.getArray();
        MultiDimensionalNestedStore multiDimensionalNestedStore2 = MultiDimensionalNestedStore.convert1mdseq(term2);
        while (multiDimensionalNestedStore2 != null) {
            if (multiDimensionalNestedStore2.getDimension() != multiDimensionalNestedStore.getDimension()) {
                return multiDimensionalNestedStore;
            }
            term2 = multiDimensionalNestedStore2.getArray();
            multiDimensionalNestedStore = multiDimensionalNestedStore.addInnerSequence(multiDimensionalNestedStore2);
            multiDimensionalNestedStore2 = MultiDimensionalNestedStore.convert1mdseq(term2);
        }
        return multiDimensionalNestedStore;
    }

    private MultiDimensionalNestedStore addInnerSequence(MultiDimensionalNestedStore multiDimensionalNestedStore) {
        ArrayList<ArrayIndex> arrayList = new ArrayList<ArrayIndex>(multiDimensionalNestedStore.getIndices());
        arrayList.addAll(this.mIndices);
        ArrayList<Term> arrayList2 = new ArrayList<Term>(multiDimensionalNestedStore.getValues());
        arrayList2.addAll(this.mValues);
        MultiDimensionalNestedStore multiDimensionalNestedStore2 = new MultiDimensionalNestedStore(multiDimensionalNestedStore.getArray(), arrayList, arrayList2);
        return multiDimensionalNestedStore2;
    }

    private static MultiDimensionalNestedStore convert1mdseq(Term term) {
        ArrayStore arrayStore = ArrayStore.of(term);
        if (arrayStore == null) {
            return null;
        }
        Term term2 = arrayStore.getArray();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(arrayStore.getIndex());
        Term term3 = arrayStore.getValue();
        MultiDimensionalNestedStore multiDimensionalNestedStore = MultiDimensionalNestedStore.of(term3);
        while (multiDimensionalNestedStore != null && MultiDimensionalStore.isCompatibleSelect(multiDimensionalNestedStore.getArray(), term2, arrayList)) {
            if (multiDimensionalNestedStore.getDimension() == 1 && multiDimensionalNestedStore.getIndices().size() == 1) {
                assert (multiDimensionalNestedStore.getIndices().size() == 1);
                assert (multiDimensionalNestedStore.getIndices().get(0).size() == 1);
                arrayList.add(multiDimensionalNestedStore.getIndices().get(0).get(0));
                term3 = multiDimensionalNestedStore.getValues().get(0);
                multiDimensionalNestedStore = MultiDimensionalNestedStore.of(term3);
                continue;
            }
            MultiDimensionalNestedStore multiDimensionalNestedStore2 = multiDimensionalNestedStore.addDimensionsAtBeginning(term2, arrayList, term);
            return multiDimensionalNestedStore2;
        }
        MultiDimensionalStore multiDimensionalStore = new MultiDimensionalStore(term2, new ArrayIndex(arrayList), term3);
        return new MultiDimensionalNestedStore(multiDimensionalStore);
    }

    private MultiDimensionalNestedStore addDimensionsAtBeginning(Term term, List<Term> list, Term term2) {
        return new MultiDimensionalNestedStore(term, ArrayIndex.appendEntriesAtBeginning(this.mIndices, list), this.mValues);
    }

    public MultiDimensionalNestedStore removeOneIndex(int n) {
        List list = DataStructureUtils.copyAllButOne(this.mIndices, (int)n);
        List list2 = DataStructureUtils.copyAllButOne(this.mValues, (int)n);
        return new MultiDimensionalNestedStore(this.mArray, list, list2);
    }

    public MultiDimensionalNestedStore applySubstitution(ManagedScript managedScript, Map<? extends Term, ? extends Term> map) {
        Term term2 = Substitution.apply(managedScript, map, this.mArray);
        List<ArrayIndex> list = this.mIndices.stream().map(arrayIndex -> arrayIndex.applySubstitution(managedScript, map)).collect(Collectors.toList());
        List<Term> list2 = this.mValues.stream().map(term -> Substitution.apply(managedScript, map, term)).collect(Collectors.toList());
        return new MultiDimensionalNestedStore(term2, list, list2);
    }

    public String toString() {
        return String.format("(%s %s %s)", this.mArray, this.mIndices, this.mValues);
    }
}

