/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.IParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.aiger.AIGERFrontEnd;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dimacs.DIMACSParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusEnumerationScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib.SMTLIBParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ErrorCallback;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTLIB2Parser;
import java.util.ArrayDeque;

public final class Main {
    private Main() {
    }

    private static void usage() {
        System.err.println("USAGE: smtinterpol [OPTION]... [INPUTFILE]");
        System.err.println("If no INPUTFILE is given, stdin is used.");
        System.err.println("  -script <class>      Send the input to another Java class implementing Script.");
        System.err.println("  -ddfriendly          Exit with error code indicating problems (delta-debugger friendly).");
        System.err.println("  -no-success          Don't print success messages.");
        System.err.println("  -o <opt>=<value>     Set option :opt to value. The default value is true.");
        System.err.println("  -q                   Only print error messages.");
        System.err.println("  -w                   Don't print statistics and models.");
        System.err.println("  -v                   Print debugging messages.");
        System.err.println("  -t <num>             Set the timeout per check-sat call to <num> milliseconds.");
        System.err.println("  -l <num>             Set the reproducible resource limit per check-sat call to <num>.");
        System.err.println("  -r <num>             Use a different random seed.");
        System.err.println("  -smt2                Parse input as SMTLIB 2 script.");
        System.err.println("  -smt                 Parse input as SMTLIB 1 benchmark.");
        System.err.println("  -d                   Parse input as DIMACS benchmark.");
        System.err.println("  -version             Print version and exit.");
    }

    private static void version() {
        System.err.println("SMTInterpol 2.5-1381-g0e9bd0bf");
    }

    public static void main(String[] stringArray) throws Exception {
        Object object2;
        DefaultLogger defaultLogger = new DefaultLogger();
        OptionMap optionMap = new OptionMap(defaultLogger, true);
        ArrayDeque<Option> arrayDeque = new ArrayDeque<Option>();
        boolean bl = false;
        ErrorCallback errorCallback = null;
        IParser iParser = new SMTLIB2Parser();
        Object object3 = null;
        int n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            if (stringArray[n].equals("--")) {
                ++n;
                break;
            }
            if (stringArray[n].equals("-script") && n + 1 < stringArray.length) {
                if (!((String)(object2 = stringArray[++n])).contains(".")) {
                    object2 = "de.uni_freiburg.informatik.ultimate.smtinterpol.scripts." + (String)object2;
                }
                Class<?> object6 = Class.forName((String)object2);
                object3 = (Script)object6.newInstance();
            } else if (stringArray[n].equals("-ddfriendly")) {
                errorCallback = new ErrorCallback(){

                    @Override
                    public void notifyError(ErrorCallback.ErrorReason errorReason) {
                        System.exit(errorReason.ordinal() + 1);
                    }
                };
            } else if (stringArray[n].equals("-remus")) {
                bl = true;
            } else if (stringArray[n].equals("-no-success")) {
                arrayDeque.add(new Option(":print-success", false));
            } else if (stringArray[n].equals("-v")) {
                arrayDeque.add(new Option(":verbosity", 5));
            } else if (stringArray[n].equals("-w")) {
                arrayDeque.add(new Option(":verbosity", 3));
            } else if (stringArray[n].equals("-q")) {
                arrayDeque.add(new Option(":verbosity", 2));
            } else if (stringArray[n].equals("-t") && ++n < stringArray.length) {
                arrayDeque.add(new Option(":timeout", stringArray[n]));
            } else if (stringArray[n].equals("-l") && ++n < stringArray.length) {
                arrayDeque.add(new Option(":reproducible-resource-limit", stringArray[n]));
            } else if (stringArray[n].equals("-r") && ++n < stringArray.length) {
                arrayDeque.add(new Option(":random-seed", stringArray[n]));
            } else if (stringArray[n].equals("-o") && n + 1 < stringArray.length) {
                Object object;
                Object object4;
                int n2;
                if ((n2 = ((String)(object2 = stringArray[++n])).indexOf(61)) == -1) {
                    object4 = object2;
                    object = Boolean.TRUE;
                } else {
                    object4 = ((String)object2).substring(0, n2);
                    object = ((String)object2).substring(n2 + 1);
                }
                try {
                    arrayDeque.add(new Option(":" + (String)object4, object));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    System.err.println("Unknown option :" + (String)object4 + ".");
                    return;
                }
                catch (SMTLIBException sMTLIBException) {
                    System.err.println(sMTLIBException.getMessage());
                    return;
                }
            } else if (stringArray[n].equals("-smt2")) {
                iParser = new SMTLIB2Parser();
            } else if (stringArray[n].equals("-smt")) {
                iParser = new SMTLIBParser();
            } else if (stringArray[n].equals("-d")) {
                iParser = new DIMACSParser();
            } else if (stringArray[n].equals("-a")) {
                iParser = new AIGERFrontEnd();
            } else if (stringArray[n].equals("-trace")) {
                arrayDeque.add(new Option(":verbosity", 6));
            } else {
                if (stringArray[n].equals("-version")) {
                    Main.version();
                    return;
                }
                Main.usage();
                return;
            }
            ++n;
        }
        object2 = null;
        if (n < stringArray.length) {
            object2 = stringArray[n++];
        }
        if (n != stringArray.length) {
            Main.usage();
            return;
        }
        if (object3 == null) {
            SMTInterpol n3 = new SMTInterpol(null, optionMap);
            n3.setErrorCallback(errorCallback);
            object3 = n3;
            if (bl) {
                object3 = new MusEnumerationScript(n3);
            }
        }
        for (Option option : arrayDeque) {
            object3.setOption(option.getName(), option.getValue());
        }
        optionMap.started();
        int n2 = iParser.run((Script)object3, (String)object2, optionMap);
        System.exit(n2);
    }

    private static class Option {
        String mName;
        Object mValue;

        public Option(String string, Object object) {
            this.mName = string;
            this.mValue = object;
        }

        public String getName() {
            return this.mName;
        }

        public Object getValue() {
            return this.mValue;
        }
    }
}

