/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import java.util.List;

class InstClause {
    protected final QuantClause mQuantClause;
    protected final List<Term> mSubs;
    protected final List<Literal> mLits;
    protected int mNumUndefLits;
    protected QuantifierTheory.InstanceOrigin mOrigin;
    private Term mInstClauseTerm;

    InstClause(QuantClause quantClause, List<Term> list, List<Literal> list2, int n, QuantifierTheory.InstanceOrigin instanceOrigin, Term term) {
        this.mQuantClause = quantClause;
        this.mSubs = list;
        this.mLits = list2;
        this.mNumUndefLits = n;
        this.mOrigin = instanceOrigin;
        this.mInstClauseTerm = term;
    }

    public int hashCode() {
        return this.mLits.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof InstClause) {
            return this.mLits.equals(((InstClause)object).mLits);
        }
        return false;
    }

    public String toString() {
        return this.mLits.toString();
    }

    boolean isConflict() {
        return this.mNumUndefLits == 0;
    }

    boolean isUnit() {
        return this.mNumUndefLits == 1;
    }

    int countAndSetUndefLits() {
        int n = 0;
        for (Literal literal : this.mLits) {
            if (literal.getAtom().getDecideStatus() == literal) {
                this.mNumUndefLits = -1;
                return -1;
            }
            if (literal.getAtom().getDecideStatus() != null) continue;
            ++n;
        }
        this.mNumUndefLits = n;
        return n;
    }

    Clause toClause(boolean bl) {
        Clause clause = new Clause(this.mLits.toArray(new Literal[this.mLits.size()]), this.mQuantClause.getQuantTheory().getEngine().getAssertionStackLevel());
        if (bl) {
            clause.setProof(new LeafNode(-2, new QuantAnnotation(this.mQuantClause, this.mSubs, this.mInstClauseTerm, this.mOrigin)));
        }
        return clause;
    }
}

