/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.DataRaceFoundResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.LassoShapedNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.BacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.IOutput;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithFiniteTrace;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgGraphProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.witnessprinter.Activator;
import de.uni_freiburg.informatik.ultimate.witnessprinter.RCFGCatcher;
import de.uni_freiburg.informatik.ultimate.witnessprinter.WitnessManager;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GraphMLCorrectnessWitnessGenerator;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GraphMLViolationWitnessGenerator;
import de.uni_freiburg.informatik.ultimate.witnessprinter.preferences.PreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.YamlCorrectnessWitnessGenerator;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.YamlViolationWitnessGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class WitnessPrinter
implements IOutput {
    private static final String GRAPHML = ".graphml";
    private static final String YAML = ".yml";
    private ILogger mLogger;
    private IUltimateServiceProvider mServices;
    private RCFGCatcher mRCFGCatcher;
    private boolean mMatchingModel;

    public boolean isGuiRequired() {
        return false;
    }

    public ITool.ModelQuery getModelQuery() {
        return ITool.ModelQuery.ALL;
    }

    public List<String> getDesiredToolIds() {
        return Collections.emptyList();
    }

    public void setInputDefinition(ModelType modelType) {
        this.mMatchingModel = "de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder".equals(modelType.getCreator()) || "de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder".equals(modelType.getCreator());
    }

    public List<IObserver> getObservers() {
        if (this.mMatchingModel) {
            this.mRCFGCatcher = new RCFGCatcher();
            return Collections.singletonList(this.mRCFGCatcher);
        }
        return Collections.emptyList();
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public void init() {
    }

    public void finish() {
        List<ResultWitness> list;
        List<IResult> list2 = this.mServices.getResultService().getResults().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        boolean bl = iPreferenceProvider.getBoolean("Generate GraphML witnesses");
        boolean bl2 = iPreferenceProvider.getBoolean("Generate YAML witnesses");
        if (list2.stream().anyMatch(iResult -> iResult instanceof CounterExampleResult) || list2.stream().anyMatch(iResult -> iResult instanceof DataRaceFoundResult)) {
            this.mLogger.info((Object)"Generating witness for reachability counterexample");
            list = this.generateReachabilityCounterexampleWitness(list2, bl, bl2);
        } else if (list2.stream().anyMatch(iResult -> iResult instanceof LassoShapedNonTerminationArgument)) {
            this.mLogger.info("Generating witness for non-termination counterexample", new Object[]{bl, bl2});
            list = this.generateNonTerminationWitness(list2, bl, bl2);
        } else if (list2.stream().anyMatch(iResult -> iResult instanceof AllSpecificationsHoldResult)) {
            this.mLogger.info((Object)"Generating witness for correct program");
            list = this.generateProofWitness(list2, bl, bl2);
        } else {
            this.mLogger.info((Object)"No result that supports witness generation found");
            list = List.of();
        }
        try {
            new WitnessManager(this.mLogger, this.mServices).run(list);
        }
        catch (IOException | InterruptedException exception) {
            throw new RuntimeException(exception);
        }
    }

    private List<ResultWitness> generateProofWitness(List<IResult> list, boolean bl, boolean bl2) {
        AllSpecificationsHoldResult allSpecificationsHoldResult = ResultUtil.filterResults(list, AllSpecificationsHoldResult.class).stream().findFirst().orElse(null);
        IBacktranslationService iBacktranslationService = this.mServices.getBacktranslationService();
        BoogieIcfgContainer boogieIcfgContainer = this.mRCFGCatcher.getModel();
        String string = ILocation.getAnnotation((IElement)boogieIcfgContainer).getFileName();
        ArrayList<ResultWitness> arrayList = new ArrayList<ResultWitness>();
        if (bl) {
            BacktranslatedCFG backtranslatedCFG = new BacktranslatedCFG(string, IcfgGraphProvider.getVirtualRoot((IIcfg)boogieIcfgContainer), IcfgEdge.class);
            IBacktranslatedCFG iBacktranslatedCFG = iBacktranslationService.translateCFG((IBacktranslatedCFG)backtranslatedCFG);
            arrayList.add(new ResultWitness(string, GRAPHML, new GraphMLCorrectnessWitnessGenerator(iBacktranslatedCFG, this.mLogger, this.mServices).makeGraphMLString(), (IResult)allSpecificationsHoldResult));
        }
        if (bl2) {
            arrayList.add(new ResultWitness(string, YAML, new YamlCorrectnessWitnessGenerator((IIcfg<? extends IcfgLocation>)boogieIcfgContainer, this.mLogger, this.mServices).makeYamlString(), (IResult)allSpecificationsHoldResult));
        }
        return arrayList;
    }

    private List<ResultWitness> generateReachabilityCounterexampleWitness(List<IResult> list, boolean bl, boolean bl2) {
        ArrayList<ResultWitness> arrayList = new ArrayList<ResultWitness>();
        Collection collection = ResultUtil.filterResults(list, iResult -> iResult instanceof CounterExampleResult || iResult instanceof DataRaceFoundResult).stream().map(IResultWithFiniteTrace.class::cast).collect(Collectors.toList());
        IBacktranslationService iBacktranslationService = this.mServices.getBacktranslationService();
        BoogieIcfgContainer boogieIcfgContainer = this.mRCFGCatcher.getModel();
        String string = ILocation.getAnnotation((IElement)boogieIcfgContainer).getFileName();
        for (IResultWithFiniteTrace iResultWithFiniteTrace : collection) {
            String string2;
            IProgramExecution iProgramExecution = iBacktranslationService.translateProgramExecution(iResultWithFiniteTrace.getProgramExecution());
            if (bl) {
                string2 = new GraphMLViolationWitnessGenerator(iProgramExecution, this.mLogger, this.mServices).makeGraphMLString();
                arrayList.add(new ResultWitness(string, GRAPHML, string2, (IResult)iResultWithFiniteTrace));
            }
            if (!bl2) continue;
            string2 = new YamlViolationWitnessGenerator(iProgramExecution, this.mLogger, this.mServices).makeYamlString();
            arrayList.add(new ResultWitness(string, YAML, string2, (IResult)iResultWithFiniteTrace));
        }
        return arrayList;
    }

    private List<ResultWitness> generateNonTerminationWitness(List<IResult> list, boolean bl, boolean bl2) {
        ArrayList<ResultWitness> arrayList = new ArrayList<ResultWitness>();
        Collection collection = ResultUtil.filterResults(list, LassoShapedNonTerminationArgument.class);
        IBacktranslationService iBacktranslationService = this.mServices.getBacktranslationService();
        BoogieIcfgContainer boogieIcfgContainer = this.mRCFGCatcher.getModel();
        String string = ILocation.getAnnotation((IElement)boogieIcfgContainer).getFileName();
        for (LassoShapedNonTerminationArgument lassoShapedNonTerminationArgument : collection) {
            if (!bl) continue;
            String string2 = this.getWitness(iBacktranslationService, lassoShapedNonTerminationArgument);
            arrayList.add(new ResultWitness(string, GRAPHML, string2, (IResult)lassoShapedNonTerminationArgument));
        }
        return arrayList;
    }

    private <TE, T, STE extends IElement, ST> String getWitness(IBacktranslationService iBacktranslationService, LassoShapedNonTerminationArgument<STE, ST> lassoShapedNonTerminationArgument) {
        IBacktranslationService.Lasso lasso = iBacktranslationService.translateLassoProgramExecution(new IBacktranslationService.Lasso(lassoShapedNonTerminationArgument.getStemExecution(), lassoShapedNonTerminationArgument.getLoopExecution()));
        IProgramExecution iProgramExecution = lasso.stem();
        IProgramExecution iProgramExecution2 = lasso.loop();
        return new GraphMLViolationWitnessGenerator(iProgramExecution, iProgramExecution2, this.mLogger, this.mServices).makeGraphMLString();
    }

    public String getPluginName() {
        return "Witness Printer";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public IPreferenceInitializer getPreferences() {
        return new PreferenceInitializer();
    }

    public static class ResultWitness {
        private final String mSourceFile;
        private final String mWitnessEnding;
        private final String mWitnessString;
        private final IResult mResult;

        public ResultWitness(String string, String string2, String string3, IResult iResult) {
            this.mSourceFile = string;
            this.mWitnessEnding = string2;
            this.mWitnessString = string3;
            this.mResult = iResult;
        }

        public String getSourceFile() {
            return this.mSourceFile;
        }

        public String getWitnessEnding() {
            return this.mWitnessEnding;
        }

        public String getWitnessString() {
            return this.mWitnessString;
        }

        public IResult getResult() {
            return this.mResult;
        }
    }
}

