/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Objects;
import java.util.Set;

public abstract class AnnotatedPredicate<P extends IPredicate, A>
implements IPredicate {
    protected final P mUnderlying;
    protected final A mAnnotation;

    protected AnnotatedPredicate(P p, A a) {
        this.mUnderlying = (IPredicate)Objects.requireNonNull(p);
        this.mAnnotation = a;
    }

    @Override
    public Set<IProgramVar> getVars() {
        return this.mUnderlying.getVars();
    }

    @Override
    public Set<IProgramFunction> getFuns() {
        return this.mUnderlying.getFuns();
    }

    @Override
    public Term getFormula() {
        return this.mUnderlying.getFormula();
    }

    @Override
    public Term getClosedFormula() {
        return this.mUnderlying.getClosedFormula();
    }

    public P getUnderlying() {
        return this.mUnderlying;
    }

    public int hashCode() {
        return Objects.hash(this.mAnnotation, this.mUnderlying);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AnnotatedPredicate annotatedPredicate = (AnnotatedPredicate)object;
        return Objects.equals(this.mAnnotation, annotatedPredicate.mAnnotation) && Objects.equals(this.mUnderlying, annotatedPredicate.mUnderlying);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [underlying: " + String.valueOf(this.mUnderlying) + ", annotation: " + String.valueOf(this.mAnnotation) + "]";
    }
}

