/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.alternating;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DnfAsBitSetList {
    private BitSet mAlpha;
    private final BitSet mBeta;
    private DnfAsBitSetList mNext;

    public DnfAsBitSetList(BitSet bitSet, BitSet bitSet2, DnfAsBitSetList dnfAsBitSetList) {
        this.mAlpha = bitSet;
        this.mBeta = bitSet2;
        this.mNext = dnfAsBitSetList;
    }

    public DnfAsBitSetList(DnfAsBitSetList dnfAsBitSetList) {
        this((BitSet)dnfAsBitSetList.mAlpha.clone(), (BitSet)dnfAsBitSetList.mBeta.clone(), null);
        DnfAsBitSetList dnfAsBitSetList2 = dnfAsBitSetList.mNext;
        while (dnfAsBitSetList2 != null) {
            this.insert(new DnfAsBitSetList((BitSet)dnfAsBitSetList2.mAlpha.clone(), (BitSet)dnfAsBitSetList2.mBeta.clone(), null));
            dnfAsBitSetList2 = dnfAsBitSetList2.mNext;
        }
    }

    public final void insert(DnfAsBitSetList dnfAsBitSetList) {
        if (this.mNext == null) {
            this.mNext = dnfAsBitSetList;
        } else {
            this.mNext.insert(dnfAsBitSetList);
        }
    }

    public <STATE> DnfAsBitSetList rewriteWithNewStateList(ArrayList<STATE> arrayList, Map<STATE, Integer> map) {
        DnfAsBitSetList dnfAsBitSetList = new DnfAsBitSetList(this);
        do {
            dnfAsBitSetList.mAlpha = DnfAsBitSetList.rewriteBitSet(this.mAlpha, arrayList, map);
        } while ((dnfAsBitSetList = dnfAsBitSetList.mNext) != null);
        return null;
    }

    private static <STATE> BitSet rewriteBitSet(BitSet bitSet, ArrayList<STATE> arrayList, Map<STATE, Integer> map) {
        BitSet bitSet2 = new BitSet();
        int n = bitSet.nextSetBit(0);
        while (n != -1) {
            bitSet2.set(map.get(arrayList.get(n)));
            n = bitSet.nextSetBit(n + 1);
        }
        return bitSet2;
    }

    public <STATE> void prettyPrintDnf(StringBuilder stringBuilder, List<STATE> list) {
        if (stringBuilder.length() == 0) {
            stringBuilder.append(" \\/ (");
        }
        String string = "";
        Iterator<STATE> iterator = list.iterator();
        int n = 0;
        while (n < list.size()) {
            STATE STATE = iterator.next();
            if (!this.mAlpha.isEmpty() && n == 0) {
                stringBuilder.append(" /\\ {");
            }
            boolean bl = this.mAlpha.get(n);
            boolean bl2 = this.mBeta.get(n);
            if (bl) {
                if (!bl2) {
                    stringBuilder.append(" not");
                }
                stringBuilder.append(string);
                stringBuilder.append(STATE);
                string = ", ";
            }
            if (!this.mAlpha.isEmpty() && n == list.size() - 1) {
                stringBuilder.append("}, ");
            }
            ++n;
        }
        if (this.mNext == null) {
            stringBuilder.append(")\n");
        } else {
            this.mNext.prettyPrintDnf(stringBuilder, list);
        }
    }

    public boolean applyTo(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.mAlpha.clone();
        bitSet2.and(bitSet);
        bitSet2.xor(this.mBeta);
        if (bitSet2.isEmpty()) {
            return true;
        }
        if (this.mNext == null) {
            return false;
        }
        return this.mNext.applyTo(bitSet);
    }
}

