/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.petruchio;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.IdentityHashMap;
import java.util.Map;
import petruchio.interfaces.petrinet.Place;
import petruchio.interfaces.petrinet.Transition;
import petruchio.pn.Converter;
import petruchio.pn.PetriNet;

public class PetruchioWrapper<LETTER, PLACE> {
    private final ILogger mLogger;
    private final BoundedPetriNet<LETTER, PLACE> mBoundedNet;
    private final PetriNet mNetPetruchio = new PetriNet();
    private final Map<PLACE, Place> mPBounded2pPetruchio = new IdentityHashMap<PLACE, Place>();
    private final Map<Transition, de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition<LETTER, PLACE>> mTPetruchio2tBounded = new IdentityHashMap<Transition, de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition<LETTER, PLACE>>();

    public PetruchioWrapper(AutomataLibraryServices automataLibraryServices, BoundedPetriNet<LETTER, PLACE> boundedPetriNet) {
        this.mLogger = automataLibraryServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mBoundedNet = boundedPetriNet;
        this.constructNetPetruchio();
    }

    private void constructNetPetruchio() {
        Transition transition;
        for (PLACE PLACE : this.mBoundedNet.getPlaces()) {
            Object object = "";
            PLACE PLACE2 = PLACE;
            object = (String)object + String.valueOf(PLACE2);
            object = (String)object + String.valueOf(PLACE2.hashCode());
            transition = this.mNetPetruchio.addPlace((String)object, this.mBoundedNet.getInitialPlaces().contains(PLACE) ? 1 : 0);
            transition.setBound(1);
            this.mPBounded2pPetruchio.put(PLACE, (Place)transition);
        }
        for (de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition transition2 : this.mBoundedNet.getTransitions()) {
            transition = this.mNetPetruchio.addTransition(transition2.toString());
            this.mTPetruchio2tBounded.put(transition, transition2);
            for (Object object : transition2.getSuccessors()) {
                this.mNetPetruchio.addArc(transition, this.mPBounded2pPetruchio.get(object), 1);
            }
            for (Object object : transition2.getPredecessors()) {
                this.mNetPetruchio.addArc(this.mPBounded2pPetruchio.get(object), transition, 1);
            }
        }
    }

    public void writeToFile(String string) {
        this.mLogger.debug((Object)("Writing net to file " + string));
        Converter.writeNet((petruchio.interfaces.petrinet.PetriNet)this.mNetPetruchio, (String)string);
        this.mLogger.info((Object)("Accepting places: " + String.valueOf(this.mBoundedNet.getAcceptingPlaces())));
    }

    public Map<PLACE, Place> getpBounded2pPetruchio() {
        return this.mPBounded2pPetruchio;
    }

    public Map<Transition, de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition<LETTER, PLACE>> gettPetruchio2tBounded() {
        return this.mTPetruchio2tBounded;
    }

    public PetriNet getNet() {
        return this.mNetPetruchio;
    }
}

