/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BaseMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopEntryAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.util.DfsBookkeeping;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IcfgUtils {
    private IcfgUtils() {
    }

    public static <LOC extends IcfgLocation> Set<LOC> getPotentialCycleProgramPoints(IIcfg<LOC> iIcfg) {
        return new IcfgLocationIterator<LOC>(iIcfg).asStream().filter(icfgLocation -> icfgLocation.getOutgoingEdges().stream().anyMatch(icfgEdge -> {
            LoopEntryAnnotation loopEntryAnnotation = LoopEntryAnnotation.getAnnotation((IElement)icfgEdge);
            return loopEntryAnnotation != null && loopEntryAnnotation.getLoopEntryType() == LoopEntryAnnotation.LoopEntryType.GOTO;
        })).collect(Collectors.toSet());
    }

    public static <LOC extends IcfgLocation> Set<LOC> getCallerAndCalleePoints(IIcfg<LOC> iIcfg) {
        return new IcfgEdgeIterator(iIcfg).asStream().filter(IIcfgCallTransition.class::isInstance).flatMap(icfgEdge -> Stream.of((IcfgLocation)icfgEdge.getSource(), (IcfgLocation)icfgEdge.getTarget())).collect(Collectors.toSet());
    }

    public static <LOC extends IcfgLocation> Set<LOC> getReturnPredecessorPoints(IIcfg<LOC> iIcfg) {
        return new IcfgEdgeIterator(iIcfg).asStream().filter(IIcfgReturnTransition.class::isInstance).map(icfgEdge -> (IcfgLocation)icfgEdge.getSource()).collect(Collectors.toSet());
    }

    public static boolean isConcurrent(IIcfg<?> iIcfg) {
        return !iIcfg.getCfgSmtToolkit().getConcurrencyInformation().getThreadInstanceMap().isEmpty();
    }

    public static <LOC extends IcfgLocation> List<IcfgEdge> extractStartEdges(IIcfg<LOC> iIcfg) {
        return iIcfg.getInitialNodes().stream().flatMap(icfgLocation -> icfgLocation.getOutgoingEdges().stream()).collect(Collectors.toList());
    }

    public static <LOC extends IcfgLocation> Set<LOC> getErrorLocations(IIcfg<LOC> iIcfg) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Map.Entry<String, Set<LOC>> entry : iIcfg.getProcedureErrorNodes().entrySet()) {
            linkedHashSet.addAll(entry.getValue());
        }
        return linkedHashSet;
    }

    public static <LOC extends IcfgLocation> boolean isErrorLocation(IIcfg<LOC> iIcfg, IcfgLocation icfgLocation) {
        if (iIcfg == null) {
            throw new IllegalArgumentException();
        }
        if (icfgLocation == null) {
            return false;
        }
        String string = icfgLocation.getProcedure();
        Map<String, Set<LOC>> map = iIcfg.getProcedureErrorNodes();
        if (map == null || map.isEmpty()) {
            return false;
        }
        Set<LOC> set = map.get(string);
        if (set == null || set.isEmpty()) {
            return false;
        }
        return set.contains(icfgLocation);
    }

    public static <LOC extends IcfgLocation> Stream<LOC> getAllLocations(IIcfg<LOC> iIcfg) {
        return iIcfg.getProgramPoints().values().stream().flatMap(map -> map.values().stream());
    }

    public static <LOC extends IcfgLocation> int getNumberOfLocations(IIcfg<LOC> iIcfg) {
        return iIcfg.getProgramPoints().values().stream().mapToInt(Map::size).sum();
    }

    public static int getNumberOfEdges(IIcfg<?> iIcfg) {
        return IcfgUtils.getAllLocations(iIcfg).mapToInt(icfgLocation -> icfgLocation.getOutgoingEdges().size()).sum();
    }

    public static <LOC extends IcfgLocation> int countNumberOfEdges(IIcfg<LOC> iIcfg) {
        return IcfgUtils.getAllLocations(iIcfg).map(icfgLocation -> icfgLocation.getOutgoingEdges().size()).collect(Collectors.summingInt(Integer::intValue));
    }

    public static Set<IProgramVar> collectAllProgramVars(CfgSmtToolkit cfgSmtToolkit) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (IProgramNonOldVar object : cfgSmtToolkit.getSymbolTable().getGlobals()) {
            hashSet.add(object);
            IProgramOldVar iProgramOldVar = object.getOldVar();
            hashSet.add(iProgramOldVar);
        }
        for (String string : cfgSmtToolkit.getProcedures()) {
            hashSet.addAll(cfgSmtToolkit.getSymbolTable().getLocals(string));
        }
        return hashSet;
    }

    public static <LOC extends IcfgLocation> int computeIcfgHashCode(IIcfg<LOC> iIcfg) {
        IcfgLocationIterator<LOC> icfgLocationIterator = new IcfgLocationIterator<LOC>(iIcfg);
        int n = 0;
        while (icfgLocationIterator.hasNext()) {
            Object object = icfgLocationIterator.next();
            n = HashUtils.hashHsieh((int)n, (Object)((IcfgLocation)object).hashCode());
            for (IcfgEdge icfgEdge : object.getOutgoingEdges()) {
                n = HashUtils.hashHsieh((int)n, (Object)icfgEdge.hashCode());
            }
        }
        return n;
    }

    public static <LOC extends IcfgLocation> boolean areReachableProgramPointsRegistered(IIcfg<LOC> iIcfg) {
        Set set = new IcfgEdgeIterator(iIcfg).asStream().map(BaseMultigraphEdge::getTarget).collect(Collectors.toSet());
        set.addAll(iIcfg.getInitialNodes());
        Set set2 = IcfgUtils.getAllLocations(iIcfg).collect(Collectors.toSet());
        Set set3 = DataStructureUtils.difference(set, set2);
        if (!set3.isEmpty()) {
            throw new AssertionError((Object)("Program points reachable but not registered: " + String.valueOf(set3)));
        }
        return true;
    }

    public static <LOC extends IcfgLocation> boolean areRegisteredProgramPointsReachable(IIcfg<LOC> iIcfg) {
        Set set = new IcfgEdgeIterator(iIcfg).asStream().map(BaseMultigraphEdge::getTarget).collect(Collectors.toSet());
        set.addAll(iIcfg.getInitialNodes());
        Set set2 = IcfgUtils.getAllLocations(iIcfg).collect(Collectors.toSet());
        Set set3 = DataStructureUtils.difference(set2, set);
        Set set4 = iIcfg.getProcedureExitNodes().values().stream().collect(Collectors.toSet());
        set3.removeAll(set4);
        if (!set3.isEmpty()) {
            throw new AssertionError((Object)("Program points registered but not reachable: " + String.valueOf(set3)));
        }
        return true;
    }

    public static <LOC extends IcfgLocation> boolean areLocationsOfInterestRegistered(IIcfg<LOC> iIcfg) {
        Set set = IcfgUtils.getAllLocations(iIcfg).collect(Collectors.toSet());
        Set set2 = DataStructureUtils.difference(iIcfg.getLocationsOfInterest(), set);
        if (!set2.isEmpty()) {
            throw new AssertionError((Object)("Unregistered location of interest (LOI): " + String.valueOf(set2)));
        }
        return true;
    }

    public static <LOC extends IcfgLocation> boolean areLoopLocationsRegistered(IIcfg<LOC> iIcfg) {
        Set set = IcfgUtils.getAllLocations(iIcfg).collect(Collectors.toSet());
        Set set2 = DataStructureUtils.difference(iIcfg.getLoopLocations(), set);
        if (!set2.isEmpty()) {
            throw new AssertionError((Object)("Unregistered loop location: " + String.valueOf(set2)));
        }
        return true;
    }

    public static <LOC extends IcfgLocation> boolean checkMatchingEntryExitNodes(IIcfg<LOC> iIcfg) {
        IcfgLocation icfgLocation;
        String string;
        Map<String, LOC> map = iIcfg.getProcedureEntryNodes();
        Map<String, LOC> map2 = iIcfg.getProcedureExitNodes();
        for (Map.Entry<String, LOC> entry : map.entrySet()) {
            string = entry.getKey();
            assert (entry.getValue() != null) : "Entry node for procedure " + string + " is null";
            icfgLocation = (IcfgLocation)map2.get(string);
            if (icfgLocation != null) continue;
            assert (false) : "No corresponding exit node for entry node with procedure " + string;
            return false;
        }
        for (Map.Entry<String, LOC> entry : map2.entrySet()) {
            string = entry.getKey();
            assert (entry.getValue() != null) : "Exit node for procedure " + string + " is null";
            icfgLocation = (IcfgLocation)map.get(string);
            if (icfgLocation != null) continue;
            assert (false) : "No corresponding entry node for exit node with procedure " + string;
            return false;
        }
        return true;
    }

    public static <LOC extends IcfgLocation> boolean isEntry(LOC LOC, IIcfg<LOC> iIcfg) {
        IcfgLocation icfgLocation = (IcfgLocation)iIcfg.getProcedureEntryNodes().get(LOC.getProcedure());
        return icfgLocation.equals(LOC);
    }

    public static <LOC extends IcfgLocation> boolean isExit(LOC LOC, IIcfg<LOC> iIcfg) {
        IcfgLocation icfgLocation = (IcfgLocation)iIcfg.getProcedureExitNodes().get(LOC.getProcedure());
        return LOC.equals(icfgLocation);
    }

    public static <LOC extends IcfgLocation> boolean isEnabled(Set<LOC> set, IcfgEdge icfgEdge) {
        if (icfgEdge instanceof IIcfgForkTransitionThreadCurrent || icfgEdge instanceof IIcfgJoinTransitionThreadCurrent) {
            return false;
        }
        if (icfgEdge instanceof IIcfgForkTransitionThreadOther) {
            Set set2 = set.stream().map(IcfgLocation::getProcedure).collect(Collectors.toSet());
            String string = icfgEdge.getSucceedingProcedure();
            return set.contains(icfgEdge.getSource()) && !set2.contains(string);
        }
        if (icfgEdge instanceof IIcfgJoinTransitionThreadOther) {
            IIcfgJoinTransitionThreadOther iIcfgJoinTransitionThreadOther = (IIcfgJoinTransitionThreadOther)((Object)icfgEdge);
            IIcfgJoinTransitionThreadCurrent iIcfgJoinTransitionThreadCurrent = iIcfgJoinTransitionThreadOther.getCorrespondingIIcfgJoinTransitionCurrentThread();
            return set.contains(iIcfgJoinTransitionThreadOther.getSource()) && set.contains(iIcfgJoinTransitionThreadCurrent.getSource());
        }
        return set.contains(icfgEdge.getSource());
    }

    public static boolean canReachCached(IcfgLocation icfgLocation, Predicate<IcfgEdge> predicate, Predicate<IcfgEdge> predicate2, Function<IcfgLocation, Script.LBool> function, BiConsumer<IcfgLocation, Boolean> biConsumer) {
        IcfgLocation icfgLocation2;
        Script.LBool lBool = function.apply(icfgLocation);
        if (lBool != Script.LBool.UNKNOWN) {
            return lBool == Script.LBool.SAT;
        }
        DfsBookkeeping dfsBookkeeping = new DfsBookkeeping();
        LinkedList<IcfgLocation> linkedList = new LinkedList<IcfgLocation>();
        linkedList.add(icfgLocation);
        Script.LBool lBool2 = Script.LBool.UNSAT;
        while (!linkedList.isEmpty() && lBool2 != Script.LBool.SAT) {
            icfgLocation2 = (IcfgLocation)linkedList.getLast();
            Script.LBool lBool3 = function.apply(icfgLocation2);
            if (lBool3 != Script.LBool.UNKNOWN) {
                lBool2 = lBool3 == Script.LBool.SAT || lBool2 != Script.LBool.UNKNOWN ? lBool3 : lBool2;
                linkedList.removeLast();
                dfsBookkeeping.push((Object)icfgLocation2);
                dfsBookkeeping.backtrack();
                continue;
            }
            if (dfsBookkeeping.isVisited((Object)icfgLocation2)) {
                assert (lBool2 != Script.LBool.SAT) : "After reachability confirmed, should be fast-backtracking";
                linkedList.removeLast();
                if (dfsBookkeeping.peek() != icfgLocation2) continue;
                boolean bl = dfsBookkeeping.backtrack();
                Script.LBool lBool4 = lBool2 = bl ? Script.LBool.UNSAT : Script.LBool.UNKNOWN;
                if (lBool2 == Script.LBool.UNKNOWN) continue;
                assert (lBool2 == Script.LBool.UNSAT);
                biConsumer.accept(icfgLocation2, false);
                continue;
            }
            dfsBookkeeping.push((Object)icfgLocation2);
            List list = icfgLocation2.getOutgoingEdges();
            ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>(list.size());
            for (IcfgEdge icfgEdge : list) {
                IcfgLocation icfgLocation3 = (IcfgLocation)icfgEdge.getTarget();
                if (predicate.test(icfgEdge)) {
                    lBool2 = Script.LBool.SAT;
                    break;
                }
                if (predicate2.test(icfgEdge)) continue;
                if (!dfsBookkeeping.isVisited((Object)icfgLocation3)) {
                    arrayList.add(icfgLocation3);
                    continue;
                }
                int n = dfsBookkeeping.stackIndexOf((Object)icfgLocation3);
                if (n != -1) {
                    assert (function.apply(icfgLocation3) == Script.LBool.UNKNOWN) : "Loop heads on stack must have UNKNOWN status";
                    lBool2 = Script.LBool.UNKNOWN;
                    dfsBookkeeping.updateLoopHead((Object)icfgLocation2, new Pair((Object)n, (Object)icfgLocation3));
                    continue;
                }
                Script.LBool lBool5 = function.apply(icfgLocation3);
                assert (lBool5 != Script.LBool.SAT) : "Backtracked node must not have SAT status";
                lBool2 = lBool5 == Script.LBool.UNKNOWN ? Script.LBool.UNKNOWN : lBool2;
                dfsBookkeeping.backPropagateLoopHead((Object)icfgLocation2, (Object)icfgLocation3);
            }
            if (lBool2 == Script.LBool.SAT) continue;
            linkedList.addAll(arrayList);
        }
        while (!dfsBookkeeping.isStackEmpty()) {
            assert (lBool2 == Script.LBool.SAT) : "Fast-backtracking must only happen in case of reachability";
            icfgLocation2 = (IcfgLocation)dfsBookkeeping.peek();
            dfsBookkeeping.backtrack();
            biConsumer.accept(icfgLocation2, true);
        }
        icfgLocation2 = function.apply(icfgLocation);
        assert (icfgLocation2 != Script.LBool.UNKNOWN) : "reachability should be clearly determined";
        assert (icfgLocation2 == lBool2) : "contradictory reachability: " + String.valueOf(icfgLocation2) + " != " + String.valueOf(lBool2);
        return lBool2 == Script.LBool.SAT;
    }

    public static <LOC extends IcfgLocation> Set<String> getAllThreadInstances(IIcfg<LOC> iIcfg) {
        Stream<String> stream = iIcfg.getCfgSmtToolkit().getConcurrencyInformation().getThreadInstanceMap().values().stream().flatMap(Collection::stream).map(ThreadInstance::getThreadInstanceName);
        String string = ((IcfgLocation)DataStructureUtils.getOneAndOnly(iIcfg.getInitialNodes(), (String)"initial node")).getProcedure();
        return Stream.concat(Stream.of(string), stream).collect(Collectors.toSet());
    }

    public static Set<IIcfgForkTransitionThreadCurrent<IcfgLocation>> getForksInLoop(IIcfg<?> iIcfg) {
        HashSet<IIcfgForkTransitionThreadCurrent<IcfgLocation>> hashSet = new HashSet<IIcfgForkTransitionThreadCurrent<IcfgLocation>>();
        Map<String, ?> map = iIcfg.getProcedureEntryNodes();
        block0: for (IIcfgForkTransitionThreadCurrent<IcfgLocation> iIcfgForkTransitionThreadCurrent : iIcfg.getCfgSmtToolkit().getConcurrencyInformation().getThreadInstanceMap().keySet()) {
            ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
            HashSet<IcfgLocation> hashSet2 = new HashSet<IcfgLocation>();
            arrayDeque.add(iIcfgForkTransitionThreadCurrent.getTarget());
            arrayDeque.add((IcfgLocation)map.get(iIcfgForkTransitionThreadCurrent.getNameOfForkedProcedure()));
            while (!arrayDeque.isEmpty()) {
                IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.pop();
                if (!hashSet2.add(icfgLocation)) continue;
                if (icfgLocation.equals(iIcfgForkTransitionThreadCurrent.getSource())) {
                    hashSet.add(iIcfgForkTransitionThreadCurrent);
                    continue block0;
                }
                for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                    arrayDeque.add((IcfgLocation)icfgEdge.getTarget());
                    if (!(icfgEdge instanceof IIcfgForkTransitionThreadCurrent)) continue;
                    IIcfgForkTransitionThreadCurrent iIcfgForkTransitionThreadCurrent2 = (IIcfgForkTransitionThreadCurrent)((Object)icfgEdge);
                    arrayDeque.add((IcfgLocation)map.get(iIcfgForkTransitionThreadCurrent2.getNameOfForkedProcedure()));
                }
            }
        }
        return hashSet;
    }
}

