/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiClosure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementFKV;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementNCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.MultiOptimizationLevelRankingGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveNonLiveStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeSevpa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementFkvStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementNcsbStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BuchiComplementationEvaluation<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final String mResult;

    public <SF extends IBuchiComplementNcsbStateFactory<STATE> & IBuchiComplementFkvStateFactory<STATE>> BuchiComplementationEvaluation(AutomataLibraryServices automataLibraryServices, SF SF, INwaOutgoingTransitionProvider<LETTER, STATE> iNwaOutgoingTransitionProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, iNwaOutgoingTransitionProvider);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.evaluate(SF);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Operand " + this.mOperand.sizeInformation() + ". Result " + this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }

    @Override
    public String getResult() {
        return this.mResult;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    private <SF extends IBuchiComplementNcsbStateFactory<STATE> & IBuchiComplementFkvStateFactory<STATE>> String evaluate(SF SF) throws AutomataOperationCanceledException {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        this.evaluateBs(SF, linkedHashMap);
        MultiOptimizationLevelRankingGenerator.FkvOptimization[] fkvOptimizationArray = MultiOptimizationLevelRankingGenerator.FkvOptimization.values();
        int n = fkvOptimizationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MultiOptimizationLevelRankingGenerator.FkvOptimization fkvOptimization = fkvOptimizationArray[n2];
            this.evaluateFkv(SF, linkedHashMap, fkvOptimization);
            ++n2;
        }
        return BuchiComplementationEvaluation.prettyPrint(linkedHashMap);
    }

    private void evaluateBs(IBuchiComplementNcsbStateFactory<STATE> iBuchiComplementNcsbStateFactory, LinkedHashMap<String, Integer> linkedHashMap) throws AutomataOperationCanceledException {
        Object object = new BuchiComplementNCSB<LETTER, STATE>(this.mServices, iBuchiComplementNcsbStateFactory, this.mOperand).getResult();
        this.addToResultsWithSizeReduction(linkedHashMap, "BuchiComplementBS", (NestedWordAutomatonReachableStates<LETTER, STATE>)object);
    }

    private <SF extends IDeterminizeStateFactory<STATE> & IBuchiComplementFkvStateFactory<STATE>> void evaluateFkv(SF SF, LinkedHashMap<String, Integer> linkedHashMap, MultiOptimizationLevelRankingGenerator.FkvOptimization fkvOptimization) throws AutomataOperationCanceledException {
        String string = "FKV_" + String.valueOf((Object)fkvOptimization);
        Object object = new BuchiComplementFKV<LETTER, STATE>(this.mServices, SF, this.mOperand, fkvOptimization.toString(), Integer.MAX_VALUE).getResult();
        this.addToResultsWithSizeReduction(linkedHashMap, string, (NestedWordAutomatonReachableStates<LETTER, STATE>)object);
    }

    private static String prettyPrint(LinkedHashMap<String, Integer> linkedHashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Integer> entry : linkedHashMap.entrySet()) {
            stringBuilder.append(entry.getKey()).append(" ").append(entry.getValue()).append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    private void addToResultsWithSizeReduction(LinkedHashMap<String, Integer> linkedHashMap, String string, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates) throws AutomataOperationCanceledException {
        this.addToResults(linkedHashMap, string, nestedWordAutomatonReachableStates);
        Object object = new RemoveNonLiveStates<LETTER, STATE>(this.mServices, nestedWordAutomatonReachableStates).getResult();
        this.addToResults(linkedHashMap, string + "_nonLiveRemoved", (INestedWordAutomaton<LETTER, STATE>)object);
        Object object2 = new BuchiClosure(this.mServices, object).getResult();
        IDoubleDeckerAutomaton iDoubleDeckerAutomaton = new RemoveUnreachable(this.mServices, object2).getResult();
        Object object3 = new MinimizeSevpa(this.mServices, (IMinimizationStateFactory)((NestedWordAutomatonReachableStates)iDoubleDeckerAutomaton).getStateFactory(), iDoubleDeckerAutomaton).getResult();
        this.addToResults(linkedHashMap, string + "_MsSizeReduction", (INestedWordAutomaton<LETTER, STATE>)object3);
    }

    private void addToResults(LinkedHashMap<String, Integer> linkedHashMap, String string, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        int n = iNestedWordAutomaton.getStates().size();
        linkedHashMap.put(string, n);
    }
}

