/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays;

final class UnionFind {
    private int[] mRoot;
    private final int[] mSize;
    private final int[] mStack;

    UnionFind(int n) {
        this.mRoot = new int[n];
        this.mSize = new int[n];
        this.mStack = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.mRoot[n2] = n2;
            this.mSize[n2] = 1;
            ++n2;
        }
    }

    void merge(int n, int n2) {
        this.updateRoot(n);
        this.updateRoot(n2);
        n = this.mRoot[n];
        n2 = this.mRoot[n2];
        if (n == n2) {
            return;
        }
        if (this.mSize[n] < this.mSize[n2]) {
            this.mRoot[n] = n2;
            int n3 = n2;
            this.mSize[n3] = this.mSize[n3] + this.mSize[n];
        } else {
            this.mRoot[n2] = n;
            int n4 = n;
            this.mSize[n4] = this.mSize[n4] + this.mSize[n2];
        }
    }

    int[] extractRoots() {
        int n = 0;
        while (n < this.mRoot.length) {
            this.updateRoot(n);
            ++n;
        }
        int[] nArray = this.mRoot;
        this.mRoot = null;
        return nArray;
    }

    private void updateRoot(int n) {
        int n2 = 0;
        while (n != this.mRoot[n]) {
            this.mStack[n2] = n;
            ++n2;
            n = this.mRoot[n];
        }
        while (n2-- > 0) {
            this.mRoot[this.mStack[n2]] = n;
        }
    }
}

