/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.IMinimize;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaHopcroftParallel;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.parallel.MinimizeDfaIncrementalParallel;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.Interrupt;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;

public final class MinimizeDfaParallel<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    public static final boolean PREFER_HELPER_THREADS = false;
    public static final boolean PREFER_ALGORITHM_THREADS = false;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private boolean mResultConstructed;
    private Callable<INestedWordAutomaton<LETTER, STATE>> mResultGetter;
    private final ArrayList<WorkingThread> mThreads;
    private final LinkedBlockingQueue<Runnable> mTaskQueue;
    private final Thread mHopcroftThread;
    private final Thread mIncrementalThread;
    private MinimizeDfaHopcroftParallel<LETTER, STATE> mHopcroftAlgorithm;
    private MinimizeDfaIncrementalParallel<LETTER, STATE> mIncrementalAlgorithm;
    private final Interrupt mInterrupt;
    private boolean mHopcroftAlgorithmInitialized;
    private boolean mIncrementalAlgorithmInitialized;
    private double[] mCpuTime;
    private final StringBuilder mSb;
    private ArrayList<STATE> mInt2state;
    private HashMap<STATE, Integer> mState2int;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public MinimizeDfaParallel(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        super(automataLibraryServices, iMinimizationStateFactory);
        void object2;
        this.mOperand = iNestedWordAutomaton;
        this.printStartMessage();
        if (!this.isFiniteAutomaton()) {
            throw new UnsupportedOperationException("This class only supports minimization of finite automata.");
        }
        this.mInterrupt = new Interrupt();
        MinimizeDfaHopcroftParallel.setParallelFlag(true);
        MinimizeDfaIncrementalParallel.setParallelFlag(true);
        this.mHopcroftThread = new AlgorithmTask(this, Algorithm.HOPCROFT);
        this.mIncrementalThread = new AlgorithmTask(this, Algorithm.INCREMENTAL);
        this.initialize();
        this.mTaskQueue = new LinkedBlockingQueue();
        this.mThreads = new ArrayList();
        boolean n = false;
        while (object2 < Math.max(1, 4)) {
            this.mThreads.add(new WorkingThread("HelperThread" + (int)object2));
            this.mThreads.get((int)object2).start();
            ++object2;
        }
        this.mLogger.info((Object)"MAIN: Start execution of Incremental algorithm.");
        this.mIncrementalThread.start();
        this.mLogger.info((Object)"MAIN: Start execution of Hopcroft algorithm.");
        this.mHopcroftThread.start();
        MinimizeDfaParallel minimizeDfaParallel = this;
        synchronized (minimizeDfaParallel) {
            if (!this.mResultConstructed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.mLogger.info((Object)"MAIN: Result available. Start interrupting working threads.");
        this.measureTime();
        for (Thread thread : this.mThreads) {
            thread.interrupt();
        }
        Thread thread = this.mIncrementalThread;
        synchronized (thread) {
            this.mIncrementalThread.notify();
        }
        Thread thread2 = this.mHopcroftThread;
        synchronized (thread2) {
            this.mHopcroftThread.notify();
        }
        this.mIncrementalThread.interrupt();
        this.mHopcroftThread.interrupt();
        this.mInterrupt.setStatus();
        this.mLogger.info((Object)"MAIN: Interrupting working threads finished.");
        this.mLogger.info((Object)"MAIN: Start postprocessing result.");
        try {
            this.directResultConstruction(this.mResultGetter.call());
            this.mResultConstructed = true;
        }
        catch (Exception exception) {}
        this.mSb = this.createConsoleOutput();
        this.mLogger.info((Object)this.mSb);
        MinimizeDfaHopcroftParallel.setParallelFlag(false);
        MinimizeDfaIncrementalParallel.setParallelFlag(false);
        this.mLogger.info((Object)("MAIN: " + this.exitMessage()));
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    public double[] getCpuTime() {
        return this.mCpuTime;
    }

    public String getRunTime() {
        return this.mSb.toString();
    }

    public MinimizeDfaHopcroftParallel<LETTER, STATE> getHopcroft() {
        return this.mHopcroftAlgorithm;
    }

    public MinimizeDfaIncrementalParallel<LETTER, STATE> getIncremental() {
        return this.mIncrementalAlgorithm;
    }

    private void measureTime() {
        this.mCpuTime = new double[this.mThreads.size() + 2];
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        int n = 0;
        while (n < this.mThreads.size()) {
            this.mCpuTime[n] = threadMXBean.getThreadCpuTime(this.mThreads.get(n).getId());
            ++n;
        }
        this.mCpuTime[this.mThreads.size()] = threadMXBean.getThreadCpuTime(this.mIncrementalThread.getId());
        this.mCpuTime[this.mThreads.size() + 1] = threadMXBean.getThreadCpuTime(this.mHopcroftThread.getId());
    }

    private StringBuilder createConsoleOutput() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CPU TIME needed for computation:\n");
        int n = 0;
        while (n < this.mThreads.size()) {
            stringBuilder.append("Thread " + (n + 1) + ": " + this.mCpuTime[n] + "ns\n");
            ++n;
        }
        stringBuilder.append("Incremental Thread: " + this.mCpuTime[this.mThreads.size()] + "ns\n");
        stringBuilder.append("Hopcroft Thread: " + this.mCpuTime[this.mThreads.size() + 1] + "ns\n");
        long l = 0L;
        double[] dArray = this.mCpuTime;
        int n2 = this.mCpuTime.length;
        int n3 = 0;
        while (n3 < n2) {
            double d = dArray[n3];
            l = (long)((double)l + d);
            ++n3;
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long l2 = threadMXBean.getThreadCpuTime(Thread.currentThread().getId());
        stringBuilder.append("Main Thread: " + l2 + "ns\nTOTAL: " + (l += l2) + "ns = " + (double)l / Math.pow(10.0, 9.0) + "sec");
        return stringBuilder;
    }

    private void initialize() {
        int n = this.mOperand.size();
        this.mInt2state = new ArrayList(n);
        this.mState2int = new HashMap(n);
        int n2 = -1;
        for (STATE STATE : this.mOperand.getStates()) {
            this.mInt2state.add(STATE);
            this.mState2int.put(STATE, ++n2);
        }
    }

    private static enum Algorithm {
        HOPCROFT,
        INCREMENTAL;

    }

    private class AlgorithmTask
    extends Thread {
        private final MinimizeDfaParallel<LETTER, STATE> mMainThread;
        private final Algorithm mChooseAlgorithm;
        private IMinimize mAlgorithm;

        AlgorithmTask(MinimizeDfaParallel<LETTER, STATE> minimizeDfaParallel2, Algorithm algorithm) {
            super(algorithm.toString());
            this.mChooseAlgorithm = algorithm;
            this.mMainThread = minimizeDfaParallel2;
            try {
                this.setDaemon(true);
            }
            catch (Exception exception) {}
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object;
                if (this.mChooseAlgorithm.equals((Object)Algorithm.HOPCROFT)) {
                    MinimizeDfaParallel.this.mLogger.debug((Object)"moep1");
                    this.mAlgorithm = new MinimizeDfaHopcroftParallel(MinimizeDfaParallel.this.mServices, MinimizeDfaParallel.this.mStateFactory, MinimizeDfaParallel.this.mOperand, MinimizeDfaParallel.this.mInterrupt, MinimizeDfaParallel.this.mInt2state, MinimizeDfaParallel.this.mState2int);
                    if (this.isInterrupted()) {
                        return;
                    }
                    MinimizeDfaParallel.this.mLogger.debug((Object)"moep2");
                    MinimizeDfaParallel.this.mHopcroftAlgorithm = (MinimizeDfaHopcroftParallel)this.mAlgorithm;
                    MinimizeDfaParallel.this.mHopcroftAlgorithmInitialized = true;
                    object = MinimizeDfaParallel.this.mInterrupt;
                    synchronized (object) {
                        if (MinimizeDfaParallel.this.mIncrementalAlgorithmInitialized) {
                            MinimizeDfaParallel.this.mLogger.debug((Object)"moep3a");
                            MinimizeDfaIncrementalParallel minimizeDfaIncrementalParallel = MinimizeDfaParallel.this.mIncrementalAlgorithm;
                            synchronized (minimizeDfaIncrementalParallel) {
                                MinimizeDfaParallel.this.mInterrupt.notify();
                            }
                        } else {
                            MinimizeDfaParallel.this.mLogger.debug((Object)"moep3b");
                            MinimizeDfaParallel.this.mInterrupt.wait();
                        }
                    }
                    MinimizeDfaParallel.this.mLogger.debug((Object)"moep4");
                    MinimizeDfaParallel.this.mHopcroftAlgorithm.minimizeParallel(MinimizeDfaParallel.this.mTaskQueue, MinimizeDfaParallel.this.mIncrementalAlgorithm);
                    MinimizeDfaParallel.this.mLogger.debug((Object)"moep5");
                } else {
                    MinimizeDfaParallel.this.mLogger.debug((Object)"miep1");
                    this.mAlgorithm = new MinimizeDfaIncrementalParallel(MinimizeDfaParallel.this.mServices, MinimizeDfaParallel.this.mStateFactory, MinimizeDfaParallel.this.mOperand, MinimizeDfaParallel.this.mInterrupt, MinimizeDfaParallel.this.mInt2state, MinimizeDfaParallel.this.mState2int);
                    if (this.isInterrupted()) {
                        return;
                    }
                    MinimizeDfaParallel.this.mLogger.debug((Object)"miep2");
                    MinimizeDfaParallel.this.mIncrementalAlgorithm = (MinimizeDfaIncrementalParallel)this.mAlgorithm;
                    MinimizeDfaParallel.this.mIncrementalAlgorithmInitialized = true;
                    object = MinimizeDfaParallel.this.mInterrupt;
                    synchronized (object) {
                        if (MinimizeDfaParallel.this.mHopcroftAlgorithmInitialized) {
                            MinimizeDfaParallel.this.mLogger.debug((Object)"miep3a");
                            MinimizeDfaParallel.this.mInterrupt.notify();
                        } else {
                            MinimizeDfaParallel.this.mLogger.debug((Object)"miep3b");
                            MinimizeDfaParallel.this.mInterrupt.wait();
                        }
                    }
                    MinimizeDfaParallel.this.mLogger.debug((Object)"miep4");
                    MinimizeDfaParallel.this.mIncrementalAlgorithm.minimizeParallel(MinimizeDfaParallel.this.mTaskQueue, MinimizeDfaParallel.this.mHopcroftAlgorithm);
                    MinimizeDfaParallel.this.mLogger.debug((Object)"miep5");
                }
                if (this.isInterrupted()) {
                    return;
                }
                object = this.mMainThread;
                synchronized (object) {
                    if (MinimizeDfaParallel.this.mResultGetter == null) {
                        MinimizeDfaParallel.this.mResultGetter = () -> (INestedWordAutomaton)this.mAlgorithm.getResult();
                        this.mMainThread.notify();
                    }
                }
                object = this;
                synchronized (object) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError((Object)"not yet implemented");
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                throw new AssertionError((Object)"not yet implemented");
            }
        }
    }

    private class WorkingThread
    extends Thread {
        WorkingThread(String string) {
            super(string);
            try {
                this.setDaemon(true);
            }
            catch (Exception exception) {}
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    assert (!this.isInterrupted());
                    Runnable runnable = MinimizeDfaParallel.this.mTaskQueue.take();
                    if (!this.isInterrupted()) {
                        runnable.run();
                    }
                    MinimizeDfaParallel.this.mLogger.info((Object)("MAIN: Size of task queue: " + MinimizeDfaParallel.this.mTaskQueue.size()));
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
            }
        }
    }
}

