/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling;

import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import java.util.List;

public interface IRefinementEngineResult<L extends IAction, T> {
    public Script.LBool getCounterexampleFeasibility();

    public T getInfeasibilityProof();

    public boolean providesIcfgProgramExecution();

    public IProgramExecution<L, Term> getIcfgProgramExecution();

    public boolean somePerfectSequenceFound();

    public List<QualifiedTracePredicates> getUsedTracePredicates();

    public IHoareTripleChecker getHoareTripleChecker();

    public IPredicateUnifier getPredicateUnifier();

    public static class BasicRefinementEngineResult<L extends IAction, T>
    implements IRefinementEngineResult<L, T> {
        private final Script.LBool mFeasibility;
        private final T mProof;
        private final IProgramExecution<L, Term> mProgramExecution;
        private final boolean mIsSequencePerfect;
        private final List<QualifiedTracePredicates> mUsedTracePredicates;
        private final Lazy<IHoareTripleChecker> mHtc;
        private final Lazy<IPredicateUnifier> mPredicateUnifier;

        public BasicRefinementEngineResult(Script.LBool lBool, T t, IProgramExecution<L, Term> iProgramExecution, boolean bl, List<QualifiedTracePredicates> list, Lazy<IHoareTripleChecker> lazy, Lazy<IPredicateUnifier> lazy2) {
            this.mFeasibility = lBool;
            this.mProof = t;
            this.mProgramExecution = iProgramExecution;
            this.mIsSequencePerfect = bl;
            this.mUsedTracePredicates = list;
            this.mHtc = lazy;
            this.mPredicateUnifier = lazy2;
        }

        @Override
        public Script.LBool getCounterexampleFeasibility() {
            return this.mFeasibility;
        }

        @Override
        public T getInfeasibilityProof() {
            return this.mProof;
        }

        @Override
        public boolean providesIcfgProgramExecution() {
            return this.mProgramExecution != null;
        }

        @Override
        public IProgramExecution<L, Term> getIcfgProgramExecution() {
            return this.mProgramExecution;
        }

        @Override
        public boolean somePerfectSequenceFound() {
            return this.mIsSequencePerfect;
        }

        @Override
        public List<QualifiedTracePredicates> getUsedTracePredicates() {
            return this.mUsedTracePredicates;
        }

        @Override
        public IHoareTripleChecker getHoareTripleChecker() {
            return (IHoareTripleChecker)this.mHtc.get();
        }

        @Override
        public IPredicateUnifier getPredicateUnifier() {
            return (IPredicateUnifier)this.mPredicateUnifier.get();
        }
    }
}

