/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.AStar;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.CollectionEdgeDenier;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.CompositEdgeDenier;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.IEdgeDenier;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.IGraph;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.IHeuristic;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.RcfgWrapper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.ZeroHeuristic;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.RootNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class RCFGLoopDetector {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final Map<BoogieIcfgLocation, Map<IcfgEdge, IcfgEdge>> mLoopEntryExit;

    public RCFGLoopDetector(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mLoopEntryExit = new HashMap<BoogieIcfgLocation, Map<IcfgEdge, IcfgEdge>>();
    }

    public Map<BoogieIcfgLocation, Map<IcfgEdge, IcfgEdge>> getResult() {
        return this.mLoopEntryExit;
    }

    public void process(BoogieIcfgContainer boogieIcfgContainer) throws Throwable {
        RootNode rootNode = boogieIcfgContainer.constructRootNode();
        HashSet<BoogieIcfgLocation> hashSet = new HashSet<BoogieIcfgLocation>(boogieIcfgContainer.getLoopLocations());
        List<BoogieIcfgLocation> list = this.orderLoopHeads(hashSet, rootNode);
        ArrayList<Object> arrayList = new ArrayList<IcfgEdge>();
        for (BoogieIcfgLocation boogieIcfgLocation : list) {
            HashMap<IcfgEdge, IcfgEdge> hashMap = new HashMap<IcfgEdge, IcfgEdge>();
            this.mLoopEntryExit.put(boogieIcfgLocation, hashMap);
            this.process(boogieIcfgLocation, hashMap, arrayList);
            arrayList = new ArrayList(hashMap.values());
        }
        this.printResult(this.mLoopEntryExit);
    }

    private List<BoogieIcfgLocation> orderLoopHeads(Set<BoogieIcfgLocation> set, RootNode rootNode) {
        ArrayList<BoogieIcfgLocation> arrayList = new ArrayList<BoogieIcfgLocation>();
        Stack<Object> stack = new Stack<Object>();
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        stack.push(rootNode);
        while (!stack.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)stack.pop();
            if (hashSet.contains(icfgLocation)) continue;
            hashSet.add(icfgLocation);
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                stack.push((IcfgLocation)icfgEdge.getTarget());
            }
            if (!set.contains(icfgLocation)) continue;
            arrayList.add((BoogieIcfgLocation)icfgLocation);
        }
        return arrayList;
    }

    private void process(BoogieIcfgLocation boogieIcfgLocation, Map<IcfgEdge, IcfgEdge> map, List<IcfgEdge> list) {
        AStar<IcfgLocation, IcfgEdge> aStar = new AStar<IcfgLocation, IcfgEdge>(this.mLogger, (IcfgLocation)boogieIcfgLocation, (IcfgLocation)boogieIcfgLocation, (IHeuristic<IcfgLocation, IcfgEdge>)new ZeroHeuristic(), (IGraph<IcfgLocation, IcfgEdge>)new RcfgWrapper(), (Collection<IcfgEdge>)list, (IProgressAwareTimer)this.mServices.getProgressMonitorService());
        List<IcfgEdge> list2 = aStar.findPath();
        if (list.isEmpty() && (list2 == null || list2.isEmpty())) {
            this.mLogger.warn((Object)("RCFGNode " + String.valueOf(boogieIcfgLocation) + " is not a valid loop head, because there is no cycle leading back to it"));
        }
        while (list2 != null) {
            IcfgEdge icfgEdge = this.addToResult(list2, map);
            list.add(icfgEdge);
            aStar = new AStar<IcfgLocation, IcfgEdge>(this.mLogger, (IcfgLocation)boogieIcfgLocation, (IcfgLocation)boogieIcfgLocation, (IHeuristic<IcfgLocation, IcfgEdge>)new ZeroHeuristic(), (IGraph<IcfgLocation, IcfgEdge>)new RcfgWrapper(), this.createDenier(list), (IProgressAwareTimer)this.mServices.getProgressMonitorService());
            list2 = aStar.findPath();
        }
    }

    private IEdgeDenier<IcfgEdge> createDenier(List<IcfgEdge> list) {
        ArrayList<IEdgeDenier<IEdgeDenier<Object>>> arrayList = new ArrayList<IEdgeDenier<IEdgeDenier<Object>>>();
        arrayList.add(new CollectionEdgeDenier<IcfgEdge>(list));
        arrayList.add(new RcfgCallReturnDenier());
        return new CompositEdgeDenier<IcfgEdge>(arrayList);
    }

    private IcfgEdge addToResult(List<IcfgEdge> list, Map<IcfgEdge, IcfgEdge> map) {
        IcfgEdge icfgEdge = list.get(0);
        IcfgEdge icfgEdge2 = list.get(list.size() - 1);
        assert (((IcfgLocation)icfgEdge.getSource()).equals((Object)icfgEdge2.getTarget()));
        map.put(icfgEdge, icfgEdge2);
        return icfgEdge;
    }

    private void printResult(Map<BoogieIcfgLocation, Map<IcfgEdge, IcfgEdge>> map) {
        if (!this.mLogger.isDebugEnabled()) {
            return;
        }
        this.mLogger.debug((Object)"---------------");
        for (BoogieIcfgLocation boogieIcfgLocation : map.keySet()) {
            this.mLogger.debug((Object)("Loophead " + String.valueOf(boogieIcfgLocation)));
            Map<IcfgEdge, IcfgEdge> map2 = map.get(boogieIcfgLocation);
            for (Map.Entry<IcfgEdge, IcfgEdge> entry : map2.entrySet()) {
                this.mLogger.debug((Object)("* " + entry.getKey().hashCode() + " >< " + entry.getValue().hashCode()));
            }
        }
        this.mLogger.debug((Object)"---------------");
    }

    private static final class RcfgCallReturnDenier
    implements IEdgeDenier<IcfgEdge> {
        private RcfgCallReturnDenier() {
        }

        @Override
        public boolean isForbidden(IcfgEdge icfgEdge, Iterator<IcfgEdge> iterator) {
            if (icfgEdge instanceof Return) {
                Call call = ((Return)icfgEdge).getCorrespondingCall();
                while (iterator.hasNext()) {
                    if (!call.equals(iterator.next())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

