/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Iterator;
import java.util.function.Predicate;

public class FilteredIterable<T>
implements Iterable<T> {
    final Iterable<T> mIterable;
    final Predicate<T> mPredicate;

    public FilteredIterable(Iterable<T> iterable, Predicate<T> predicate) {
        this.mIterable = iterable;
        this.mPredicate = predicate;
    }

    @Override
    public Iterator<T> iterator() {
        return new PredicateIterator(this.mIterable);
    }

    private final class PredicateIterator
    implements Iterator<T> {
        final Iterator<T> mIterator;
        T mNext;

        public PredicateIterator(Iterable<T> iterable) {
            this.mIterator = iterable.iterator();
            this.getNextThatSatisfiesPredicate();
        }

        private void getNextThatSatisfiesPredicate() {
            if (this.mIterator.hasNext()) {
                this.mNext = this.mIterator.next();
                while (this.mNext != null && !FilteredIterable.this.mPredicate.test(this.mNext)) {
                    this.mNext = this.mIterator.hasNext() ? this.mIterator.next() : null;
                }
            } else {
                this.mNext = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public T next() {
            Object t = this.mNext;
            this.getNextThatSatisfiesPredicate();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

