/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.sifa;

import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovableResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import de.uni_freiburg.informatik.ultimate.plugins.sifa.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.sifa.SifaBuilder;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.Map;

public class SifaObserver
extends BaseObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private SifaBuilder.SifaComponents mSifaComponents;

    public SifaObserver(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
    }

    public boolean process(IElement iElement) throws Exception {
        if (iElement instanceof IIcfg) {
            this.processIcfg((IIcfg<IcfgLocation>)((IIcfg)iElement));
            return false;
        }
        return true;
    }

    private void processIcfg(IIcfg<IcfgLocation> iIcfg) {
        this.mLogger.info((Object)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getSingleLinePreferenceString());
        this.mSifaComponents = new SifaBuilder(this.mServices, this.mLogger).construct(iIcfg, (IProgressAwareTimer)this.mServices.getProgressMonitorService());
        Map map = this.mSifaComponents.getIcfgInterpreter().interpret();
        this.reportStats(this.mSifaComponents.getStats());
        this.reportResults(map);
    }

    private void reportStats(SifaStats sifaStats) {
        StatisticsData statisticsData = new StatisticsData();
        statisticsData.aggregateBenchmarkData((IStatisticsDataProvider)sifaStats);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult(Activator.PLUGIN_ID, "Symbolic Interpretation with Fluid Abstractions", (ICsvProviderProvider)statisticsData));
    }

    private void reportResults(Map<IcfgLocation, IPredicate> map) {
        boolean bl = true;
        for (Map.Entry<IcfgLocation, IPredicate> entry : map.entrySet()) {
            bl &= this.reportSingleResult(entry);
        }
        if (bl) {
            this.mLogger.info((Object)"\u2714 All error locations are guaranteed to be unreachable.");
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new AllSpecificationsHoldResult(Activator.PLUGIN_ID, ""));
        } else {
            this.mLogger.info((Object)"\u2718 Some error locations might be reachable, see reported results.");
        }
    }

    private boolean reportSingleResult(Map.Entry<IcfgLocation, IPredicate> entry) {
        PositiveResult positiveResult;
        IDomain.ResultForAlteredInputs resultForAlteredInputs = this.mSifaComponents.getDomain().isEqBottom(entry.getValue());
        if (resultForAlteredInputs.isTrueForAbstraction()) {
            positiveResult = new PositiveResult(Activator.PLUGIN_ID, (IElement)entry.getKey(), this.mServices.getBacktranslationService());
        } else {
            StringBuilder stringBuilder = new StringBuilder("Over-approximation of reachable states at this location is ").append(entry.getValue());
            if (resultForAlteredInputs.wasAbstracted()) {
                stringBuilder.append("\nFinal emptiness check over-approximated again to ").append(resultForAlteredInputs.getLhs());
            }
            positiveResult = new UnprovableResult(Activator.PLUGIN_ID, (IElement)entry.getKey(), this.mServices.getBacktranslationService(), (IProgramExecution)IcfgProgramExecution.create(IcfgEdge.class), stringBuilder.toString());
        }
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)positiveResult);
        return resultForAlteredInputs.isTrueForAbstraction();
    }
}

