/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.yaml;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.UltimateCore;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.FormatVersion;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Location;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Segment;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.ViolationSequence;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Waypoint;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointBranching;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointFunctionEnter;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointFunctionReturn;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointTarget;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import de.uni_freiburg.informatik.ultimate.witnessprinter.ProgramStatePrinter;
import de.uni_freiburg.informatik.ultimate.witnessprinter.preferences.PreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.MetadataProvider;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.YamlWitnessWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class YamlViolationWitnessGenerator<TE, E> {
    private final IPreferenceProvider mPreferences;
    private final IBacktranslationValueProvider<TE, E> mStringProvider;
    private final IProgramExecution<TE, E> mExecution;
    private final ILogger mLogger;
    private final YamlWitnessWriter mWriter;
    private final ProgramStatePrinter<TE, E> mProgramStatePrinter;
    private static final boolean PRODUCE_ASSUMPTIONS = false;

    public YamlViolationWitnessGenerator(IProgramExecution<TE, E> iProgramExecution, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mStringProvider = iProgramExecution.getBacktranslationValueProvider();
        this.mProgramStatePrinter = new ProgramStatePrinter<TE, E>(this.mStringProvider);
        this.mLogger = iLogger;
        this.mExecution = iProgramExecution;
        this.mPreferences = PreferenceInitializer.getPreferences(iUltimateServiceProvider);
        String string = this.mStringProvider.getFileNameFromStep(this.mExecution.getTraceElement(0).getStep());
        String string2 = this.mPreferences.getString("Graph data producer");
        String string3 = this.mPreferences.getString("Graph data programhash");
        String string4 = this.mPreferences.getString("Graph data specification");
        String string5 = this.mPreferences.getString("Graph data architecture");
        FormatVersion formatVersion = FormatVersion.fromString((String)this.mPreferences.getString("YAML Format version"));
        String string6 = new UltimateCore().getUltimateVersionString();
        Map<String, String> map = Map.of(string, string3);
        this.mWriter = YamlWitnessWriter.construct(formatVersion, new MetadataProvider(formatVersion, string2, string6, map, string4, string5, "C"));
    }

    private Witness getWitness() {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        int n = 0;
        while (n < this.mExecution.getLength()) {
            AtomicTraceElement atomicTraceElement = this.mExecution.getTraceElement(n);
            Object object = atomicTraceElement.getStep();
            int n2 = this.mStringProvider.getLineNumberFromStep(object, atomicTraceElement.getStepInfo());
            int n3 = this.mStringProvider.getColumnNumberFromStep(object, atomicTraceElement.getStepInfo());
            String string = this.mStringProvider.getFunctionFromStep(object);
            String string2 = this.mStringProvider.getFileNameFromStep(object);
            Location location = new Location(string2, Integer.valueOf(n2), Integer.valueOf(n3), string);
            if (n == this.mExecution.getLength() - 1) {
                arrayList.add(new Segment(List.of(), (Waypoint)new WaypointTarget(location)));
            }
            if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE)) {
                arrayList.add(new Segment(List.of(), (Waypoint)new WaypointBranching("false", location)));
            }
            if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE)) {
                arrayList.add(new Segment(List.of(), (Waypoint)new WaypointBranching("true", location)));
            }
            if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.PROC_CALL)) {
                arrayList.add(new Segment(List.of(), (Waypoint)new WaypointFunctionEnter(location)));
            }
            if (atomicTraceElement.hasStepInfo(AtomicTraceElement.StepInfo.PROC_RETURN)) {
                arrayList.add(new Segment(List.of(), (Waypoint)new WaypointFunctionReturn(this.mProgramStatePrinter.stateAsExpression(this.mExecution.getProgramState(n), "\\result"::equals), location)));
            }
            ++n;
        }
        this.mLogger.info("Generated YAML witness of length %d.", new Object[]{arrayList.size()});
        return new Witness(List.of(new ViolationSequence(arrayList)));
    }

    public String makeYamlString() {
        return this.mWriter.toString(this.getWitness());
    }
}

