/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.IBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public abstract class BinaryRelation
implements IBinaryRelation {
    protected final RelationSymbol mRelationSymbol;
    protected final Term mLhs;
    protected final Term mRhs;

    protected BinaryRelation(RelationSymbol relationSymbol, Term term, Term term2) {
        this.mRelationSymbol = relationSymbol;
        this.mLhs = term;
        this.mRhs = term2;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public Term getLhs() {
        return this.mLhs;
    }

    public Term getRhs() {
        return this.mRhs;
    }

    public static Term constructLessNormalForm(Script script, RelationSymbol relationSymbol, Term term, Term term2) throws AssertionError {
        return switch (relationSymbol) {
            case RelationSymbol.EQ, RelationSymbol.DISTINCT -> {
                Term[] var5_4 = CommuhashUtils.sortByHashCode(term, term2);
                yield BinaryRelation.toTerm(script, relationSymbol, var5_4[0], var5_4[1]);
            }
            case RelationSymbol.LEQ, RelationSymbol.LESS, RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVSLE, RelationSymbol.BVSLT -> BinaryRelation.toTerm(script, relationSymbol, term, term2);
            case RelationSymbol.GEQ, RelationSymbol.GREATER, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> {
                RelationSymbol var6_6 = relationSymbol.swapParameters();
                yield BinaryRelation.toTerm(script, var6_6, term2, term);
            }
            default -> throw new AssertionError((Object)"unknown relation symbol");
        };
    }

    public Term toTerm(Script script) {
        return BinaryRelation.constructLessNormalForm(script, this.getRelationSymbol(), this.getLhs(), this.getRhs());
    }

    public static Term toTerm(Script script, RelationSymbol relationSymbol, Term term, Term term2) {
        return switch (relationSymbol) {
            case RelationSymbol.DISTINCT -> {
                Term var5_4 = SmtUtils.binaryEquality(script, term, term2);
                yield script.term("not", new Term[]{var5_4});
            }
            case RelationSymbol.EQ, RelationSymbol.LEQ, RelationSymbol.GEQ, RelationSymbol.LESS, RelationSymbol.GREATER, RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> script.term(relationSymbol.toString(), new Term[]{term, term2});
            default -> throw new AssertionError((Object)"unknown relation symbol");
        };
    }

    @Override
    public SolvedBinaryRelation solveForSubject(Script script, Term term) {
        if (this.getLhs().equals(term)) {
            if (SmtUtils.isSubterm(this.getRhs(), term)) {
                return null;
            }
            return new SolvedBinaryRelation(term, this.getRhs(), this.getRelationSymbol(), new MultiCaseSolvedBinaryRelation.IntricateOperation[0]);
        }
        if (this.getRhs().equals(term)) {
            if (SmtUtils.isSubterm(this.getLhs(), term)) {
                return null;
            }
            return new SolvedBinaryRelation(term, this.getLhs(), this.getRelationSymbol().swapParameters(), new MultiCaseSolvedBinaryRelation.IntricateOperation[0]);
        }
        return null;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mLhs == null ? 0 : this.mLhs.hashCode());
        n = 31 * n + (this.mRelationSymbol == null ? 0 : this.mRelationSymbol.toString().hashCode());
        n = 31 * n + (this.mRhs == null ? 0 : this.mRhs.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BinaryRelation binaryRelation = (BinaryRelation)object;
        if (this.mLhs == null ? binaryRelation.mLhs != null : !this.mLhs.equals(binaryRelation.mLhs)) {
            return false;
        }
        if (this.mRelationSymbol != binaryRelation.mRelationSymbol) {
            return false;
        }
        return !(this.mRhs == null ? binaryRelation.mRhs != null : !this.mRhs.equals(binaryRelation.mRhs));
    }
}

