/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetRun;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.util.BFSIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class EnumerateRuns {
    public static <L, P> Iterable<PetriNetRun<L, P>> enumerate(IPetriNet<L, P> iPetriNet) {
        return () -> new RunEnumerator(iPetriNet);
    }

    public static <L, P> Stream<PetriNetRun<L, P>> stream(IPetriNet<L, P> iPetriNet) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new RunEnumerator<L, P>(iPetriNet), 1040), false);
    }

    private static class RunEnumerator<L, P>
    extends BFSIterator<Marking<P>, Transition<L, P>, PetriNetRun<L, P>> {
        private final IPetriNet<L, P> mNet;

        public RunEnumerator(IPetriNet<L, P> iPetriNet) {
            super(List.of(RunEnumerator.getInitialMarking(iPetriNet)));
            this.mNet = iPetriNet;
        }

        private static <P> Marking<P> getInitialMarking(IPetriNet<?, P> iPetriNet) {
            return new Marking(ImmutableSet.copyOf(iPetriNet.getInitialPlaces()));
        }

        protected Iterable<Transition<L, P>> getOutgoing(Marking<P> marking) {
            return this.mNet.getTransitions().stream().filter(marking::isTransitionEnabled).collect(Collectors.toList());
        }

        protected Marking<P> getSuccessor(Marking<P> marking, Transition<L, P> transition) {
            try {
                return marking.fireTransition(transition);
            }
            catch (PetriNetNot1SafeException petriNetNot1SafeException) {
                throw new IllegalStateException(petriNetNot1SafeException);
            }
        }

        protected boolean isTarget(Marking<P> marking) {
            return this.mNet.isAccepting((P)marking);
        }

        protected PetriNetRun<L, P> finish(ImmutableList<Pair<Marking<P>, Transition<L, P>>> immutableList, Marking<P> marking) {
            Object[] objectArray = new Object[immutableList.size()];
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            arrayList.add(marking);
            int n = immutableList.size() - 1;
            for (Pair pair : immutableList) {
                objectArray[n] = ((Transition)pair.getSecond()).getSymbol();
                arrayList2.add(0, (Transition)pair.getSecond());
                arrayList.add(0, (Marking)pair.getFirst());
                --n;
            }
            return new PetriNetRun(arrayList, new Word<Object>(objectArray), arrayList2);
        }
    }
}

